-- MySQL dump 10.11
--
-- Host: localhost    Database: dolibarr
-- ------------------------------------------------------
-- Server version	5.0.45-community-nt

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `llx_accountingaccount`
--

DROP TABLE IF EXISTS `llx_accountingaccount`;
CREATE TABLE `llx_accountingaccount` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_pcg_version` varchar(12) NOT NULL,
  `pcg_type` varchar(20) NOT NULL,
  `pcg_subtype` varchar(20) NOT NULL,
  `account_number` varchar(20) NOT NULL,
  `account_parent` varchar(20) default NULL,
  `label` varchar(128) NOT NULL,
  PRIMARY KEY  (`rowid`),
  KEY `idx_accountingaccount_fk_pcg_version` (`fk_pcg_version`),
  CONSTRAINT `fk_accountingaccount_fk_pcg_version` FOREIGN KEY (`fk_pcg_version`) REFERENCES `llx_accountingsystem` (`pcg_version`)
) ENGINE=InnoDB AUTO_INCREMENT=103 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_accountingaccount`
--

LOCK TABLES `llx_accountingaccount` WRITE;
/*!40000 ALTER TABLE `llx_accountingaccount` DISABLE KEYS */;
INSERT INTO `llx_accountingaccount` VALUES (1,'PCG99-ABREGE','CAPIT','CAPITAL','101','1','Capital'),(2,'PCG99-ABREGE','CAPIT','XXXXXX','105','1','Ecarts de réévaluation'),(3,'PCG99-ABREGE','CAPIT','XXXXXX','1061','1','Réserve légale'),(4,'PCG99-ABREGE','CAPIT','XXXXXX','1063','1','Réserves statutaires ou contractuelles'),(5,'PCG99-ABREGE','CAPIT','XXXXXX','1064','1','Réserves réglementées'),(6,'PCG99-ABREGE','CAPIT','XXXXXX','1068','1','Autres réserves'),(7,'PCG99-ABREGE','CAPIT','XXXXXX','108','1','Compte de l\'exploitant'),(8,'PCG99-ABREGE','CAPIT','XXXXXX','12','1','Résultat de l\'exercice'),(9,'PCG99-ABREGE','CAPIT','XXXXXX','145','1','Amortissements dérogatoires'),(10,'PCG99-ABREGE','CAPIT','XXXXXX','146','1','Provision spéciale de réévaluation'),(11,'PCG99-ABREGE','CAPIT','XXXXXX','147','1','Plus-values réinvesties'),(12,'PCG99-ABREGE','CAPIT','XXXXXX','148','1','Autres provisions réglementées'),(13,'PCG99-ABREGE','CAPIT','XXXXXX','15','1','Provisions pour risques et charges'),(14,'PCG99-ABREGE','CAPIT','XXXXXX','16','1','Emprunts et dettes assimilees'),(15,'PCG99-ABREGE','IMMO','XXXXXX','20','2','Immobilisations incorporelles'),(16,'PCG99-ABREGE','IMMO','XXXXXX','201','20','Frais d\'établissement'),(17,'PCG99-ABREGE','IMMO','XXXXXX','206','20','Droit au bail'),(18,'PCG99-ABREGE','IMMO','XXXXXX','207','20','Fonds commercial'),(19,'PCG99-ABREGE','IMMO','XXXXXX','208','20','Autres immobilisations incorporelles'),(20,'PCG99-ABREGE','IMMO','XXXXXX','21','2','Immobilisations corporelles'),(21,'PCG99-ABREGE','IMMO','XXXXXX','23','2','Immobilisations en cours'),(22,'PCG99-ABREGE','IMMO','XXXXXX','27','2','Autres immobilisations financieres'),(23,'PCG99-ABREGE','IMMO','XXXXXX','280','2','Amortissements des immobilisations incorporelles'),(24,'PCG99-ABREGE','IMMO','XXXXXX','281','2','Amortissements des immobilisations corporelles'),(25,'PCG99-ABREGE','IMMO','XXXXXX','290','2','Provisions pour dépréciation des immobilisations incorporelles'),(26,'PCG99-ABREGE','IMMO','XXXXXX','291','2','Provisions pour dépréciation des immobilisations corporelles'),(27,'PCG99-ABREGE','IMMO','XXXXXX','297','2','Provisions pour dépréciation des autres immobilisations financières'),(28,'PCG99-ABREGE','STOCK','XXXXXX','31','3','Matieres premières'),(29,'PCG99-ABREGE','STOCK','XXXXXX','32','3','Autres approvisionnements'),(30,'PCG99-ABREGE','STOCK','XXXXXX','33','3','En-cours de production de biens'),(31,'PCG99-ABREGE','STOCK','XXXXXX','34','3','En-cours de production de services'),(32,'PCG99-ABREGE','STOCK','XXXXXX','35','3','Stocks de produits'),(33,'PCG99-ABREGE','STOCK','XXXXXX','37','3','Stocks de marchandises'),(34,'PCG99-ABREGE','STOCK','XXXXXX','391','3','Provisions pour dépréciation des matières premières'),(35,'PCG99-ABREGE','STOCK','XXXXXX','392','3','Provisions pour dépréciation des autres approvisionnements'),(36,'PCG99-ABREGE','STOCK','XXXXXX','393','3','Provisions pour dépréciation des en-cours de production de biens'),(37,'PCG99-ABREGE','STOCK','XXXXXX','394','3','Provisions pour dépréciation des en-cours de production de services'),(38,'PCG99-ABREGE','STOCK','XXXXXX','395','3','Provisions pour dépréciation des stocks de produits'),(39,'PCG99-ABREGE','STOCK','XXXXXX','397','3','Provisions pour dépréciation des stocks de marchandises'),(40,'PCG99-ABREGE','TIERS','SUPPLIER','400','4','Fournisseurs et Comptes rattachés'),(41,'PCG99-ABREGE','TIERS','XXXXXX','409','4','Fournisseurs débiteurs'),(42,'PCG99-ABREGE','TIERS','CUSTOMER','410','4','Clients et Comptes rattachés'),(43,'PCG99-ABREGE','TIERS','XXXXXX','419','4','Clients créditeurs'),(44,'PCG99-ABREGE','TIERS','XXXXXX','421','4','Personnel'),(45,'PCG99-ABREGE','TIERS','XXXXXX','428','4','Personnel'),(46,'PCG99-ABREGE','TIERS','XXXXXX','43','4','Sécurité sociale et autres organismes sociaux'),(47,'PCG99-ABREGE','TIERS','XXXXXX','444','4','Etat - impôts sur bénéfice'),(48,'PCG99-ABREGE','TIERS','XXXXXX','445','4','Etat - Taxes sur chiffre affaire'),(49,'PCG99-ABREGE','TIERS','XXXXXX','447','4','Autres impôts, taxes et versements assimilés'),(50,'PCG99-ABREGE','TIERS','XXXXXX','45','4','Groupe et associes'),(51,'PCG99-ABREGE','TIERS','XXXXXX','455','45','Associés'),(52,'PCG99-ABREGE','TIERS','XXXXXX','46','4','Débiteurs divers et créditeurs divers'),(53,'PCG99-ABREGE','TIERS','XXXXXX','47','4','Comptes transitoires ou d\'attente'),(54,'PCG99-ABREGE','TIERS','XXXXXX','481','4','Charges à répartir sur plusieurs exercices'),(55,'PCG99-ABREGE','TIERS','XXXXXX','486','4','Charges constatées d\'avance'),(56,'PCG99-ABREGE','TIERS','XXXXXX','487','4','Produits constatés d\'avance'),(57,'PCG99-ABREGE','TIERS','XXXXXX','491','4','Provisions pour dépréciation des comptes de clients'),(58,'PCG99-ABREGE','TIERS','XXXXXX','496','4','Provisions pour dépréciation des comptes de débiteurs divers'),(59,'PCG99-ABREGE','FINAN','XXXXXX','50','5','Valeurs mobilières de placement'),(60,'PCG99-ABREGE','FINAN','BANK','51','5','Banques, établissements financiers et assimilés'),(61,'PCG99-ABREGE','FINAN','CASH','53','5','Caisse'),(62,'PCG99-ABREGE','FINAN','XXXXXX','54','5','Régies d\'avance et accréditifs'),(63,'PCG99-ABREGE','FINAN','XXXXXX','58','5','Virements internes'),(64,'PCG99-ABREGE','FINAN','XXXXXX','590','5','Provisions pour dépréciation des valeurs mobilières de placement'),(65,'PCG99-ABREGE','CHARGE','PRODUCT','60','6','Achats'),(66,'PCG99-ABREGE','CHARGE','XXXXXX','603','60','Variations des stocks'),(67,'PCG99-ABREGE','CHARGE','SERVICE','61','6','Services extérieurs'),(68,'PCG99-ABREGE','CHARGE','XXXXXX','62','6','Autres services extérieurs'),(69,'PCG99-ABREGE','CHARGE','XXXXXX','63','6','Impôts, taxes et versements assimiles'),(70,'PCG99-ABREGE','CHARGE','XXXXXX','641','6','Rémunérations du personnel'),(71,'PCG99-ABREGE','CHARGE','XXXXXX','644','6','Rémunération du travail de l\'exploitant'),(72,'PCG99-ABREGE','CHARGE','SOCIAL','645','6','Charges de sécurité sociale et de prévoyance'),(73,'PCG99-ABREGE','CHARGE','XXXXXX','646','6','Cotisations sociales personnelles de l\'exploitant'),(74,'PCG99-ABREGE','CHARGE','XXXXXX','65','6','Autres charges de gestion courante'),(75,'PCG99-ABREGE','CHARGE','XXXXXX','66','6','Charges financières'),(76,'PCG99-ABREGE','CHARGE','XXXXXX','67','6','Charges exceptionnelles'),(77,'PCG99-ABREGE','CHARGE','XXXXXX','681','6','Dotations aux amortissements et aux provisions'),(78,'PCG99-ABREGE','CHARGE','XXXXXX','686','6','Dotations aux amortissements et aux provisions'),(79,'PCG99-ABREGE','CHARGE','XXXXXX','687','6','Dotations aux amortissements et aux provisions'),(80,'PCG99-ABREGE','CHARGE','XXXXXX','691','6','Participation des salariés aux résultats'),(81,'PCG99-ABREGE','CHARGE','XXXXXX','695','6','Impôts sur les bénéfices'),(82,'PCG99-ABREGE','CHARGE','XXXXXX','697','6','Imposition forfaitaire annuelle des sociétés'),(83,'PCG99-ABREGE','CHARGE','XXXXXX','699','6','Produits'),(84,'PCG99-ABREGE','PROD','PRODUCT','701','7','Ventes de produits finis'),(85,'PCG99-ABREGE','PROD','SERVICE','706','7','Prestations de services'),(86,'PCG99-ABREGE','PROD','PRODUCT','707','7','Ventes de marchandises'),(87,'PCG99-ABREGE','PROD','PRODUCT','708','7','Produits des activités annexes'),(88,'PCG99-ABREGE','PROD','XXXXXX','709','7','Rabais, remises et ristournes accordés par l\'entreprise'),(89,'PCG99-ABREGE','PROD','XXXXXX','713','7','Variation des stocks'),(90,'PCG99-ABREGE','PROD','XXXXXX','72','7','Production immobilisée'),(91,'PCG99-ABREGE','PROD','XXXXXX','73','7','Produits nets partiels sur opérations à long terme'),(92,'PCG99-ABREGE','PROD','XXXXXX','74','7','Subventions d\'exploitation'),(93,'PCG99-ABREGE','PROD','XXXXXX','75','7','Autres produits de gestion courante'),(94,'PCG99-ABREGE','PROD','XXXXXX','753','75','Jetons de présence et rémunérations d\'administrateurs, gérants,...'),(95,'PCG99-ABREGE','PROD','XXXXXX','754','75','Ristournes perçues des coopératives'),(96,'PCG99-ABREGE','PROD','XXXXXX','755','75','Quotes-parts de résultat sur opérations faites en commun'),(97,'PCG99-ABREGE','PROD','XXXXXX','76','7','Produits financiers'),(98,'PCG99-ABREGE','PROD','XXXXXX','77','7','Produits exceptionnels'),(99,'PCG99-ABREGE','PROD','XXXXXX','781','7','Reprises sur amortissements et provisions'),(100,'PCG99-ABREGE','PROD','XXXXXX','786','7','Reprises sur provisions pour risques'),(101,'PCG99-ABREGE','PROD','XXXXXX','787','7','Reprises sur provisions'),(102,'PCG99-ABREGE','PROD','XXXXXX','79','7','Transferts de charges');
/*!40000 ALTER TABLE `llx_accountingaccount` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_accountingdebcred`
--

DROP TABLE IF EXISTS `llx_accountingdebcred`;
CREATE TABLE `llx_accountingdebcred` (
  `fk_transaction` int(11) NOT NULL,
  `account_number` varchar(20) NOT NULL,
  `amount` double NOT NULL,
  `direction` varchar(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_accountingdebcred`
--

LOCK TABLES `llx_accountingdebcred` WRITE;
/*!40000 ALTER TABLE `llx_accountingdebcred` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_accountingdebcred` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_accountingsystem`
--

DROP TABLE IF EXISTS `llx_accountingsystem`;
CREATE TABLE `llx_accountingsystem` (
  `pcg_version` varchar(12) NOT NULL,
  `fk_pays` int(11) NOT NULL,
  `label` varchar(128) NOT NULL,
  `datec` varchar(12) NOT NULL,
  `fk_author` varchar(20) default NULL,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `active` smallint(6) default '0',
  PRIMARY KEY  (`pcg_version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_accountingsystem`
--

LOCK TABLES `llx_accountingsystem` WRITE;
/*!40000 ALTER TABLE `llx_accountingsystem` DISABLE KEYS */;
INSERT INTO `llx_accountingsystem` VALUES ('PCG99-ABREGE',1,'The simple accountancy french plan','2013-08-28',NULL,'2013-08-28 17:08:21',0);
/*!40000 ALTER TABLE `llx_accountingsystem` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_accountingtransaction`
--

DROP TABLE IF EXISTS `llx_accountingtransaction`;
CREATE TABLE `llx_accountingtransaction` (
  `rowid` int(11) NOT NULL auto_increment,
  `label` varchar(128) NOT NULL,
  `datec` date NOT NULL,
  `fk_author` varchar(20) NOT NULL,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `fk_source` int(11) NOT NULL,
  `sourcetype` varchar(16) NOT NULL,
  `url` varchar(255) default NULL,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_accountingtransaction`
--

LOCK TABLES `llx_accountingtransaction` WRITE;
/*!40000 ALTER TABLE `llx_accountingtransaction` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_accountingtransaction` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_actioncomm`
--

DROP TABLE IF EXISTS `llx_actioncomm`;
CREATE TABLE `llx_actioncomm` (
  `id` int(11) NOT NULL auto_increment,
  `entity` int(11) NOT NULL default '1',
  `datep` datetime default NULL,
  `datep2` datetime default NULL,
  `datea` datetime default NULL,
  `datea2` datetime default NULL,
  `fk_action` int(11) default NULL,
  `label` varchar(128) NOT NULL,
  `datec` datetime default NULL,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `fk_user_author` int(11) default NULL,
  `fk_user_mod` int(11) default NULL,
  `fk_project` int(11) default NULL,
  `fk_soc` int(11) default NULL,
  `fk_contact` int(11) default NULL,
  `fk_parent` int(11) NOT NULL default '0',
  `fk_user_action` int(11) default NULL,
  `fk_user_done` int(11) default NULL,
  `priority` smallint(6) default NULL,
  `fulldayevent` smallint(6) NOT NULL default '0',
  `punctual` smallint(6) NOT NULL default '1',
  `percent` smallint(6) NOT NULL default '0',
  `location` varchar(128) default NULL,
  `durationp` double default NULL,
  `durationa` double default NULL,
  `note` text,
  `fk_element` int(11) default NULL,
  `elementtype` varchar(16) default NULL,
  PRIMARY KEY  (`id`),
  KEY `idx_actioncomm_datea` (`datea`),
  KEY `idx_actioncomm_fk_soc` (`fk_soc`),
  KEY `idx_actioncomm_fk_contact` (`fk_contact`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_actioncomm`
--

LOCK TABLES `llx_actioncomm` WRITE;
/*!40000 ALTER TABLE `llx_actioncomm` DISABLE KEYS */;
INSERT INTO `llx_actioncomm` VALUES (1,1,'2013-10-19 17:41:04','2013-10-19 17:41:04',NULL,NULL,50,'Commande CO1304-0001 validée','2013-10-19 17:41:04','2013-10-19 15:41:04',1,NULL,NULL,2,NULL,0,NULL,1,0,0,1,-1,'',NULL,NULL,'Commande CO1304-0001 validée\nAuteur: admin',1,'order');
/*!40000 ALTER TABLE `llx_actioncomm` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_adherent`
--

DROP TABLE IF EXISTS `llx_adherent`;
CREATE TABLE `llx_adherent` (
  `rowid` int(11) NOT NULL auto_increment,
  `entity` int(11) NOT NULL default '1',
  `ref_ext` varchar(30) default NULL,
  `civilite` varchar(6) default NULL,
  `nom` varchar(50) default NULL,
  `prenom` varchar(50) default NULL,
  `login` varchar(50) default NULL,
  `pass` varchar(50) default NULL,
  `fk_adherent_type` int(11) NOT NULL,
  `morphy` varchar(3) NOT NULL,
  `societe` varchar(50) default NULL,
  `fk_soc` int(11) default NULL,
  `adresse` text,
  `cp` varchar(30) default NULL,
  `ville` varchar(50) default NULL,
  `fk_departement` int(11) default NULL,
  `pays` int(11) default NULL,
  `email` varchar(255) default NULL,
  `phone` varchar(30) default NULL,
  `phone_perso` varchar(30) default NULL,
  `phone_mobile` varchar(30) default NULL,
  `naiss` date default NULL,
  `photo` varchar(255) default NULL,
  `statut` smallint(6) NOT NULL default '0',
  `public` smallint(6) NOT NULL default '0',
  `datefin` datetime default NULL,
  `note` text,
  `datevalid` datetime default NULL,
  `datec` datetime default NULL,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `fk_user_author` int(11) default NULL,
  `fk_user_mod` int(11) default NULL,
  `fk_user_valid` int(11) default NULL,
  `import_key` varchar(14) default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_adherent_login` (`login`,`entity`),
  UNIQUE KEY `uk_adherent_fk_soc` (`fk_soc`),
  KEY `idx_adherent_fk_adherent_type` (`fk_adherent_type`),
  CONSTRAINT `adherent_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`),
  CONSTRAINT `fk_adherent_adherent_type` FOREIGN KEY (`fk_adherent_type`) REFERENCES `llx_adherent_type` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_adherent`
--

LOCK TABLES `llx_adherent` WRITE;
/*!40000 ALTER TABLE `llx_adherent` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_adherent` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_adherent_extrafields`
--

DROP TABLE IF EXISTS `llx_adherent_extrafields`;
CREATE TABLE `llx_adherent_extrafields` (
  `rowid` int(11) NOT NULL auto_increment,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  PRIMARY KEY  (`rowid`),
  KEY `idx_adherent_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_adherent_extrafields`
--

LOCK TABLES `llx_adherent_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_adherent_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_adherent_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_adherent_type`
--

DROP TABLE IF EXISTS `llx_adherent_type`;
CREATE TABLE `llx_adherent_type` (
  `rowid` int(11) NOT NULL auto_increment,
  `entity` int(11) NOT NULL default '1',
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `statut` smallint(6) NOT NULL default '0',
  `libelle` varchar(50) NOT NULL,
  `cotisation` varchar(3) NOT NULL default 'yes',
  `vote` varchar(3) NOT NULL default 'yes',
  `note` text,
  `mail_valid` text,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_adherent_type_libelle` (`libelle`,`entity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_adherent_type`
--

LOCK TABLES `llx_adherent_type` WRITE;
/*!40000 ALTER TABLE `llx_adherent_type` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_adherent_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_bank`
--

DROP TABLE IF EXISTS `llx_bank`;
CREATE TABLE `llx_bank` (
  `rowid` int(11) NOT NULL auto_increment,
  `datec` datetime default NULL,
  `datev` date default NULL,
  `dateo` date default NULL,
  `amount` double(24,8) NOT NULL default '0.00000000',
  `label` varchar(255) default NULL,
  `fk_account` int(11) default NULL,
  `fk_user_author` int(11) default NULL,
  `fk_user_rappro` int(11) default NULL,
  `fk_type` varchar(6) default NULL,
  `num_releve` varchar(50) default NULL,
  `num_chq` varchar(50) default NULL,
  `rappro` tinyint(4) default '0',
  `note` text,
  `fk_bordereau` int(11) default '0',
  `banque` varchar(255) default NULL,
  `emetteur` varchar(255) default NULL,
  `author` varchar(40) default NULL,
  PRIMARY KEY  (`rowid`),
  KEY `idx_bank_datev` (`datev`),
  KEY `idx_bank_dateo` (`dateo`),
  KEY `idx_bank_fk_account` (`fk_account`),
  KEY `idx_bank_rappro` (`rappro`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_bank`
--

LOCK TABLES `llx_bank` WRITE;
/*!40000 ALTER TABLE `llx_bank` DISABLE KEYS */;
INSERT INTO `llx_bank` VALUES (1,'2013-10-19 16:21:43','2013-10-19','2013-10-19',0.00000000,'(Solde initial)',1,NULL,NULL,'SOLD',NULL,NULL,0,NULL,0,NULL,NULL,NULL),(2,'2013-10-19 16:35:25','2013-09-10','2013-09-10',3289.00000000,'(CustomerInvoicePayment)',1,1,NULL,'VIR',NULL,NULL,0,NULL,0,NULL,NULL,NULL);
/*!40000 ALTER TABLE `llx_bank` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_bank_account`
--

DROP TABLE IF EXISTS `llx_bank_account`;
CREATE TABLE `llx_bank_account` (
  `rowid` int(11) NOT NULL auto_increment,
  `datec` datetime default NULL,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `ref` varchar(12) NOT NULL,
  `label` varchar(30) NOT NULL,
  `entity` int(11) NOT NULL default '1',
  `bank` varchar(60) default NULL,
  `code_banque` varchar(7) default NULL,
  `code_guichet` varchar(6) default NULL,
  `number` varchar(255) default NULL,
  `cle_rib` varchar(5) default NULL,
  `bic` varchar(11) default NULL,
  `iban_prefix` varchar(34) default NULL,
  `country_iban` varchar(2) default NULL,
  `cle_iban` varchar(2) default NULL,
  `domiciliation` varchar(255) default NULL,
  `fk_departement` int(11) default NULL,
  `fk_pays` int(11) NOT NULL,
  `proprio` varchar(60) default NULL,
  `adresse_proprio` varchar(255) default NULL,
  `courant` smallint(6) NOT NULL default '0',
  `clos` smallint(6) NOT NULL default '0',
  `rappro` smallint(6) default '1',
  `url` varchar(128) default NULL,
  `account_number` varchar(8) default NULL,
  `currency_code` varchar(3) NOT NULL,
  `min_allowed` int(11) default '0',
  `min_desired` int(11) default '0',
  `comment` text,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_bank_account_label` (`label`,`entity`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_bank_account`
--

LOCK TABLES `llx_bank_account` WRITE;
/*!40000 ALTER TABLE `llx_bank_account` DISABLE KEYS */;
INSERT INTO `llx_bank_account` VALUES (1,'2013-10-19 16:21:43','2013-10-19 14:30:50','LCL_GRAY','Professionnel 1',1,'LCL','30002','02533','0000070888G','34','CRLYFRPP','FR05 3000 2025 3300 0007 0888 G34',NULL,NULL,'1 Place Edmond BOUR\r\n70100 GRAY',72,1,'CLEMENT Xavier','6 grande rue \r\n70100 GERMIGNEY',1,0,1,NULL,'706','EUR',0,0,'');
/*!40000 ALTER TABLE `llx_bank_account` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_bank_categ`
--

DROP TABLE IF EXISTS `llx_bank_categ`;
CREATE TABLE `llx_bank_categ` (
  `rowid` int(11) NOT NULL auto_increment,
  `label` varchar(255) default NULL,
  `entity` int(11) NOT NULL default '1',
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_bank_categ`
--

LOCK TABLES `llx_bank_categ` WRITE;
/*!40000 ALTER TABLE `llx_bank_categ` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_bank_categ` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_bank_class`
--

DROP TABLE IF EXISTS `llx_bank_class`;
CREATE TABLE `llx_bank_class` (
  `lineid` int(11) NOT NULL,
  `fk_categ` int(11) NOT NULL,
  UNIQUE KEY `uk_bank_class_lineid` (`lineid`,`fk_categ`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_bank_class`
--

LOCK TABLES `llx_bank_class` WRITE;
/*!40000 ALTER TABLE `llx_bank_class` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_bank_class` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_bank_url`
--

DROP TABLE IF EXISTS `llx_bank_url`;
CREATE TABLE `llx_bank_url` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_bank` int(11) default NULL,
  `url_id` int(11) default NULL,
  `url` varchar(255) default NULL,
  `label` varchar(255) default NULL,
  `type` varchar(20) NOT NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_bank_url` (`fk_bank`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_bank_url`
--

LOCK TABLES `llx_bank_url` WRITE;
/*!40000 ALTER TABLE `llx_bank_url` DISABLE KEYS */;
INSERT INTO `llx_bank_url` VALUES (1,2,1,'/dolibarr/compta/paiement/fiche.php?id=','(paiement)','payment'),(2,2,1,'/dolibarr/comm/fiche.php?socid=','PLASTIGRAY','company');
/*!40000 ALTER TABLE `llx_bank_url` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_bookmark`
--

DROP TABLE IF EXISTS `llx_bookmark`;
CREATE TABLE `llx_bookmark` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_soc` int(11) default NULL,
  `fk_user` int(11) NOT NULL,
  `dateb` datetime default NULL,
  `url` varchar(128) NOT NULL,
  `target` varchar(16) default NULL,
  `title` varchar(64) default NULL,
  `favicon` varchar(24) default NULL,
  `position` int(11) default '0',
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_bookmark_url` (`fk_user`,`url`),
  UNIQUE KEY `uk_bookmark_title` (`fk_user`,`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_bookmark`
--

LOCK TABLES `llx_bookmark` WRITE;
/*!40000 ALTER TABLE `llx_bookmark` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_bookmark` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_bordereau_cheque`
--

DROP TABLE IF EXISTS `llx_bordereau_cheque`;
CREATE TABLE `llx_bordereau_cheque` (
  `rowid` int(11) NOT NULL auto_increment,
  `datec` datetime NOT NULL,
  `date_bordereau` date default NULL,
  `number` varchar(16) NOT NULL,
  `entity` int(11) NOT NULL default '1',
  `amount` double(24,8) NOT NULL,
  `nbcheque` smallint(6) NOT NULL,
  `fk_bank_account` int(11) default NULL,
  `fk_user_author` int(11) default NULL,
  `note` text,
  `statut` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_bordereau_cheque` (`number`,`entity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_bordereau_cheque`
--

LOCK TABLES `llx_bordereau_cheque` WRITE;
/*!40000 ALTER TABLE `llx_bordereau_cheque` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_bordereau_cheque` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_boxes`
--

DROP TABLE IF EXISTS `llx_boxes`;
CREATE TABLE `llx_boxes` (
  `rowid` int(11) NOT NULL auto_increment,
  `box_id` int(11) NOT NULL,
  `position` smallint(6) NOT NULL,
  `box_order` varchar(3) NOT NULL,
  `fk_user` int(11) NOT NULL default '0',
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_boxes` (`box_id`,`position`,`fk_user`),
  KEY `idx_boxes_boxid` (`box_id`),
  KEY `idx_boxes_fk_user` (`fk_user`),
  CONSTRAINT `fk_boxes_box_id` FOREIGN KEY (`box_id`) REFERENCES `llx_boxes_def` (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_boxes`
--

LOCK TABLES `llx_boxes` WRITE;
/*!40000 ALTER TABLE `llx_boxes` DISABLE KEYS */;
INSERT INTO `llx_boxes` VALUES (1,4,0,'A03',0),(2,7,0,'A09',0),(3,6,0,'B04',0),(4,8,0,'A05',0),(5,14,0,'A07',0),(6,17,0,'B08',0),(7,15,0,'B06',0),(8,20,0,'B02',0),(9,22,0,'A01',0);
/*!40000 ALTER TABLE `llx_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_boxes_def`
--

DROP TABLE IF EXISTS `llx_boxes_def`;
CREATE TABLE `llx_boxes_def` (
  `rowid` int(11) NOT NULL auto_increment,
  `file` varchar(200) NOT NULL,
  `entity` int(11) NOT NULL default '1',
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `note` varchar(130) default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_boxes_def` (`file`,`entity`,`note`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_boxes_def`
--

LOCK TABLES `llx_boxes_def` WRITE;
/*!40000 ALTER TABLE `llx_boxes_def` DISABLE KEYS */;
INSERT INTO `llx_boxes_def` VALUES (1,'box_clients.php',1,'2013-08-28 18:01:36',NULL),(2,'box_prospect.php',1,'2013-08-28 18:01:36',NULL),(3,'box_contacts.php',1,'2013-08-28 18:01:36',NULL),(4,'box_propales.php',1,'2013-08-28 18:01:54',NULL),(6,'box_contracts.php',1,'2013-08-28 18:01:56',NULL),(7,'box_services_vendus.php',1,'2013-08-28 18:01:56',NULL),(8,'box_commandes.php',1,'2013-08-28 18:01:58',NULL),(14,'box_factures_imp.php',1,'2013-08-28 18:02:38',NULL),(15,'box_factures.php',1,'2013-08-28 18:02:38',NULL),(17,'box_comptes.php',1,'2013-08-28 18:02:40',NULL),(18,'box_fournisseurs.php',1,'2013-08-28 18:03:00',NULL),(19,'box_factures_fourn_imp.php',1,'2013-08-28 18:03:00',NULL),(20,'box_factures_fourn.php',1,'2013-08-28 18:03:00',NULL),(22,'box_bookmarks.php',1,'2013-08-28 18:05:16',NULL),(23,'box_actions.php',1,'2013-10-19 15:07:41',NULL);
/*!40000 ALTER TABLE `llx_boxes_def` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_action_trigger`
--

DROP TABLE IF EXISTS `llx_c_action_trigger`;
CREATE TABLE `llx_c_action_trigger` (
  `rowid` int(11) NOT NULL auto_increment,
  `code` varchar(32) NOT NULL,
  `label` varchar(128) NOT NULL,
  `description` varchar(255) default NULL,
  `elementtype` varchar(16) NOT NULL,
  `rang` int(11) default '0',
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_action_trigger_code` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_action_trigger`
--

LOCK TABLES `llx_c_action_trigger` WRITE;
/*!40000 ALTER TABLE `llx_c_action_trigger` DISABLE KEYS */;
INSERT INTO `llx_c_action_trigger` VALUES (1,'FICHEINTER_VALIDATE','Intervention validated','Executed when a intervention is validated','ficheinter',18),(2,'BILL_VALIDATE','Customer invoice validated','Executed when a customer invoice is approved','facture',6),(3,'ORDER_SUPPLIER_APPROVE','Supplier order request approved','Executed when a supplier order is approved','order_supplier',11),(4,'ORDER_SUPPLIER_REFUSE','Supplier order request refused','Executed when a supplier order is refused','order_supplier',12),(5,'ORDER_VALIDATE','Customer order validate','Executed when a customer order is validated','commande',4),(6,'PROPAL_VALIDATE','Customer proposal validated','Executed when a commercial proposal is validated','propal',2),(7,'WITHDRAW_TRANSMIT','Withdraw command transmitted','Executed when a withdrawal command is transmited','withdraw',25),(8,'WITHDRAW_CREDIT','Withdraw credited','Executed when a withdrawal is credited','withdraw',26),(9,'WITHDRAW_EMIT','Withdraw emit','Executed when a withdrawal is emited','withdraw',27),(10,'COMPANY_CREATE','Third party created','Executed when a third party is created','societe',1),(11,'CONTRACT_VALIDATE','Contract validated','Executed when a contract is validated','contrat',17),(12,'PROPAL_SENTBYMAIL','Commercial proposal sent by mail','Executed when a commercial proposal is sent by mail','propal',3),(13,'ORDER_SENTBYMAIL','Customer order sent by mail','Executed when a customer order is sent by mail ','commande',5),(14,'BILL_PAYED','Customer invoice payed','Executed when a customer invoice is payed','facture',7),(15,'BILL_CANCEL','Customer invoice canceled','Executed when a customer invoice is conceled','facture',8),(16,'BILL_SENTBYMAIL','Customer invoice sent by mail','Executed when a customer invoice is sent by mail','facture',9),(17,'ORDER_SUPPLIER_VALIDATE','Supplier order validated','Executed when a supplier order is validated','order_supplier',10),(18,'ORDER_SUPPLIER_SENTBYMAIL','Supplier order sent by mail','Executed when a supplier order is sent by mail','order_supplier',13),(19,'BILL_SUPPLIER_VALIDATE','Supplier invoice validated','Executed when a supplier invoice is validated','invoice_supplier',14),(20,'BILL_SUPPLIER_PAYED','Supplier invoice payed','Executed when a supplier invoice is payed','invoice_supplier',15),(21,'BILL_SUPPLIER_SENTBYMAIL','Supplier invoice sent by mail','Executed when a supplier invoice is sent by mail','invoice_supplier',16),(22,'SHIPPING_VALIDATE','Shipping validated','Executed when a shipping is validated','shipping',19),(23,'SHIPPING_SENTBYMAIL','Shipping sent by mail','Executed when a shipping is sent by mail','shipping',20),(24,'MEMBER_VALIDATE','Member validated','Executed when a member is validated','member',21),(25,'MEMBER_SUBSCRIPTION','Member subscribed','Executed when a member is subscribed','member',22),(26,'MEMBER_RESILIATE','Member resiliated','Executed when a member is resiliated','member',23),(27,'MEMBER_DELETE','Member deleted','Executed when a member is deleted','member',24);
/*!40000 ALTER TABLE `llx_c_action_trigger` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_actioncomm`
--

DROP TABLE IF EXISTS `llx_c_actioncomm`;
CREATE TABLE `llx_c_actioncomm` (
  `id` int(11) NOT NULL,
  `code` varchar(12) NOT NULL,
  `type` varchar(10) NOT NULL default 'system',
  `libelle` varchar(48) NOT NULL,
  `module` varchar(16) default NULL,
  `active` tinyint(4) NOT NULL default '1',
  `todo` tinyint(4) default NULL,
  `position` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_actioncomm`
--

LOCK TABLES `llx_c_actioncomm` WRITE;
/*!40000 ALTER TABLE `llx_c_actioncomm` DISABLE KEYS */;
INSERT INTO `llx_c_actioncomm` VALUES (1,'AC_TEL','system','Phone call',NULL,1,NULL,2),(2,'AC_FAX','system','Send Fax',NULL,1,NULL,3),(3,'AC_PROP','system','Send commercial proposal by email','propal',1,NULL,10),(4,'AC_EMAIL','system','Send Email',NULL,1,NULL,4),(5,'AC_RDV','system','Rendez-vous',NULL,1,NULL,1),(8,'AC_COM','system','Send customer order by email','order',1,NULL,8),(9,'AC_FAC','system','Send customer invoice by email','invoice',1,NULL,6),(10,'AC_SHIP','system','Send shipping by email','shipping',1,NULL,11),(30,'AC_SUP_ORD','system','Send supplier order by email','order_supplier',1,NULL,9),(31,'AC_SUP_INV','system','Send supplier invoice by email','invoice_supplier',1,NULL,7),(50,'AC_OTH','system','Other',NULL,1,NULL,5);
/*!40000 ALTER TABLE `llx_c_actioncomm` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_availability`
--

DROP TABLE IF EXISTS `llx_c_availability`;
CREATE TABLE `llx_c_availability` (
  `rowid` int(11) NOT NULL auto_increment,
  `code` varchar(30) NOT NULL,
  `label` varchar(60) NOT NULL,
  `active` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_c_availability` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_availability`
--

LOCK TABLES `llx_c_availability` WRITE;
/*!40000 ALTER TABLE `llx_c_availability` DISABLE KEYS */;
INSERT INTO `llx_c_availability` VALUES (1,'AV_NOW','Immediate',1),(2,'AV_1W','1 week',1),(3,'AV_2W','2 weeks',1),(4,'AV_3W','3 weeks',1);
/*!40000 ALTER TABLE `llx_c_availability` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_barcode_type`
--

DROP TABLE IF EXISTS `llx_c_barcode_type`;
CREATE TABLE `llx_c_barcode_type` (
  `rowid` int(11) NOT NULL auto_increment,
  `code` varchar(16) NOT NULL,
  `entity` int(11) NOT NULL default '1',
  `libelle` varchar(50) NOT NULL,
  `coder` varchar(16) NOT NULL,
  `example` varchar(16) NOT NULL,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_barcode_type`
--

LOCK TABLES `llx_c_barcode_type` WRITE;
/*!40000 ALTER TABLE `llx_c_barcode_type` DISABLE KEYS */;
INSERT INTO `llx_c_barcode_type` VALUES (1,'EAN8',1,'EAN8','0','1234567'),(2,'EAN13',1,'EAN13','0','123456789012'),(3,'UPC',1,'UPC','0','123456789012'),(4,'ISBN',1,'ISBN','0','123456789'),(5,'C39',1,'Code 39','0','1234567890'),(6,'C128',1,'Code 128','0','ABCD1234567890');
/*!40000 ALTER TABLE `llx_c_barcode_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_chargesociales`
--

DROP TABLE IF EXISTS `llx_c_chargesociales`;
CREATE TABLE `llx_c_chargesociales` (
  `id` int(11) NOT NULL auto_increment,
  `libelle` varchar(80) default NULL,
  `deductible` smallint(6) NOT NULL default '0',
  `active` tinyint(4) NOT NULL default '1',
  `code` varchar(12) NOT NULL,
  `fk_pays` int(11) NOT NULL default '1',
  `module` varchar(32) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=231 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_chargesociales`
--

LOCK TABLES `llx_c_chargesociales` WRITE;
/*!40000 ALTER TABLE `llx_c_chargesociales` DISABLE KEYS */;
INSERT INTO `llx_c_chargesociales` VALUES (1,'Allocations familiales',1,1,'TAXFAM',1,NULL),(2,'CSG Deductible',1,1,'TAXCSGD',1,NULL),(3,'CSG/CRDS NON Deductible',0,1,'TAXCSGND',1,NULL),(10,'Taxe apprentissage',0,1,'TAXAPP',1,NULL),(11,'Taxe professionnelle',0,1,'TAXPRO',1,NULL),(20,'Impots locaux/fonciers',0,1,'TAXFON',1,NULL),(25,'Impots revenus',0,1,'TAXREV',1,NULL),(30,'Assurance Sante',0,1,'TAXSECU',1,NULL),(40,'Mutuelle',0,1,'TAXMUT',1,NULL),(50,'Assurance vieillesse',0,1,'TAXRET',1,NULL),(60,'Assurance Chomage',0,1,'TAXCHOM',1,NULL),(201,'ONSS',1,1,'TAXBEONSS',2,NULL),(210,'Precompte professionnel',1,1,'TAXBEPREPRO',2,NULL),(220,'Prime d\'existence',1,1,'TAXBEPRIEXI',2,NULL),(230,'Precompte immobilier',1,1,'TAXBEPREIMMO',2,NULL);
/*!40000 ALTER TABLE `llx_c_chargesociales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_civilite`
--

DROP TABLE IF EXISTS `llx_c_civilite`;
CREATE TABLE `llx_c_civilite` (
  `rowid` int(11) NOT NULL,
  `code` varchar(6) NOT NULL,
  `civilite` varchar(50) default NULL,
  `active` tinyint(4) NOT NULL default '1',
  `module` varchar(32) default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_civilite`
--

LOCK TABLES `llx_c_civilite` WRITE;
/*!40000 ALTER TABLE `llx_c_civilite` DISABLE KEYS */;
INSERT INTO `llx_c_civilite` VALUES (1,'MME','Madame',1,NULL),(3,'MR','Monsieur',1,NULL),(5,'MLE','Mademoiselle',1,NULL),(7,'MTRE','Maître',1,NULL),(8,'DR','Docteur',1,NULL);
/*!40000 ALTER TABLE `llx_c_civilite` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_currencies`
--

DROP TABLE IF EXISTS `llx_c_currencies`;
CREATE TABLE `llx_c_currencies` (
  `code` varchar(2) NOT NULL,
  `code_iso` varchar(3) NOT NULL,
  `label` varchar(64) default NULL,
  `labelsing` varchar(64) default NULL,
  `active` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`code`),
  UNIQUE KEY `uk_c_currencies_code_iso` (`code_iso`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_currencies`
--

LOCK TABLES `llx_c_currencies` WRITE;
/*!40000 ALTER TABLE `llx_c_currencies` DISABLE KEYS */;
INSERT INTO `llx_c_currencies` VALUES ('AD','AUD','Dollars australiens',NULL,1),('AE','AED','Arabes emirats dirham',NULL,1),('BD','BBD','Barbadian or Bajan Dollar',NULL,1),('BT','THB','Bath thailandais',NULL,1),('CD','DKK','Couronnes dannoises',NULL,1),('CF','XAF','Francs cfa beac',NULL,1),('CN','NOK','Couronnes norvegiennes',NULL,1),('CS','SEK','Couronnes suedoises',NULL,1),('CZ','CZK','Couronnes tcheques',NULL,1),('DA','DZD','Dinar algérien',NULL,1),('DC','CAD','Dollars canadiens',NULL,1),('DH','MAD','Dirham',NULL,1),('DR','GRD','Drachme (grece)',NULL,1),('DS','SGD','Dollars singapour',NULL,1),('DU','USD','Dollars us',NULL,1),('EC','XEU','Ecus',NULL,1),('EG','EGP','Livre egyptienne',NULL,1),('ES','PTE','Escudos',NULL,0),('EU','EUR','Euros',NULL,1),('FB','BEF','Francs belges',NULL,0),('FF','FRF','Francs francais',NULL,0),('FH','HUF','Forint hongrois',NULL,1),('FL','LUF','Francs luxembourgeois',NULL,0),('FO','NLG','Florins',NULL,1),('FS','CHF','Francs suisses',NULL,1),('HK','HKD','Dollars hong kong',NULL,1),('ID','IDR','Rupiahs d\'indonesie',NULL,1),('IN','INR','Roupie indienne',NULL,1),('KR','KRW','Won coree du sud',NULL,1),('LH','HNL','Lempiras',NULL,1),('LI','IEP','Livres irlandaises',NULL,1),('LK','LKR','Roupies sri lanka',NULL,1),('LR','ITL','Lires',NULL,0),('LS','GBP','Livres sterling',NULL,1),('LT','LTL','Litas',NULL,1),('MA','DEM','Deutsch mark',NULL,0),('MF','FIM','Mark finlandais',NULL,1),('MR','MRO','Ouguiya Mauritanien',NULL,1),('MU','MUR','Roupies mauritiennes',NULL,1),('MX','MXP','Pesos Mexicans',NULL,1),('NZ','NZD','Dollar neo-zelandais',NULL,1),('PA','ARP','Pesos argentins',NULL,1),('PC','CLP','Pesos chilien',NULL,1),('PE','ESP','Pesete',NULL,1),('PL','PLN','Zlotys polonais',NULL,1),('RB','BRL','Real bresilien',NULL,1),('RU','SUR','Rouble',NULL,1),('SA','ATS','Shiliing autrichiens',NULL,1),('SK','SKK','Couronnes slovaques',NULL,1),('SR','SAR','Saudi riyal',NULL,1),('TD','TND','Dinar tunisien',NULL,1),('TR','TRL','Livre turque',NULL,1),('TW','TWD','Dollar taiwanais',NULL,1),('YC','CNY','Yuang chinois',NULL,1),('YE','JPY','Yens',NULL,1),('ZA','ZAR','Rand africa',NULL,1);
/*!40000 ALTER TABLE `llx_c_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_departements`
--

DROP TABLE IF EXISTS `llx_c_departements`;
CREATE TABLE `llx_c_departements` (
  `rowid` int(11) NOT NULL auto_increment,
  `code_departement` varchar(6) NOT NULL,
  `fk_region` int(11) default NULL,
  `cheflieu` varchar(50) default NULL,
  `tncc` int(11) default NULL,
  `ncc` varchar(50) default NULL,
  `nom` varchar(50) default NULL,
  `active` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_departements` (`code_departement`,`fk_region`),
  KEY `idx_departements_fk_region` (`fk_region`)
) ENGINE=InnoDB AUTO_INCREMENT=583 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_departements`
--

LOCK TABLES `llx_c_departements` WRITE;
/*!40000 ALTER TABLE `llx_c_departements` DISABLE KEYS */;
INSERT INTO `llx_c_departements` VALUES (1,'0',0,'0',0,'-','-',1),(2,'01',82,'01053',5,'AIN','Ain',1),(3,'02',22,'02408',5,'AISNE','Aisne',1),(4,'03',83,'03190',5,'ALLIER','Allier',1),(5,'04',93,'04070',4,'ALPES-DE-HAUTE-PROVENCE','Alpes-de-Haute-Provence',1),(6,'05',93,'05061',4,'HAUTES-ALPES','Hautes-Alpes',1),(7,'06',93,'06088',4,'ALPES-MARITIMES','Alpes-Maritimes',1),(8,'07',82,'07186',5,'ARDECHE','Ardèche',1),(9,'08',21,'08105',4,'ARDENNES','Ardennes',1),(10,'09',73,'09122',5,'ARIEGE','Ariège',1),(11,'10',21,'10387',5,'AUBE','Aube',1),(12,'11',91,'11069',5,'AUDE','Aude',1),(13,'12',73,'12202',5,'AVEYRON','Aveyron',1),(14,'13',93,'13055',4,'BOUCHES-DU-RHONE','Bouches-du-Rhône',1),(15,'14',25,'14118',2,'CALVADOS','Calvados',1),(16,'15',83,'15014',2,'CANTAL','Cantal',1),(17,'16',54,'16015',3,'CHARENTE','Charente',1),(18,'17',54,'17300',3,'CHARENTE-MARITIME','Charente-Maritime',1),(19,'18',24,'18033',2,'CHER','Cher',1),(20,'19',74,'19272',3,'CORREZE','Corrèze',1),(21,'2A',94,'2A004',3,'CORSE-DU-SUD','Corse-du-Sud',1),(22,'2B',94,'2B033',3,'HAUTE-CORSE','Haute-Corse',1),(23,'21',26,'21231',3,'COTE-D\'OR','Côte-d\'Or',1),(24,'22',53,'22278',4,'COTES-D\'ARMOR','Côtes-d\'Armor',1),(25,'23',74,'23096',3,'CREUSE','Creuse',1),(26,'24',72,'24322',3,'DORDOGNE','Dordogne',1),(27,'25',43,'25056',2,'DOUBS','Doubs',1),(28,'26',82,'26362',3,'DROME','Drôme',1),(29,'27',23,'27229',5,'EURE','Eure',1),(30,'28',24,'28085',1,'EURE-ET-LOIR','Eure-et-Loir',1),(31,'29',53,'29232',2,'FINISTERE','Finistère',1),(32,'30',91,'30189',2,'GARD','Gard',1),(33,'31',73,'31555',3,'HAUTE-GARONNE','Haute-Garonne',1),(34,'32',73,'32013',2,'GERS','Gers',1),(35,'33',72,'33063',3,'GIRONDE','Gironde',1),(36,'34',91,'34172',5,'HERAULT','Hérault',1),(37,'35',53,'35238',1,'ILLE-ET-VILAINE','Ille-et-Vilaine',1),(38,'36',24,'36044',5,'INDRE','Indre',1),(39,'37',24,'37261',1,'INDRE-ET-LOIRE','Indre-et-Loire',1),(40,'38',82,'38185',5,'ISERE','Isère',1),(41,'39',43,'39300',2,'JURA','Jura',1),(42,'40',72,'40192',4,'LANDES','Landes',1),(43,'41',24,'41018',0,'LOIR-ET-CHER','Loir-et-Cher',1),(44,'42',82,'42218',3,'LOIRE','Loire',1),(45,'43',83,'43157',3,'HAUTE-LOIRE','Haute-Loire',1),(46,'44',52,'44109',3,'LOIRE-ATLANTIQUE','Loire-Atlantique',1),(47,'45',24,'45234',2,'LOIRET','Loiret',1),(48,'46',73,'46042',2,'LOT','Lot',1),(49,'47',72,'47001',0,'LOT-ET-GARONNE','Lot-et-Garonne',1),(50,'48',91,'48095',3,'LOZERE','Lozère',1),(51,'49',52,'49007',0,'MAINE-ET-LOIRE','Maine-et-Loire',1),(52,'50',25,'50502',3,'MANCHE','Manche',1),(53,'51',21,'51108',3,'MARNE','Marne',1),(54,'52',21,'52121',3,'HAUTE-MARNE','Haute-Marne',1),(55,'53',52,'53130',3,'MAYENNE','Mayenne',1),(56,'54',41,'54395',0,'MEURTHE-ET-MOSELLE','Meurthe-et-Moselle',1),(57,'55',41,'55029',3,'MEUSE','Meuse',1),(58,'56',53,'56260',2,'MORBIHAN','Morbihan',1),(59,'57',41,'57463',3,'MOSELLE','Moselle',1),(60,'58',26,'58194',3,'NIEVRE','Nièvre',1),(61,'59',31,'59350',2,'NORD','Nord',1),(62,'60',22,'60057',5,'OISE','Oise',1),(63,'61',25,'61001',5,'ORNE','Orne',1),(64,'62',31,'62041',2,'PAS-DE-CALAIS','Pas-de-Calais',1),(65,'63',83,'63113',2,'PUY-DE-DOME','Puy-de-Dôme',1),(66,'64',72,'64445',4,'PYRENEES-ATLANTIQUES','Pyrénées-Atlantiques',1),(67,'65',73,'65440',4,'HAUTES-PYRENEES','Hautes-Pyrénées',1),(68,'66',91,'66136',4,'PYRENEES-ORIENTALES','Pyrénées-Orientales',1),(69,'67',42,'67482',2,'BAS-RHIN','Bas-Rhin',1),(70,'68',42,'68066',2,'HAUT-RHIN','Haut-Rhin',1),(71,'69',82,'69123',2,'RHONE','Rhône',1),(72,'70',43,'70550',3,'HAUTE-SAONE','Haute-Saône',1),(73,'71',26,'71270',0,'SAONE-ET-LOIRE','Saône-et-Loire',1),(74,'72',52,'72181',3,'SARTHE','Sarthe',1),(75,'73',82,'73065',3,'SAVOIE','Savoie',1),(76,'74',82,'74010',3,'HAUTE-SAVOIE','Haute-Savoie',1),(77,'75',11,'75056',0,'PARIS','Paris',1),(78,'76',23,'76540',3,'SEINE-MARITIME','Seine-Maritime',1),(79,'77',11,'77288',0,'SEINE-ET-MARNE','Seine-et-Marne',1),(80,'78',11,'78646',4,'YVELINES','Yvelines',1),(81,'79',54,'79191',4,'DEUX-SEVRES','Deux-Sèvres',1),(82,'80',22,'80021',3,'SOMME','Somme',1),(83,'81',73,'81004',2,'TARN','Tarn',1),(84,'82',73,'82121',0,'TARN-ET-GARONNE','Tarn-et-Garonne',1),(85,'83',93,'83137',2,'VAR','Var',1),(86,'84',93,'84007',0,'VAUCLUSE','Vaucluse',1),(87,'85',52,'85191',3,'VENDEE','Vendée',1),(88,'86',54,'86194',3,'VIENNE','Vienne',1),(89,'87',74,'87085',3,'HAUTE-VIENNE','Haute-Vienne',1),(90,'88',41,'88160',4,'VOSGES','Vosges',1),(91,'89',26,'89024',5,'YONNE','Yonne',1),(92,'90',43,'90010',0,'TERRITOIRE DE BELFORT','Territoire de Belfort',1),(93,'91',11,'91228',5,'ESSONNE','Essonne',1),(94,'92',11,'92050',4,'HAUTS-DE-SEINE','Hauts-de-Seine',1),(95,'93',11,'93008',3,'SEINE-SAINT-DENIS','Seine-Saint-Denis',1),(96,'94',11,'94028',2,'VAL-DE-MARNE','Val-de-Marne',1),(97,'95',11,'95500',2,'VAL-D\'OISE','Val-d\'Oise',1),(98,'971',1,'97105',3,'GUADELOUPE','Guadeloupe',1),(99,'972',2,'97209',3,'MARTINIQUE','Martinique',1),(100,'973',3,'97302',3,'GUYANE','Guyane',1),(101,'974',4,'97411',3,'REUNION','Réunion',1),(102,'01',201,'',1,'ANVERS','Anvers',1),(103,'02',203,'',3,'BRUXELLES-CAPITALE','Bruxelles-Capitale',1),(104,'03',202,'',2,'BRABANT-WALLON','Brabant-Wallon',1),(105,'04',201,'',1,'BRABANT-FLAMAND','Brabant-Flamand',1),(106,'05',201,'',1,'FLANDRE-OCCIDENTALE','Flandre-Occidentale',1),(107,'06',201,'',1,'FLANDRE-ORIENTALE','Flandre-Orientale',1),(108,'07',202,'',2,'HAINAUT','Hainaut',1),(109,'08',201,'',2,'LIEGE','Liège',1),(110,'09',202,'',1,'LIMBOURG','Limbourg',1),(111,'10',202,'',2,'LUXEMBOURG','Luxembourg',1),(112,'11',201,'',2,'NAMUR','Namur',1),(113,'AG',315,NULL,NULL,NULL,'AGRIGENTO',1),(114,'AL',312,NULL,NULL,NULL,'ALESSANDRIA',1),(115,'AN',310,NULL,NULL,NULL,'ANCONA',1),(116,'AO',319,NULL,NULL,NULL,'AOSTA',1),(117,'AR',316,NULL,NULL,NULL,'AREZZO',1),(118,'AP',310,NULL,NULL,NULL,'ASCOLI PICENO',1),(119,'AT',312,NULL,NULL,NULL,'ASTI',1),(120,'AV',304,NULL,NULL,NULL,'AVELLINO',1),(121,'BA',313,NULL,NULL,NULL,'BARI',1),(122,'BT',313,NULL,NULL,NULL,'BARLETTA-ANDRIA-TRANI',1),(123,'BL',320,NULL,NULL,NULL,'BELLUNO',1),(124,'BN',304,NULL,NULL,NULL,'BENEVENTO',1),(125,'BG',309,NULL,NULL,NULL,'BERGAMO',1),(126,'BI',312,NULL,NULL,NULL,'BIELLA',1),(127,'BO',305,NULL,NULL,NULL,'BOLOGNA',1),(128,'BZ',317,NULL,NULL,NULL,'BOLZANO',1),(129,'BS',309,NULL,NULL,NULL,'BRESCIA',1),(130,'BR',313,NULL,NULL,NULL,'BRINDISI',1),(131,'CA',314,NULL,NULL,NULL,'CAGLIARI',1),(132,'CL',315,NULL,NULL,NULL,'CALTANISSETTA',1),(133,'CB',311,NULL,NULL,NULL,'CAMPOBASSO',1),(134,'CI',314,NULL,NULL,NULL,'CARBONIA-IGLESIAS',1),(135,'CE',304,NULL,NULL,NULL,'CASERTA',1),(136,'CT',315,NULL,NULL,NULL,'CATANIA',1),(137,'CZ',303,NULL,NULL,NULL,'CATANZARO',1),(138,'CH',301,NULL,NULL,NULL,'CHIETI',1),(139,'CO',309,NULL,NULL,NULL,'COMO',1),(140,'CS',303,NULL,NULL,NULL,'COSENZA',1),(141,'CR',309,NULL,NULL,NULL,'CREMONA',1),(142,'KR',303,NULL,NULL,NULL,'CROTONE',1),(143,'CN',312,NULL,NULL,NULL,'CUNEO',1),(144,'EN',315,NULL,NULL,NULL,'ENNA',1),(145,'FM',310,NULL,NULL,NULL,'FERMO',1),(146,'FE',305,NULL,NULL,NULL,'FERRARA',1),(147,'FI',316,NULL,NULL,NULL,'FIRENZE',1),(148,'FG',313,NULL,NULL,NULL,'FOGGIA',1),(149,'FC',305,NULL,NULL,NULL,'FORLI-CESENA',1),(150,'FR',307,NULL,NULL,NULL,'FROSINONE',1),(151,'GE',308,NULL,NULL,NULL,'GENOVA',1),(152,'GO',306,NULL,NULL,NULL,'GORIZIA',1),(153,'GR',316,NULL,NULL,NULL,'GROSSETO',1),(154,'IM',308,NULL,NULL,NULL,'IMPERIA',1),(155,'IS',311,NULL,NULL,NULL,'ISERNIA',1),(156,'SP',308,NULL,NULL,NULL,'LA SPEZIA',1),(157,'AQ',301,NULL,NULL,NULL,'L AQUILA',1),(158,'LT',307,NULL,NULL,NULL,'LATINA',1),(159,'LE',313,NULL,NULL,NULL,'LECCE',1),(160,'LC',309,NULL,NULL,NULL,'LECCO',1),(161,'LI',314,NULL,NULL,NULL,'LIVORNO',1),(162,'LO',309,NULL,NULL,NULL,'LODI',1),(163,'LU',316,NULL,NULL,NULL,'LUCCA',1),(164,'MC',310,NULL,NULL,NULL,'MACERATA',1),(165,'MN',309,NULL,NULL,NULL,'MANTOVA',1),(166,'MS',316,NULL,NULL,NULL,'MASSA-CARRARA',1),(167,'MT',302,NULL,NULL,NULL,'MATERA',1),(168,'VS',314,NULL,NULL,NULL,'MEDIO CAMPIDANO',1),(169,'ME',315,NULL,NULL,NULL,'MESSINA',1),(170,'MI',309,NULL,NULL,NULL,'MILANO',1),(171,'MB',309,NULL,NULL,NULL,'MONZA e BRIANZA',1),(172,'MO',305,NULL,NULL,NULL,'MODENA',1),(173,'NA',304,NULL,NULL,NULL,'NAPOLI',1),(174,'NO',312,NULL,NULL,NULL,'NOVARA',1),(175,'NU',314,NULL,NULL,NULL,'NUORO',1),(176,'OG',314,NULL,NULL,NULL,'OGLIASTRA',1),(177,'OT',314,NULL,NULL,NULL,'OLBIA-TEMPIO',1),(178,'OR',314,NULL,NULL,NULL,'ORISTANO',1),(179,'PD',320,NULL,NULL,NULL,'PADOVA',1),(180,'PA',315,NULL,NULL,NULL,'PALERMO',1),(181,'PR',305,NULL,NULL,NULL,'PARMA',1),(182,'PV',309,NULL,NULL,NULL,'PAVIA',1),(183,'PG',318,NULL,NULL,NULL,'PERUGIA',1),(184,'PU',310,NULL,NULL,NULL,'PESARO e URBINO',1),(185,'PE',301,NULL,NULL,NULL,'PESCARA',1),(186,'PC',305,NULL,NULL,NULL,'PIACENZA',1),(187,'PI',316,NULL,NULL,NULL,'PISA',1),(188,'PT',316,NULL,NULL,NULL,'PISTOIA',1),(189,'PN',306,NULL,NULL,NULL,'PORDENONE',1),(190,'PZ',302,NULL,NULL,NULL,'POTENZA',1),(191,'PO',316,NULL,NULL,NULL,'PRATO',1),(192,'RG',315,NULL,NULL,NULL,'RAGUSA',1),(193,'RA',305,NULL,NULL,NULL,'RAVENNA',1),(194,'RC',303,NULL,NULL,NULL,'REGGIO CALABRIA',1),(195,'RE',305,NULL,NULL,NULL,'REGGIO NELL EMILIA',1),(196,'RI',307,NULL,NULL,NULL,'RIETI',1),(197,'RN',305,NULL,NULL,NULL,'RIMINI',1),(198,'RM',307,NULL,NULL,NULL,'ROMA',1),(199,'RO',320,NULL,NULL,NULL,'ROVIGO',1),(200,'SA',304,NULL,NULL,NULL,'SALERNO',1),(201,'SS',314,NULL,NULL,NULL,'SASSARI',1),(202,'SV',308,NULL,NULL,NULL,'SAVONA',1),(203,'SI',316,NULL,NULL,NULL,'SIENA',1),(204,'SR',315,NULL,NULL,NULL,'SIRACUSA',1),(205,'SO',309,NULL,NULL,NULL,'SONDRIO',1),(206,'TA',313,NULL,NULL,NULL,'TARANTO',1),(207,'TE',301,NULL,NULL,NULL,'TERAMO',1),(208,'TR',318,NULL,NULL,NULL,'TERNI',1),(209,'TO',312,NULL,NULL,NULL,'TORINO',1),(210,'TP',315,NULL,NULL,NULL,'TRAPANI',1),(211,'TN',317,NULL,NULL,NULL,'TRENTO',1),(212,'TV',320,NULL,NULL,NULL,'TREVISO',1),(213,'TS',306,NULL,NULL,NULL,'TRIESTE',1),(214,'UD',306,NULL,NULL,NULL,'UDINE',1),(215,'VA',309,NULL,NULL,NULL,'VARESE',1),(216,'VE',320,NULL,NULL,NULL,'VENEZIA',1),(217,'VB',312,NULL,NULL,NULL,'VERBANO-CUSIO-OSSOLA',1),(218,'VC',312,NULL,NULL,NULL,'VERCELLI',1),(219,'VR',320,NULL,NULL,NULL,'VERONA',1),(220,'VV',303,NULL,NULL,NULL,'VIBO VALENTIA',1),(221,'VI',320,NULL,NULL,NULL,'VICENZA',1),(222,'VT',307,NULL,NULL,NULL,'VITERBO',1),(223,'NSW',2801,'',1,'','New South Wales',1),(224,'VIC',2801,'',1,'','Victoria',1),(225,'QLD',2801,'',1,'','Queensland',1),(226,'SA',2801,'',1,'','South Australia',1),(227,'ACT',2801,'',1,'','Australia Capital Territory',1),(228,'TAS',2801,'',1,'','Tasmania',1),(229,'WA',2801,'',1,'','Western Australia',1),(230,'NT',2801,'',1,'','Northern Territory',1),(231,'01',419,'',19,'PAIS VASCO','País Vasco',1),(232,'02',404,'',4,'ALBACETE','Albacete',1),(233,'03',411,'',11,'ALICANTE','Alicante',1),(234,'04',401,'',1,'ALMERIA','Almería',1),(235,'05',403,'',3,'AVILA','Avila',1),(236,'06',412,'',12,'BADAJOZ','Badajoz',1),(237,'07',414,'',14,'ISLAS BALEARES','Islas Baleares',1),(238,'08',406,'',6,'BARCELONA','Barcelona',1),(239,'09',403,'',8,'BURGOS','Burgos',1),(240,'10',412,'',12,'CACERES','Cáceres',1),(241,'11',401,'',1,'CADIz','Cádiz',1),(242,'12',411,'',11,'CASTELLON','Castellón',1),(243,'13',404,'',4,'CIUDAD REAL','Ciudad Real',1),(244,'14',401,'',1,'CORDOBA','Córdoba',1),(245,'15',413,'',13,'LA CORUÑA','La Coruña',1),(246,'16',404,'',4,'CUENCA','Cuenca',1),(247,'17',406,'',6,'GERONA','Gerona',1),(248,'18',401,'',1,'GRANADA','Granada',1),(249,'19',404,'',4,'GUADALAJARA','Guadalajara',1),(250,'20',419,'',19,'GUIPUZCOA','Guipúzcoa',1),(251,'21',401,'',1,'HUELVA','Huelva',1),(252,'22',402,'',2,'HUESCA','Huesca',1),(253,'23',401,'',1,'JAEN','Jaén',1),(254,'24',403,'',3,'LEON','León',1),(255,'25',406,'',6,'LERIDA','Lérida',1),(256,'26',415,'',15,'LA RIOJA','La Rioja',1),(257,'27',413,'',13,'LUGO','Lugo',1),(258,'28',416,'',16,'MADRID','Madrid',1),(259,'29',401,'',1,'MALAGA','Málaga',1),(260,'30',417,'',17,'MURCIA','Murcia',1),(261,'31',408,'',8,'NAVARRA','Navarra',1),(262,'32',413,'',13,'ORENSE','Orense',1),(263,'33',418,'',18,'ASTURIAS','Asturias',1),(264,'34',403,'',3,'PALENCIA','Palencia',1),(265,'35',405,'',5,'LAS PALMAS','Las Palmas',1),(266,'36',413,'',13,'PONTEVEDRA','Pontevedra',1),(267,'37',403,'',3,'SALAMANCA','Salamanca',1),(268,'38',405,'',5,'STA. CRUZ DE TENERIFE','Sta. Cruz de Tenerife',1),(269,'39',410,'',10,'CANTABRIA','Cantabria',1),(270,'40',403,'',3,'SEGOVIA','Segovia',1),(271,'41',401,'',1,'SEVILLA','Sevilla',1),(272,'42',403,'',3,'SORIA','Soria',1),(273,'43',406,'',6,'TARRAGONA','Tarragona',1),(274,'44',402,'',2,'TERUEL','Teruel',1),(275,'45',404,'',5,'TOLEDO','Toledo',1),(276,'46',411,'',11,'VALENCIA','Valencia',1),(277,'47',403,'',3,'VALLADOLID','Valladolid',1),(278,'48',419,'',19,'VIZCAYA','Vizcaya',1),(279,'49',403,'',3,'ZAMORA','Zamora',1),(280,'50',402,'',1,'ZARAGOZA','Zaragoza',1),(281,'51',407,'',7,'CEUTA','Ceuta',1),(282,'52',409,'',9,'MELILLA','Melilla',1),(283,'53',420,'',20,'OTROS','Otros',1),(284,'AG',601,NULL,NULL,'ARGOVIE','Argovie',1),(285,'AI',601,NULL,NULL,'APPENZELL RHODES INTERIEURES','Appenzell Rhodes intérieures',1),(286,'AR',601,NULL,NULL,'APPENZELL RHODES EXTERIEURES','Appenzell Rhodes extérieures',1),(287,'BE',601,NULL,NULL,'BERNE','Berne',1),(288,'BL',601,NULL,NULL,'BALE CAMPAGNE','Bâle Campagne',1),(289,'BS',601,NULL,NULL,'BALE VILLE','Bâle Ville',1),(290,'FR',601,NULL,NULL,'FRIBOURG','Fribourg',1),(291,'GE',601,NULL,NULL,'GENEVE','Genève',1),(292,'GL',601,NULL,NULL,'GLARIS','Glaris',1),(293,'GR',601,NULL,NULL,'GRISONS','Grisons',1),(294,'JU',601,NULL,NULL,'JURA','Jura',1),(295,'LU',601,NULL,NULL,'LUCERNE','Lucerne',1),(296,'NE',601,NULL,NULL,'NEUCHATEL','Neuchâtel',1),(297,'NW',601,NULL,NULL,'NIDWALD','Nidwald',1),(298,'OW',601,NULL,NULL,'OBWALD','Obwald',1),(299,'SG',601,NULL,NULL,'SAINT-GALL','Saint-Gall',1),(300,'SH',601,NULL,NULL,'SCHAFFHOUSE','Schaffhouse',1),(301,'SO',601,NULL,NULL,'SOLEURE','Soleure',1),(302,'SZ',601,NULL,NULL,'SCHWYZ','Schwyz',1),(303,'TG',601,NULL,NULL,'THURGOVIE','Thurgovie',1),(304,'TI',601,NULL,NULL,'TESSIN','Tessin',1),(305,'UR',601,NULL,NULL,'URI','Uri',1),(306,'VD',601,NULL,NULL,'VAUD','Vaud',1),(307,'VS',601,NULL,NULL,'VALAIS','Valais',1),(308,'ZG',601,NULL,NULL,'ZUG','Zug',1),(309,'ZH',601,NULL,NULL,'ZURICH','Zürich',1),(310,'AL',1101,'',0,'ALABAMA','Alabama',1),(311,'AK',1101,'',0,'ALASKA','Alaska',1),(312,'AZ',1101,'',0,'ARIZONA','Arizona',1),(313,'AR',1101,'',0,'ARKANSAS','Arkansas',1),(314,'CA',1101,'',0,'CALIFORNIA','California',1),(315,'CO',1101,'',0,'COLORADO','Colorado',1),(316,'CT',1101,'',0,'CONNECTICUT','Connecticut',1),(317,'DE',1101,'',0,'DELAWARE','Delaware',1),(318,'FL',1101,'',0,'FLORIDA','Florida',1),(319,'GA',1101,'',0,'GEORGIA','Georgia',1),(320,'HI',1101,'',0,'HAWAII','Hawaii',1),(321,'ID',1101,'',0,'IDAHO','Idaho',1),(322,'IL',1101,'',0,'ILLINOIS','Illinois',1),(323,'IN',1101,'',0,'INDIANA','Indiana',1),(324,'IA',1101,'',0,'IOWA','Iowa',1),(325,'KS',1101,'',0,'KANSAS','Kansas',1),(326,'KY',1101,'',0,'KENTUCKY','Kentucky',1),(327,'LA',1101,'',0,'LOUISIANA','Louisiana',1),(328,'ME',1101,'',0,'MAINE','Maine',1),(329,'MD',1101,'',0,'MARYLAND','Maryland',1),(330,'MA',1101,'',0,'MASSACHUSSETTS','Massachusetts',1),(331,'MI',1101,'',0,'MICHIGAN','Michigan',1),(332,'MN',1101,'',0,'MINNESOTA','Minnesota',1),(333,'MS',1101,'',0,'MISSISSIPPI','Mississippi',1),(334,'MO',1101,'',0,'MISSOURI','Missouri',1),(335,'MT',1101,'',0,'MONTANA','Montana',1),(336,'NE',1101,'',0,'NEBRASKA','Nebraska',1),(337,'NV',1101,'',0,'NEVADA','Nevada',1),(338,'NH',1101,'',0,'NEW HAMPSHIRE','New Hampshire',1),(339,'NJ',1101,'',0,'NEW JERSEY','New Jersey',1),(340,'NM',1101,'',0,'NEW MEXICO','New Mexico',1),(341,'NY',1101,'',0,'NEW YORK','New York',1),(342,'NC',1101,'',0,'NORTH CAROLINA','North Carolina',1),(343,'ND',1101,'',0,'NORTH DAKOTA','North Dakota',1),(344,'OH',1101,'',0,'OHIO','Ohio',1),(345,'OK',1101,'',0,'OKLAHOMA','Oklahoma',1),(346,'OR',1101,'',0,'OREGON','Oregon',1),(347,'PA',1101,'',0,'PENNSYLVANIA','Pennsylvania',1),(348,'RI',1101,'',0,'RHODE ISLAND','Rhode Island',1),(349,'SC',1101,'',0,'SOUTH CAROLINA','South Carolina',1),(350,'SD',1101,'',0,'SOUTH DAKOTA','South Dakota',1),(351,'TN',1101,'',0,'TENNESSEE','Tennessee',1),(352,'TX',1101,'',0,'TEXAS','Texas',1),(353,'UT',1101,'',0,'UTAH','Utah',1),(354,'VT',1101,'',0,'VERMONT','Vermont',1),(355,'VA',1101,'',0,'VIRGINIA','Virginia',1),(356,'WA',1101,'',0,'WASHINGTON','Washington',1),(357,'WV',1101,'',0,'WEST VIRGINIA','West Virginia',1),(358,'WI',1101,'',0,'WISCONSIN','Wisconsin',1),(359,'WY',1101,'',0,'WYOMING','Wyoming',1),(360,'SS',8601,NULL,NULL,NULL,'San Salvador',1),(361,'SA',8603,NULL,NULL,NULL,'Santa Ana',1),(362,'AH',8603,NULL,NULL,NULL,'Ahuachapan',1),(363,'SO',8603,NULL,NULL,NULL,'Sonsonate',1),(364,'US',8602,NULL,NULL,NULL,'Usulutan',1),(365,'SM',8602,NULL,NULL,NULL,'San Miguel',1),(366,'MO',8602,NULL,NULL,NULL,'Morazan',1),(367,'LU',8602,NULL,NULL,NULL,'La Union',1),(368,'LL',8601,NULL,NULL,NULL,'La Libertad',1),(369,'CH',8601,NULL,NULL,NULL,'Chalatenango',1),(370,'CA',8601,NULL,NULL,NULL,'Cabañas',1),(371,'LP',8601,NULL,NULL,NULL,'La Paz',1),(372,'SV',8601,NULL,NULL,NULL,'San Vicente',1),(373,'CU',8601,NULL,NULL,NULL,'Cuscatlan',1),(374,'2301',2301,'',0,'CATAMARCA','Catamarca',1),(375,'2302',2301,'',0,'YUJUY','Yujuy',1),(376,'2303',2301,'',0,'TUCAMAN','Tucamán',1),(377,'2304',2301,'',0,'SANTIAGO DEL ESTERO','Santiago del Estero',1),(378,'2305',2301,'',0,'SALTA','Salta',1),(379,'2306',2302,'',0,'CHACO','Chaco',1),(380,'2307',2302,'',0,'CORRIENTES','Corrientes',1),(381,'2308',2302,'',0,'ENTRE RIOS','Entre Ríos',1),(382,'2309',2302,'',0,'FORMOSA MISIONES','Formosa Misiones',1),(383,'2310',2302,'',0,'SANTA FE','Santa Fe',1),(384,'2311',2303,'',0,'LA RIOJA','La Rioja',1),(385,'2312',2303,'',0,'MENDOZA','Mendoza',1),(386,'2313',2303,'',0,'SAN JUAN','San Juan',1),(387,'2314',2303,'',0,'SAN LUIS','San Luis',1),(388,'2315',2304,'',0,'CORDOBA','Córdoba',1),(389,'2316',2304,'',0,'BUENOS AIRES','Buenos Aires',1),(390,'2317',2304,'',0,'CABA','Caba',1),(391,'2318',2305,'',0,'LA PAMPA','La Pampa',1),(392,'2319',2305,'',0,'NEUQUEN','Neuquén',1),(393,'2320',2305,'',0,'RIO NEGRO','Río Negro',1),(394,'2321',2305,'',0,'CHUBUT','Chubut',1),(395,'2322',2305,'',0,'SANTA CRUZ','Santa Cruz',1),(396,'2323',2305,'',0,'TIERRA DEL FUEGO','Tierra del Fuego',1),(397,'2324',2305,'',0,'ISLAS MALVINAS','Islas Malvinas',1),(398,'2325',2305,'',0,'ANTARTIDA','Antártida',1),(399,'151',6715,'',0,'151','Arica',1),(400,'152',6715,'',0,'152','Parinacota',1),(401,'011',6701,'',0,'011','Iquique',1),(402,'014',6701,'',0,'014','Tamarugal',1),(403,'021',6702,'',0,'021','Antofagasa',1),(404,'022',6702,'',0,'022','El Loa',1),(405,'023',6702,'',0,'023','Tocopilla',1),(406,'031',6703,'',0,'031','Copiapó',1),(407,'032',6703,'',0,'032','Chañaral',1),(408,'033',6703,'',0,'033','Huasco',1),(409,'041',6704,'',0,'041','Elqui',1),(410,'042',6704,'',0,'042','Choapa',1),(411,'043',6704,'',0,'043','Limarí',1),(412,'051',6705,'',0,'051','Valparaíso',1),(413,'052',6705,'',0,'052','Isla de Pascua',1),(414,'053',6705,'',0,'053','Los Andes',1),(415,'054',6705,'',0,'054','Petorca',1),(416,'055',6705,'',0,'055','Quillota',1),(417,'056',6705,'',0,'056','San Antonio',1),(418,'057',6705,'',0,'057','San Felipe de Aconcagua',1),(419,'058',6705,'',0,'058','Marga Marga',1),(420,'061',6706,'',0,'061','Cachapoal',1),(421,'062',6706,'',0,'062','Cardenal Caro',1),(422,'063',6706,'',0,'063','Colchagua',1),(423,'071',6707,'',0,'071','Talca',1),(424,'072',6707,'',0,'072','Cauquenes',1),(425,'073',6707,'',0,'073','Curicó',1),(426,'074',6707,'',0,'074','Linares',1),(427,'081',6708,'',0,'081','Concepción',1),(428,'082',6708,'',0,'082','Arauco',1),(429,'083',6708,'',0,'083','Biobío',1),(430,'084',6708,'',0,'084','Ñuble',1),(431,'091',6709,'',0,'091','Cautín',1),(432,'092',6709,'',0,'092','Malleco',1),(433,'141',6714,'',0,'141','Valdivia',1),(434,'142',6714,'',0,'142','Ranco',1),(435,'101',6710,'',0,'101','Llanquihue',1),(436,'102',6710,'',0,'102','Chiloé',1),(437,'103',6710,'',0,'103','Osorno',1),(438,'104',6710,'',0,'104','Palena',1),(439,'111',6711,'',0,'111','Coihaique',1),(440,'112',6711,'',0,'112','Aisén',1),(441,'113',6711,'',0,'113','Capitán Prat',1),(442,'114',6711,'',0,'114','General Carrera',1),(443,'121',6712,'',0,'121','Magallanes',1),(444,'122',6712,'',0,'122','Antártica Chilena',1),(445,'123',6712,'',0,'123','Tierra del Fuego',1),(446,'124',6712,'',0,'124','Última Esperanza',1),(447,'131',6713,'',0,'131','Santiago',1),(448,'132',6713,'',0,'132','Cordillera',1),(449,'133',6713,'',0,'133','Chacabuco',1),(450,'134',6713,'',0,'134','Maipo',1),(451,'135',6713,'',0,'135','Melipilla',1),(452,'136',6713,'',0,'136','Talagante',1),(453,'AN',11701,NULL,0,'AN','Andaman & Nicobar',1),(454,'AP',11701,NULL,0,'AP','Andhra Pradesh',1),(455,'AR',11701,NULL,0,'AR','Arunachal Pradesh',1),(456,'AS',11701,NULL,0,'AS','Assam',1),(457,'BR',11701,NULL,0,'BR','Bihar',1),(458,'CG',11701,NULL,0,'CG','Chattisgarh',1),(459,'CH',11701,NULL,0,'CH','Chandigarh',1),(460,'DD',11701,NULL,0,'DD','Daman & Diu',1),(461,'DL',11701,NULL,0,'DL','Delhi',1),(462,'DN',11701,NULL,0,'DN','Dadra and Nagar Haveli',1),(463,'GA',11701,NULL,0,'GA','Goa',1),(464,'GJ',11701,NULL,0,'GJ','Gujarat',1),(465,'HP',11701,NULL,0,'HP','Himachal Pradesh',1),(466,'HR',11701,NULL,0,'HR','Haryana',1),(467,'JH',11701,NULL,0,'JH','Jharkhand',1),(468,'JK',11701,NULL,0,'JK','Jammu & Kashmir',1),(469,'KA',11701,NULL,0,'KA','Karnataka',1),(470,'KL',11701,NULL,0,'KL','Kerala',1),(471,'LD',11701,NULL,0,'LD','Lakshadweep',1),(472,'MH',11701,NULL,0,'MH','Maharashtra',1),(473,'ML',11701,NULL,0,'ML','Meghalaya',1),(474,'MN',11701,NULL,0,'MN','Manipur',1),(475,'MP',11701,NULL,0,'MP','Madhya Pradesh',1),(476,'MZ',11701,NULL,0,'MZ','Mizoram',1),(477,'NL',11701,NULL,0,'NL','Nagaland',1),(478,'OR',11701,NULL,0,'OR','Orissa',1),(479,'PB',11701,NULL,0,'PB','Punjab',1),(480,'PY',11701,NULL,0,'PY','Puducherry',1),(481,'RJ',11701,NULL,0,'RJ','Rajasthan',1),(482,'SK',11701,NULL,0,'SK','Sikkim',1),(483,'TN',11701,NULL,0,'TN','Tamil Nadu',1),(484,'TR',11701,NULL,0,'TR','Tripura',1),(485,'UL',11701,NULL,0,'UL','Uttarakhand',1),(486,'UP',11701,NULL,0,'UP','Uttar Pradesh',1),(487,'WB',11701,NULL,0,'WB','West Bengal',1),(488,'DIF',15401,'',0,'DIF','Distrito Federal',1),(489,'AGS',15401,'',0,'AGS','Aguascalientes',1),(490,'BCN',15401,'',0,'BCN','Baja California Norte',1),(491,'BCS',15401,'',0,'BCS','Baja California Sur',1),(492,'CAM',15401,'',0,'CAM','Campeche',1),(493,'CHP',15401,'',0,'CHP','Chiapas',1),(494,'CHI',15401,'',0,'CHI','Chihuahua',1),(495,'COA',15401,'',0,'COA','Coahuila',1),(496,'COL',15401,'',0,'COL','Colima',1),(497,'DUR',15401,'',0,'DUR','Durango',1),(498,'GTO',15401,'',0,'GTO','Guanajuato',1),(499,'GRO',15401,'',0,'GRO','Guerrero',1),(500,'HGO',15401,'',0,'HGO','Hidalgo',1),(501,'JAL',15401,'',0,'JAL','Jalisco',1),(502,'MEX',15401,'',0,'MEX','México',1),(503,'MIC',15401,'',0,'MIC','Michoacán de Ocampo',1),(504,'MOR',15401,'',0,'MOR','Morelos',1),(505,'NAY',15401,'',0,'NAY','Nayarit',1),(506,'NLE',15401,'',0,'NLE','Nuevo León',1),(507,'OAX',15401,'',0,'OAX','Oaxaca',1),(508,'PUE',15401,'',0,'PUE','Puebla',1),(509,'QRO',15401,'',0,'QRO','Querétaro',1),(510,'ROO',15401,'',0,'ROO','Quintana Roo',1),(511,'SLP',15401,'',0,'SLP','San Luis Potosí',1),(512,'SIN',15401,'',0,'SIN','Sinaloa',1),(513,'SON',15401,'',0,'SON','Sonora',1),(514,'TAB',15401,'',0,'TAB','Tabasco',1),(515,'TAM',15401,'',0,'TAM','Tamaulipas',1),(516,'TLX',15401,'',0,'TLX','Tlaxcala',1),(517,'VER',15401,'',0,'VER','Veracruz',1),(518,'YUC',15401,'',0,'YUC','Yucatán',1),(519,'ZAC',15401,'',0,'ZAC','Zacatecas',1),(520,'ANT',7001,'',0,'ANT','Antioquia',1),(521,'BOL',7001,'',0,'BOL','Bolívar',1),(522,'BOY',7001,'',0,'BOY','Boyacá',1),(523,'CAL',7001,'',0,'CAL','Caldas',1),(524,'CAU',7001,'',0,'CAU','Cauca',1),(525,'CUN',7001,'',0,'CUN','Cundinamarca',1),(526,'HUI',7001,'',0,'HUI','Huila',1),(527,'LAG',7001,'',0,'LAG','La Guajira',1),(528,'MET',7001,'',0,'MET','Meta',1),(529,'NAR',7001,'',0,'NAR','Nariño',1),(530,'NDS',7001,'',0,'NDS','Norte de Santander',1),(531,'SAN',7001,'',0,'SAN','Santander',1),(532,'SUC',7001,'',0,'SUC','Sucre',1),(533,'TOL',7001,'',0,'TOL','Tolima',1),(534,'VAC',7001,'',0,'VAC','Valle del Cauca',1),(535,'RIS',7001,'',0,'RIS','Risalda',1),(536,'ATL',7001,'',0,'ATL','Atlántico',1),(537,'COR',7001,'',0,'COR','Córdoba',1),(538,'SAP',7001,'',0,'SAP','San Andrés, Providencia y Santa Catalina',1),(539,'ARA',7001,'',0,'ARA','Arauca',1),(540,'CAS',7001,'',0,'CAS','Casanare',1),(541,'AMA',7001,'',0,'AMA','Amazonas',1),(542,'CAQ',7001,'',0,'CAQ','Caquetá',1),(543,'CHO',7001,'',0,'CHO','Chocó',1),(544,'GUA',7001,'',0,'GUA','Guainía',1),(545,'GUV',7001,'',0,'GUV','Guaviare',1),(546,'PUT',7001,'',0,'PUT','Putumayo',1),(547,'QUI',7001,'',0,'QUI','Quindío',1),(548,'VAU',7001,'',0,'VAU','Vaupés',1),(549,'BOG',7001,'',0,'BOG','Bogotá',1),(550,'VID',7001,'',0,'VID','Vichada',1),(551,'CES',7001,'',0,'CES','Cesar',1),(552,'MAG',7001,'',0,'MAG','Magdalena',1),(553,'AT',11401,'',0,'AT','Atlántida',1),(554,'CH',11401,'',0,'CH','Choluteca',1),(555,'CL',11401,'',0,'CL','Colón',1),(556,'CM',11401,'',0,'CM','Comayagua',1),(557,'CO',11401,'',0,'CO','Copán',1),(558,'CR',11401,'',0,'CR','Cortés',1),(559,'EP',11401,'',0,'EP','El Paraíso',1),(560,'FM',11401,'',0,'FM','Francisco Morazán',1),(561,'GD',11401,'',0,'GD','Gracias a Dios',1),(562,'IN',11401,'',0,'IN','Intibucá',1),(563,'IB',11401,'',0,'IB','Islas de la Bahía',1),(564,'LP',11401,'',0,'LP','La Paz',1),(565,'LM',11401,'',0,'LM','Lempira',1),(566,'OC',11401,'',0,'OC','Ocotepeque',1),(567,'OL',11401,'',0,'OL','Olancho',1),(568,'SB',11401,'',0,'SB','Santa Bárbara',1),(569,'VL',11401,'',0,'VL','Valle',1),(570,'YO',11401,'',0,'YO','Yoro',1),(571,'DC',11401,'',0,'DC','Distrito Central',1),(572,'CC',4601,'Oistins',0,'CC','Christ Church',1),(573,'SA',4601,'Greenland',0,'SA','Saint Andrew',1),(574,'SG',4601,'Bulkeley',0,'SG','Saint George',1),(575,'JA',4601,'Holetown',0,'JA','Saint James',1),(576,'SJ',4601,'Four Roads',0,'SJ','Saint John',1),(577,'SB',4601,'Bathsheba',0,'SB','Saint Joseph',1),(578,'SL',4601,'Crab Hill',0,'SL','Saint Lucy',1),(579,'SM',4601,'Bridgetown',0,'SM','Saint Michael',1),(580,'SP',4601,'Speightstown',0,'SP','Saint Peter',1),(581,'SC',4601,'Crane',0,'SC','Saint Philip',1),(582,'ST',4601,'Hillaby',0,'ST','Saint Thomas',1);
/*!40000 ALTER TABLE `llx_c_departements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_ecotaxe`
--

DROP TABLE IF EXISTS `llx_c_ecotaxe`;
CREATE TABLE `llx_c_ecotaxe` (
  `rowid` int(11) NOT NULL auto_increment,
  `code` varchar(64) NOT NULL,
  `libelle` varchar(255) default NULL,
  `price` double(24,8) default NULL,
  `organization` varchar(255) default NULL,
  `fk_pays` int(11) NOT NULL,
  `active` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_c_ecotaxe` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_ecotaxe`
--

LOCK TABLES `llx_c_ecotaxe` WRITE;
/*!40000 ALTER TABLE `llx_c_ecotaxe` DISABLE KEYS */;
INSERT INTO `llx_c_ecotaxe` VALUES (1,'ER-A-A','Materiels electriques < 0,2kg',0.01000000,'ERP',1,1),(2,'ER-A-B','Materiels electriques >= 0,2 kg et < 0,5 kg',0.03000000,'ERP',1,1),(3,'ER-A-C','Materiels electriques >= 0,5 kg et < 1 kg',0.04000000,'ERP',1,1),(4,'ER-A-D','Materiels electriques >= 1 kg et < 2 kg',0.13000000,'ERP',1,1),(5,'ER-A-E','Materiels electriques >= 2 kg et < 4kg',0.21000000,'ERP',1,1),(6,'ER-A-F','Materiels electriques >= 4 kg et < 8 kg',0.42000000,'ERP',1,1),(7,'ER-A-G','Materiels electriques >= 8 kg et < 15 kg',0.84000000,'ERP',1,1),(8,'ER-A-H','Materiels electriques >= 15 kg et < 20 kg',1.25000000,'ERP',1,1),(9,'ER-A-I','Materiels electriques >= 20 kg et < 30 kg',1.88000000,'ERP',1,1),(10,'ER-A-J','Materiels electriques >= 30 kg',3.34000000,'ERP',1,1),(11,'ER-M-1','TV, Moniteurs < 9kg',0.84000000,'ERP',1,1),(12,'ER-M-2','TV, Moniteurs >= 9kg et < 15kg',1.67000000,'ERP',1,1),(13,'ER-M-3','TV, Moniteurs >= 15kg et < 30kg',3.34000000,'ERP',1,1),(14,'ER-M-4','TV, Moniteurs >= 30 kg',6.69000000,'ERP',1,1),(15,'EC-A-A','Materiels electriques  0,2 kg max',0.00840000,'Ecologic',1,1),(16,'EC-A-B','Materiels electriques 0,21 kg min - 0,50 kg max',0.02500000,'Ecologic',1,1),(17,'EC-A-C','Materiels electriques  0,51 kg min - 1 kg max',0.04000000,'Ecologic',1,1),(18,'EC-A-D','Materiels electriques  1,01 kg min - 2,5 kg max',0.13000000,'Ecologic',1,1),(19,'EC-A-E','Materiels electriques  2,51 kg min - 4 kg max',0.21000000,'Ecologic',1,1),(20,'EC-A-F','Materiels electriques 4,01 kg min - 8 kg max',0.42000000,'Ecologic',1,1),(21,'EC-A-G','Materiels electriques  8,01 kg min - 12 kg max',0.63000000,'Ecologic',1,1),(22,'EC-A-H','Materiels electriques 12,01 kg min - 20 kg max',1.05000000,'Ecologic',1,1),(23,'EC-A-I','Materiels electriques  20,01 kg min',1.88000000,'Ecologic',1,1),(24,'EC-M-1','TV, Moniteurs 9 kg max',0.84000000,'Ecologic',1,1),(25,'EC-M-2','TV, Moniteurs 9,01 kg min - 18 kg max',1.67000000,'Ecologic',1,1),(26,'EC-M-3','TV, Moniteurs 18,01 kg min - 36 kg max',3.34000000,'Ecologic',1,1),(27,'EC-M-4','TV, Moniteurs 36,01 kg min',6.69000000,'Ecologic',1,1),(28,'ES-M-1','TV, Moniteurs <= 20 pouces',0.84000000,'Eco-systemes',1,1),(29,'ES-M-2','TV, Moniteurs > 20 pouces et <= 32 pouces',3.34000000,'Eco-systemes',1,1),(30,'ES-M-3','TV, Moniteurs > 32 pouces et autres grands ecrans',6.69000000,'Eco-systemes',1,1),(31,'ES-A-A','Ordinateur fixe, Audio home systems (HIFI), elements hifi separes',0.84000000,'Eco-systemes',1,1),(32,'ES-A-B','Ordinateur portable, CD-RCR, VCR, lecteurs et enregistreurs DVD, instruments de musique et caisses de resonance, haut parleurs...',0.25000000,'Eco-systemes',1,1),(33,'ES-A-C','Imprimante, photocopieur, telecopieur',0.42000000,'Eco-systemes',1,1),(34,'ES-A-D','Accessoires, clavier, souris, PDA, imprimante photo, appareil photo, gps, telephone, repondeur, telephone sans fil, modem, telecommande, casque, camescope, baladeur mp3, radio portable, radio K7 et CD portable, radio reveil',0.08400000,'Eco-systemes',1,1),(35,'ES-A-E','GSM',0.00840000,'Eco-systemes',1,1),(36,'ES-A-F','Jouets et equipements de loisirs et de sports < 0,5 kg',0.04200000,'Eco-systemes',1,1),(37,'ES-A-G','Jouets et equipements de loisirs et de sports > 0,5 kg',0.17000000,'Eco-systemes',1,1),(38,'ES-A-H','Jouets et equipements de loisirs et de sports > 10 kg',1.25000000,'Eco-systemes',1,1);
/*!40000 ALTER TABLE `llx_c_ecotaxe` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_effectif`
--

DROP TABLE IF EXISTS `llx_c_effectif`;
CREATE TABLE `llx_c_effectif` (
  `id` int(11) NOT NULL,
  `code` varchar(12) NOT NULL,
  `libelle` varchar(30) default NULL,
  `active` tinyint(4) NOT NULL default '1',
  `module` varchar(32) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_effectif`
--

LOCK TABLES `llx_c_effectif` WRITE;
/*!40000 ALTER TABLE `llx_c_effectif` DISABLE KEYS */;
INSERT INTO `llx_c_effectif` VALUES (0,'EF0','-',1,NULL),(1,'EF1-5','1 - 5',1,NULL),(2,'EF6-10','6 - 10',1,NULL),(3,'EF11-50','11 - 50',1,NULL),(4,'EF51-100','51 - 100',1,NULL),(5,'EF100-500','100 - 500',1,NULL),(6,'EF500-','> 500',1,NULL);
/*!40000 ALTER TABLE `llx_c_effectif` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_field_list`
--

DROP TABLE IF EXISTS `llx_c_field_list`;
CREATE TABLE `llx_c_field_list` (
  `rowid` int(11) NOT NULL auto_increment,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `element` varchar(64) NOT NULL,
  `entity` int(11) NOT NULL default '1',
  `name` varchar(32) NOT NULL,
  `alias` varchar(32) NOT NULL,
  `title` varchar(32) NOT NULL,
  `align` varchar(6) default 'left',
  `sort` tinyint(4) NOT NULL default '1',
  `search` tinyint(4) NOT NULL default '0',
  `enabled` varchar(255) default '1',
  `rang` int(11) default '0',
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_field_list`
--

LOCK TABLES `llx_c_field_list` WRITE;
/*!40000 ALTER TABLE `llx_c_field_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_c_field_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_forme_juridique`
--

DROP TABLE IF EXISTS `llx_c_forme_juridique`;
CREATE TABLE `llx_c_forme_juridique` (
  `rowid` int(11) NOT NULL auto_increment,
  `code` int(11) NOT NULL,
  `fk_pays` int(11) NOT NULL,
  `libelle` varchar(255) default NULL,
  `isvatexempted` tinyint(4) NOT NULL default '0',
  `active` tinyint(4) NOT NULL default '1',
  `module` varchar(32) default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_c_forme_juridique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=149 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_forme_juridique`
--

LOCK TABLES `llx_c_forme_juridique` WRITE;
/*!40000 ALTER TABLE `llx_c_forme_juridique` DISABLE KEYS */;
INSERT INTO `llx_c_forme_juridique` VALUES (1,0,0,'-',0,1,NULL),(2,2301,23,'Monotributista',0,1,NULL),(3,2302,23,'Sociedad Civil',0,1,NULL),(4,2303,23,'Sociedades Comerciales',0,1,NULL),(5,2304,23,'Sociedades de Hecho',0,1,NULL),(6,2305,23,'Sociedades Irregulares',0,1,NULL),(7,2306,23,'Sociedad Colectiva',0,1,NULL),(8,2307,23,'Sociedad en Comandita Simple',0,1,NULL),(9,2308,23,'Sociedad de Capital e Industria',0,1,NULL),(10,2309,23,'Sociedad Accidental o en participación',0,1,NULL),(11,2310,23,'Sociedad de Responsabilidad Limitada',0,1,NULL),(12,2311,23,'Sociedad Anónima',0,1,NULL),(13,2312,23,'Sociedad Anónima con Participación Estatal Mayoritaria',0,1,NULL),(14,2313,23,'Sociedad en Comandita por Acciones (arts. 315 a 324, LSC)',0,1,NULL),(15,11,1,'Artisan Commerçant (EI)',0,1,NULL),(16,12,1,'Commerçant (EI)',0,1,NULL),(17,13,1,'Artisan (EI)',0,1,NULL),(18,14,1,'Officier public ou ministériel',0,1,NULL),(19,15,1,'Profession libérale (EI)',0,1,NULL),(20,16,1,'Exploitant agricole',0,1,NULL),(21,17,1,'Agent commercial',0,1,NULL),(22,18,1,'Associé Gérant de société',0,1,NULL),(23,19,1,'Personne physique',0,1,NULL),(24,21,1,'Indivision',0,1,NULL),(25,22,1,'Société créée de fait',0,1,NULL),(26,23,1,'Société en participation',0,1,NULL),(27,27,1,'Paroisse hors zone concordataire',0,1,NULL),(28,29,1,'Groupement de droit privé non doté de la personnalité morale',0,1,NULL),(29,31,1,'Personne morale de droit étranger, immatriculée au RCS',0,1,NULL),(30,32,1,'Personne morale de droit étranger, non immatriculée au RCS',0,1,NULL),(31,35,1,'Régime auto-entrepreneur',0,1,NULL),(32,41,1,'Établissement public ou régie à caractère industriel ou commercial',0,1,NULL),(33,51,1,'Société coopérative commerciale particulière',0,1,NULL),(34,52,1,'Société en nom collectif',0,1,NULL),(35,53,1,'Société en commandite',0,1,NULL),(36,54,1,'Société à responsabilité limitée (SARL)',0,1,NULL),(37,55,1,'Société anonyme à conseil d administration',0,1,NULL),(38,56,1,'Société anonyme à directoire',0,1,NULL),(39,57,1,'Société par actions simplifiée',0,1,NULL),(40,58,1,'Entreprise Unipersonnelle à Responsabilité Limitée (EURL)',0,1,NULL),(41,61,1,'Caisse d\'épargne et de prévoyance',0,1,NULL),(42,62,1,'Groupement d\'intérêt économique (GIE)',0,1,NULL),(43,63,1,'Société coopérative agricole',0,1,NULL),(44,64,1,'Société non commerciale d assurances',0,1,NULL),(45,65,1,'Société civile',0,1,NULL),(46,69,1,'Personnes de droit privé inscrites au RCS',0,1,NULL),(47,71,1,'Administration de l état',0,1,NULL),(48,72,1,'Collectivité territoriale',0,1,NULL),(49,73,1,'Établissement public administratif',0,1,NULL),(50,74,1,'Personne morale de droit public administratif',0,1,NULL),(51,81,1,'Organisme gérant régime de protection social à adhésion obligatoire',0,1,NULL),(52,82,1,'Organisme mutualiste',0,1,NULL),(53,83,1,'Comité d entreprise',0,1,NULL),(54,84,1,'Organisme professionnel',0,1,NULL),(55,85,1,'Organisme de retraite à adhésion non obligatoire',0,1,NULL),(56,91,1,'Syndicat de propriétaires',0,1,NULL),(57,92,1,'Association loi 1901 ou assimilé',0,1,NULL),(58,93,1,'Fondation',0,1,NULL),(59,99,1,'Personne morale de droit privé',0,1,NULL),(60,200,2,'Indépendant',0,1,NULL),(61,201,2,'SPRL - Société à responsabilité limitée',0,1,NULL),(62,202,2,'SA   - Société Anonyme',0,1,NULL),(63,203,2,'SCRL - Société coopérative à responsabilité limitée',0,1,NULL),(64,204,2,'ASBL - Association sans but Lucratif',0,1,NULL),(65,205,2,'SCRI - Société coopérative à responsabilité illimitée',0,1,NULL),(66,206,2,'SCS  - Société en commandite simple',0,1,NULL),(67,207,2,'SCA  - Société en commandite par action',0,1,NULL),(68,208,2,'SNC  - Société en nom collectif',0,1,NULL),(69,209,2,'GIE  - Groupement d intérêt économique',0,1,NULL),(70,210,2,'GEIE - Groupement européen d intérêt économique',0,1,NULL),(71,500,5,'Limited liability corporation (GmbH)',0,1,NULL),(72,501,5,'Stock corporation (AG)',0,1,NULL),(73,502,5,'Partnerships general or limited (GmbH & CO. KG)',0,1,NULL),(74,503,5,'Sole proprietor / Private business',0,1,NULL),(75,301,3,'Società semplice',0,1,NULL),(76,302,3,'Società in nome collettivo s.n.c.',0,1,NULL),(77,303,3,'Società in accomandita semplice s.a.s.',0,1,NULL),(78,304,3,'Società per azioni s.p.a.',0,1,NULL),(79,305,3,'Società a responsabilità limitata s.r.l.',0,1,NULL),(80,306,3,'Società in accomandita per azioni s.a.p.a.',0,1,NULL),(81,307,3,'Società cooperativa',0,1,NULL),(82,308,3,'Società consortile',0,1,NULL),(83,309,3,'Società europea',0,1,NULL),(84,310,3,'Società cooperativa europea',0,1,NULL),(85,311,3,'Società unipersonale',0,1,NULL),(86,312,3,'Società di professionisti',0,1,NULL),(87,313,3,'Società di fatto',0,1,NULL),(88,314,3,'Società occulta',0,1,NULL),(89,315,3,'Società apparente',0,1,NULL),(90,316,3,'Impresa individuale ',0,1,NULL),(91,317,3,'Impresa coniugale',0,1,NULL),(92,318,3,'Impresa familiare',0,1,NULL),(93,600,6,'Raison Individuelle',0,1,NULL),(94,601,6,'Société Simple',0,1,NULL),(95,602,6,'Société en nom collectif',0,1,NULL),(96,603,6,'Société en commandite',0,1,NULL),(97,604,6,'Société anonyme (SA)',0,1,NULL),(98,605,6,'Société en commandite par actions',0,1,NULL),(99,606,6,'Société à responsabilité limitée (SARL)',0,1,NULL),(100,607,6,'Société coopérative',0,1,NULL),(101,608,6,'Association',0,1,NULL),(102,609,6,'Fondation',0,1,NULL),(103,700,7,'Sole Trader',0,1,NULL),(104,701,7,'Partnership',0,1,NULL),(105,702,7,'Private Limited Company by shares (LTD)',0,1,NULL),(106,703,7,'Public Limited Company',0,1,NULL),(107,704,7,'Workers Cooperative',0,1,NULL),(108,705,7,'Limited Liability Partnership',0,1,NULL),(109,706,7,'Franchise',0,1,NULL),(110,1000,10,'Société à responsabilité limitée (SARL)',0,1,NULL),(111,1001,10,'Société en Nom Collectif (SNC)',0,1,NULL),(112,1002,10,'Société en Commandite Simple (SCS)',0,1,NULL),(113,1003,10,'société en participation',0,1,NULL),(114,1004,10,'Société Anonyme (SA)',0,1,NULL),(115,1005,10,'Société Unipersonnelle à Responsabilité Limitée (SUARL)',0,1,NULL),(116,1006,10,'Groupement d\'intérêt économique (GEI)',0,1,NULL),(117,1007,10,'Groupe de sociétés',0,1,NULL),(118,401,4,'Empresario Individual',0,1,NULL),(119,402,4,'Comunidad de Bienes',0,1,NULL),(120,403,4,'Sociedad Civil',0,1,NULL),(121,404,4,'Sociedad Colectiva',0,1,NULL),(122,405,4,'Sociedad Limitada',0,1,NULL),(123,406,4,'Sociedad Anónima',0,1,NULL),(124,407,4,'Sociedad Comandataria por Acciones',0,1,NULL),(125,408,4,'Sociedad Comandataria Simple',0,1,NULL),(126,409,4,'Sociedad Laboral',0,1,NULL),(127,410,4,'Sociedad Cooperativa',0,1,NULL),(128,411,4,'Sociedad de Garantía Recíproca',0,1,NULL),(129,412,4,'Entidad de Capital-Riesgo',0,1,NULL),(130,413,4,'Agrupación de Interés Económico',0,1,NULL),(131,414,4,'Sociedad de Inversión Mobiliaria',0,1,NULL),(132,415,4,'Agrupación sin Ánimo de Lucro',0,1,NULL),(133,15201,152,'Mauritius Private Company Limited By Shares',0,1,NULL),(134,15202,152,'Mauritius Company Limited By Guarantee',0,1,NULL),(135,15203,152,'Mauritius Public Company Limited By Shares',0,1,NULL),(136,15204,152,'Mauritius Foreign Company',0,1,NULL),(137,15205,152,'Mauritius GBC1 (Offshore Company)',0,1,NULL),(138,15206,152,'Mauritius GBC2 (International Company)',0,1,NULL),(139,15207,152,'Mauritius General Partnership',0,1,NULL),(140,15208,152,'Mauritius Limited Partnership',0,1,NULL),(141,15209,152,'Mauritius Sole Proprietorship',0,1,NULL),(142,15210,152,'Mauritius Trusts',0,1,NULL),(143,15401,154,'Sociedad en nombre colectivo',0,1,NULL),(144,15402,154,'Sociedad en comandita simple',0,1,NULL),(145,15403,154,'Sociedad de responsabilidad limitada',0,1,NULL),(146,15404,154,'Sociedad anónima',0,1,NULL),(147,15405,154,'Sociedad en comandita por acciones',0,1,NULL),(148,15406,154,'Sociedad cooperativa',0,1,NULL);
/*!40000 ALTER TABLE `llx_c_forme_juridique` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_input_method`
--

DROP TABLE IF EXISTS `llx_c_input_method`;
CREATE TABLE `llx_c_input_method` (
  `rowid` int(11) NOT NULL auto_increment,
  `code` varchar(30) default NULL,
  `libelle` varchar(60) default NULL,
  `active` tinyint(4) NOT NULL default '1',
  `module` varchar(32) default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_c_input_method` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_input_method`
--

LOCK TABLES `llx_c_input_method` WRITE;
/*!40000 ALTER TABLE `llx_c_input_method` DISABLE KEYS */;
INSERT INTO `llx_c_input_method` VALUES (1,'OrderByMail','Courrier',1,NULL),(2,'OrderByFax','Fax',1,NULL),(3,'OrderByEMail','EMail',1,NULL),(4,'OrderByPhone','Téléphone',1,NULL),(5,'OrderByWWW','En ligne',1,NULL);
/*!40000 ALTER TABLE `llx_c_input_method` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_input_reason`
--

DROP TABLE IF EXISTS `llx_c_input_reason`;
CREATE TABLE `llx_c_input_reason` (
  `rowid` int(11) NOT NULL auto_increment,
  `code` varchar(30) default NULL,
  `label` varchar(60) default NULL,
  `active` tinyint(4) NOT NULL default '1',
  `module` varchar(32) default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_c_input_reason` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_input_reason`
--

LOCK TABLES `llx_c_input_reason` WRITE;
/*!40000 ALTER TABLE `llx_c_input_reason` DISABLE KEYS */;
INSERT INTO `llx_c_input_reason` VALUES (1,'SRC_INTE','Web site',1,NULL),(2,'SRC_CAMP_MAIL','Mailing campaign',1,NULL),(3,'SRC_CAMP_PHO','Phone campaign',1,NULL),(4,'SRC_CAMP_FAX','Fax campaign',1,NULL),(5,'SRC_COMM','Commercial contact',1,NULL),(6,'SRC_SHOP','Shop contact',1,NULL),(7,'SRC_CAMP_EMAIL','EMailing campaign',1,NULL);
/*!40000 ALTER TABLE `llx_c_input_reason` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_paiement`
--

DROP TABLE IF EXISTS `llx_c_paiement`;
CREATE TABLE `llx_c_paiement` (
  `id` int(11) NOT NULL,
  `code` varchar(6) NOT NULL,
  `libelle` varchar(30) default NULL,
  `type` smallint(6) default NULL,
  `active` tinyint(4) NOT NULL default '1',
  `module` varchar(32) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_paiement`
--

LOCK TABLES `llx_c_paiement` WRITE;
/*!40000 ALTER TABLE `llx_c_paiement` DISABLE KEYS */;
INSERT INTO `llx_c_paiement` VALUES (0,'','-',3,1,NULL),(1,'TIP','TIP',2,1,NULL),(2,'VIR','Virement',2,1,NULL),(3,'PRE','Prélèvement',2,1,NULL),(4,'LIQ','Espèces',2,1,NULL),(5,'VAD','Paiement en ligne',2,0,NULL),(6,'CB','Carte Bancaire',2,1,NULL),(7,'CHQ','Chèque',2,1,NULL),(8,'TRA','Traite',2,0,NULL),(9,'LCR','LCR',2,0,NULL),(10,'FAC','Factor',2,0,NULL),(11,'PRO','Proforma',2,0,NULL);
/*!40000 ALTER TABLE `llx_c_paiement` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_paper_format`
--

DROP TABLE IF EXISTS `llx_c_paper_format`;
CREATE TABLE `llx_c_paper_format` (
  `rowid` int(11) NOT NULL auto_increment,
  `code` varchar(16) NOT NULL,
  `label` varchar(50) NOT NULL,
  `width` float(6,2) default '0.00',
  `height` float(6,2) default '0.00',
  `unit` varchar(5) NOT NULL,
  `active` tinyint(4) NOT NULL default '1',
  `module` varchar(32) default NULL,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=226 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_paper_format`
--

LOCK TABLES `llx_c_paper_format` WRITE;
/*!40000 ALTER TABLE `llx_c_paper_format` DISABLE KEYS */;
INSERT INTO `llx_c_paper_format` VALUES (1,'EU4A0','Format 4A0',1682.00,2378.00,'mm',1,NULL),(2,'EU2A0','Format 2A0',1189.00,1682.00,'mm',1,NULL),(3,'EUA0','Format A0',840.00,1189.00,'mm',1,NULL),(4,'EUA1','Format A1',594.00,840.00,'mm',1,NULL),(5,'EUA2','Format A2',420.00,594.00,'mm',1,NULL),(6,'EUA3','Format A3',297.00,420.00,'mm',1,NULL),(7,'EUA4','Format A4',210.00,297.00,'mm',1,NULL),(8,'EUA5','Format A5',148.00,210.00,'mm',1,NULL),(9,'EUA6','Format A6',105.00,148.00,'mm',1,NULL),(100,'USLetter','Format Letter (A)',216.00,279.00,'mm',1,NULL),(105,'USLegal','Format Legal',216.00,356.00,'mm',1,NULL),(110,'USExecutive','Format Executive',190.00,254.00,'mm',1,NULL),(115,'USLedger','Format Ledger/Tabloid (B)',279.00,432.00,'mm',1,NULL),(200,'CAP1','Format Canadian P1',560.00,860.00,'mm',1,NULL),(205,'CAP2','Format Canadian P2',430.00,560.00,'mm',1,NULL),(210,'CAP3','Format Canadian P3',280.00,430.00,'mm',1,NULL),(215,'CAP4','Format Canadian P4',215.00,280.00,'mm',1,NULL),(220,'CAP5','Format Canadian P5',140.00,215.00,'mm',1,NULL),(225,'CAP6','Format Canadian P6',107.00,140.00,'mm',1,NULL);
/*!40000 ALTER TABLE `llx_c_paper_format` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_payment_term`
--

DROP TABLE IF EXISTS `llx_c_payment_term`;
CREATE TABLE `llx_c_payment_term` (
  `rowid` int(11) NOT NULL,
  `code` varchar(16) default NULL,
  `sortorder` smallint(6) default NULL,
  `active` tinyint(4) default '1',
  `libelle` varchar(255) default NULL,
  `libelle_facture` text,
  `fdm` tinyint(4) default NULL,
  `nbjour` smallint(6) default NULL,
  `decalage` smallint(6) default NULL,
  `module` varchar(32) default NULL,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_payment_term`
--

LOCK TABLES `llx_c_payment_term` WRITE;
/*!40000 ALTER TABLE `llx_c_payment_term` DISABLE KEYS */;
INSERT INTO `llx_c_payment_term` VALUES (1,'RECEP',1,1,'A réception','Réception de facture',0,0,NULL,NULL),(2,'30D',2,1,'30 jours','Réglement à 30 jours',0,30,NULL,NULL),(3,'30DENDMONTH',3,1,'30 jours fin de mois','Réglement à 30 jours fin de mois',1,30,NULL,NULL),(4,'60D',4,1,'60 jours','Réglement à 60 jours',0,60,NULL,NULL),(5,'60DENDMONTH',5,1,'60 jours fin de mois','Réglement à 60 jours fin de mois',1,60,NULL,NULL);
/*!40000 ALTER TABLE `llx_c_payment_term` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_pays`
--

DROP TABLE IF EXISTS `llx_c_pays`;
CREATE TABLE `llx_c_pays` (
  `rowid` int(11) NOT NULL,
  `code` varchar(2) NOT NULL,
  `code_iso` varchar(3) default NULL,
  `libelle` varchar(50) NOT NULL,
  `active` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `idx_c_pays_code` (`code`),
  UNIQUE KEY `idx_c_pays_libelle` (`libelle`),
  UNIQUE KEY `idx_c_pays_code_iso` (`code_iso`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_pays`
--

LOCK TABLES `llx_c_pays` WRITE;
/*!40000 ALTER TABLE `llx_c_pays` DISABLE KEYS */;
INSERT INTO `llx_c_pays` VALUES (0,'',NULL,'-',1),(1,'FR',NULL,'France',1),(2,'BE',NULL,'Belgium',1),(3,'IT',NULL,'Italy',1),(4,'ES',NULL,'Spain',1),(5,'DE',NULL,'Germany',1),(6,'CH',NULL,'Suisse',1),(7,'GB',NULL,'United Kingdom',1),(8,'IE',NULL,'Irland',1),(9,'CN',NULL,'China',1),(10,'TN',NULL,'Tunisie',1),(11,'US',NULL,'United States',1),(12,'MA',NULL,'Maroc',1),(13,'DZ',NULL,'Algérie',1),(14,'CA',NULL,'Canada',1),(15,'TG',NULL,'Togo',1),(16,'GA',NULL,'Gabon',1),(17,'NL',NULL,'Nerderland',1),(18,'HU',NULL,'Hongrie',1),(19,'RU',NULL,'Russia',1),(20,'SE',NULL,'Sweden',1),(21,'CI',NULL,'Côte d\'Ivoire',1),(22,'SN',NULL,'Sénégal',1),(23,'AR',NULL,'Argentine',1),(24,'CM',NULL,'Cameroun',1),(25,'PT',NULL,'Portugal',1),(26,'SA',NULL,'Arabie Saoudite',1),(27,'MC',NULL,'Monaco',1),(28,'AU',NULL,'Australia',1),(29,'SG',NULL,'Singapour',1),(30,'AF',NULL,'Afghanistan',1),(31,'AX',NULL,'Iles Aland',1),(32,'AL',NULL,'Albanie',1),(33,'AS',NULL,'Samoa américaines',1),(34,'AD',NULL,'Andorre',1),(35,'AO',NULL,'Angola',1),(36,'AI',NULL,'Anguilla',1),(37,'AQ',NULL,'Antarctique',1),(38,'AG',NULL,'Antigua-et-Barbuda',1),(39,'AM',NULL,'Arménie',1),(40,'AW',NULL,'Aruba',1),(41,'AT',NULL,'Autriche',1),(42,'AZ',NULL,'Azerbaïdjan',1),(43,'BS',NULL,'Bahamas',1),(44,'BH',NULL,'Bahreïn',1),(45,'BD',NULL,'Bangladesh',1),(46,'BB',NULL,'Barbade',1),(47,'BY',NULL,'Biélorussie',1),(48,'BZ',NULL,'Belize',1),(49,'BJ',NULL,'Bénin',1),(50,'BM',NULL,'Bermudes',1),(51,'BT',NULL,'Bhoutan',1),(52,'BO',NULL,'Bolivie',1),(53,'BA',NULL,'Bosnie-Herzégovine',1),(54,'BW',NULL,'Botswana',1),(55,'BV',NULL,'Ile Bouvet',1),(56,'BR',NULL,'Brésil',1),(57,'IO',NULL,'Territoire britannique de l\'Océan Indien',1),(58,'BN',NULL,'Brunei',1),(59,'BG',NULL,'Bulgarie',1),(60,'BF',NULL,'Burkina Faso',1),(61,'BI',NULL,'Burundi',1),(62,'KH',NULL,'Cambodge',1),(63,'CV',NULL,'Cap-Vert',1),(64,'KY',NULL,'Iles Cayman',1),(65,'CF',NULL,'République centrafricaine',1),(66,'TD',NULL,'Tchad',1),(67,'CL',NULL,'Chili',1),(68,'CX',NULL,'Ile Christmas',1),(69,'CC',NULL,'Iles des Cocos (Keeling)',1),(70,'CO',NULL,'Colombie',1),(71,'KM',NULL,'Comores',1),(72,'CG',NULL,'Congo',1),(73,'CD',NULL,'République démocratique du Congo',1),(74,'CK',NULL,'Iles Cook',1),(75,'CR',NULL,'Costa Rica',1),(76,'HR',NULL,'Croatie',1),(77,'CU',NULL,'Cuba',1),(78,'CY',NULL,'Chypre',1),(79,'CZ',NULL,'République Tchèque',1),(80,'DK',NULL,'Danemark',1),(81,'DJ',NULL,'Djibouti',1),(82,'DM',NULL,'Dominique',1),(83,'DO',NULL,'République Dominicaine',1),(84,'EC',NULL,'Equateur',1),(85,'EG',NULL,'Egypte',1),(86,'SV',NULL,'Salvador',1),(87,'GQ',NULL,'Guinée Equatoriale',1),(88,'ER',NULL,'Erythrée',1),(89,'EE',NULL,'Estonie',1),(90,'ET',NULL,'Ethiopie',1),(91,'FK',NULL,'Iles Falkland',1),(92,'FO',NULL,'Iles Féroé',1),(93,'FJ',NULL,'Iles Fidji',1),(94,'FI',NULL,'Finlande',1),(95,'GF',NULL,'Guyane française',1),(96,'PF',NULL,'Polynésie française',1),(97,'TF',NULL,'Terres australes françaises',1),(98,'GM',NULL,'Gambie',1),(99,'GE',NULL,'Géorgie',1),(100,'GH',NULL,'Ghana',1),(101,'GI',NULL,'Gibraltar',1),(102,'GR',NULL,'Grèce',1),(103,'GL',NULL,'Groenland',1),(104,'GD',NULL,'Grenade',1),(106,'GU',NULL,'Guam',1),(107,'GT',NULL,'Guatemala',1),(108,'GN',NULL,'Guinée',1),(109,'GW',NULL,'Guinée-Bissao',1),(111,'HT',NULL,'Haiti',1),(112,'HM',NULL,'Iles Heard et McDonald',1),(113,'VA',NULL,'Saint-Siège (Vatican)',1),(114,'HN',NULL,'Honduras',1),(115,'HK',NULL,'Hong Kong',1),(116,'IS',NULL,'Islande',1),(117,'IN',NULL,'India',1),(118,'ID',NULL,'Indonésie',1),(119,'IR',NULL,'Iran',1),(120,'IQ',NULL,'Iraq',1),(121,'IL',NULL,'Israel',1),(122,'JM',NULL,'Jamaïque',1),(123,'JP',NULL,'Japon',1),(124,'JO',NULL,'Jordanie',1),(125,'KZ',NULL,'Kazakhstan',1),(126,'KE',NULL,'Kenya',1),(127,'KI',NULL,'Kiribati',1),(128,'KP',NULL,'Corée du Nord',1),(129,'KR',NULL,'Corée du Sud',1),(130,'KW',NULL,'Koweït',1),(131,'KG',NULL,'Kirghizistan',1),(132,'LA',NULL,'Laos',1),(133,'LV',NULL,'Lettonie',1),(134,'LB',NULL,'Liban',1),(135,'LS',NULL,'Lesotho',1),(136,'LR',NULL,'Liberia',1),(137,'LY',NULL,'Libye',1),(138,'LI',NULL,'Liechtenstein',1),(139,'LT',NULL,'Lituanie',1),(140,'LU',NULL,'Luxembourg',1),(141,'MO',NULL,'Macao',1),(142,'MK',NULL,'ex-République yougoslave de Macédoine',1),(143,'MG',NULL,'Madagascar',1),(144,'MW',NULL,'Malawi',1),(145,'MY',NULL,'Malaisie',1),(146,'MV',NULL,'Maldives',1),(147,'ML',NULL,'Mali',1),(148,'MT',NULL,'Malte',1),(149,'MH',NULL,'Iles Marshall',1),(151,'MR',NULL,'Mauritanie',1),(152,'MU',NULL,'Maurice',1),(153,'YT',NULL,'Mayotte',1),(154,'MX',NULL,'Mexique',1),(155,'FM',NULL,'Micronésie',1),(156,'MD',NULL,'Moldavie',1),(157,'MN',NULL,'Mongolie',1),(158,'MS',NULL,'Monserrat',1),(159,'MZ',NULL,'Mozambique',1),(160,'MM',NULL,'Birmanie (Myanmar)',1),(161,'NA',NULL,'Namibie',1),(162,'NR',NULL,'Nauru',1),(163,'NP',NULL,'Népal',1),(164,'AN',NULL,'Antilles néerlandaises',1),(165,'NC',NULL,'Nouvelle-Calédonie',1),(166,'NZ',NULL,'Nouvelle-Zélande',1),(167,'NI',NULL,'Nicaragua',1),(168,'NE',NULL,'Niger',1),(169,'NG',NULL,'Nigeria',1),(170,'NU',NULL,'Nioué',1),(171,'NF',NULL,'Ile Norfolk',1),(172,'MP',NULL,'Mariannes du Nord',1),(173,'NO',NULL,'Norvège',1),(174,'OM',NULL,'Oman',1),(175,'PK',NULL,'Pakistan',1),(176,'PW',NULL,'Palaos',1),(177,'PS',NULL,'Territoire Palestinien Occupé',1),(178,'PA',NULL,'Panama',1),(179,'PG',NULL,'Papouasie-Nouvelle-Guinée',1),(180,'PY',NULL,'Paraguay',1),(181,'PE',NULL,'Pérou',1),(182,'PH',NULL,'Philippines',1),(183,'PN',NULL,'Iles Pitcairn',1),(184,'PL',NULL,'Pologne',1),(185,'PR',NULL,'Porto Rico',1),(186,'QA',NULL,'Qatar',1),(188,'RO',NULL,'Roumanie',1),(189,'RW',NULL,'Rwanda',1),(190,'SH',NULL,'Sainte-Hélène',1),(191,'KN',NULL,'Saint-Christophe-et-Niévès',1),(192,'LC',NULL,'Sainte-Lucie',1),(193,'PM',NULL,'Saint-Pierre-et-Miquelon',1),(194,'VC',NULL,'Saint-Vincent-et-les-Grenadines',1),(195,'WS',NULL,'Samoa',1),(196,'SM',NULL,'Saint-Marin',1),(197,'ST',NULL,'Sao Tomé-et-Principe',1),(198,'RS',NULL,'Serbie',1),(199,'SC',NULL,'Seychelles',1),(200,'SL',NULL,'Sierra Leone',1),(201,'SK',NULL,'Slovaquie',1),(202,'SI',NULL,'Slovénie',1),(203,'SB',NULL,'Iles Salomon',1),(204,'SO',NULL,'Somalie',1),(205,'ZA',NULL,'Afrique du Sud',1),(206,'GS',NULL,'Iles Géorgie du Sud et Sandwich du Sud',1),(207,'LK',NULL,'Sri Lanka',1),(208,'SD',NULL,'Soudan',1),(209,'SR',NULL,'Suriname',1),(210,'SJ',NULL,'Iles Svalbard et Jan Mayen',1),(211,'SZ',NULL,'Swaziland',1),(212,'SY',NULL,'Syrie',1),(213,'TW',NULL,'Taïwan',1),(214,'TJ',NULL,'Tadjikistan',1),(215,'TZ',NULL,'Tanzanie',1),(216,'TH',NULL,'Thaïlande',1),(217,'TL',NULL,'Timor Oriental',1),(218,'TK',NULL,'Tokélaou',1),(219,'TO',NULL,'Tonga',1),(220,'TT',NULL,'Trinité-et-Tobago',1),(221,'TR',NULL,'Turquie',1),(222,'TM',NULL,'Turkménistan',1),(223,'TC',NULL,'Iles Turks-et-Caicos',1),(224,'TV',NULL,'Tuvalu',1),(225,'UG',NULL,'Ouganda',1),(226,'UA',NULL,'Ukraine',1),(227,'AE',NULL,'Émirats arabes unis',1),(228,'UM',NULL,'Iles mineures éloignées des États-Unis',1),(229,'UY',NULL,'Uruguay',1),(230,'UZ',NULL,'Ouzbékistan',1),(231,'VU',NULL,'Vanuatu',1),(232,'VE',NULL,'Vénézuela',1),(233,'VN',NULL,'Viêt Nam',1),(234,'VG',NULL,'Iles Vierges britanniques',1),(235,'VI',NULL,'Iles Vierges américaines',1),(236,'WF',NULL,'Wallis-et-Futuna',1),(237,'EH',NULL,'Sahara occidental',1),(238,'YE',NULL,'Yémen',1),(239,'ZM',NULL,'Zambie',1),(240,'ZW',NULL,'Zimbabwe',1),(241,'GG',NULL,'Guernesey',1),(242,'IM',NULL,'Ile de Man',1),(243,'JE',NULL,'Jersey',1),(244,'ME',NULL,'Monténégro',1),(245,'BL',NULL,'Saint-Barthélemy',1),(246,'MF',NULL,'Saint-Martin',1);
/*!40000 ALTER TABLE `llx_c_pays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_propalst`
--

DROP TABLE IF EXISTS `llx_c_propalst`;
CREATE TABLE `llx_c_propalst` (
  `id` smallint(6) NOT NULL,
  `code` varchar(12) NOT NULL,
  `label` varchar(30) default NULL,
  `active` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_propalst`
--

LOCK TABLES `llx_c_propalst` WRITE;
/*!40000 ALTER TABLE `llx_c_propalst` DISABLE KEYS */;
INSERT INTO `llx_c_propalst` VALUES (0,'PR_DRAFT','Brouillon',1),(1,'PR_OPEN','Ouverte',1),(2,'PR_SIGNED','Signée',1),(3,'PR_NOTSIGNED','Non Signée',1),(4,'PR_FAC','Facturée',1);
/*!40000 ALTER TABLE `llx_c_propalst` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_prospectlevel`
--

DROP TABLE IF EXISTS `llx_c_prospectlevel`;
CREATE TABLE `llx_c_prospectlevel` (
  `code` varchar(12) NOT NULL,
  `label` varchar(30) default NULL,
  `sortorder` smallint(6) default NULL,
  `active` smallint(6) NOT NULL default '1',
  `module` varchar(32) default NULL,
  PRIMARY KEY  (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_prospectlevel`
--

LOCK TABLES `llx_c_prospectlevel` WRITE;
/*!40000 ALTER TABLE `llx_c_prospectlevel` DISABLE KEYS */;
INSERT INTO `llx_c_prospectlevel` VALUES ('PL_HIGH','High',4,1,NULL),('PL_LOW','Low',2,1,NULL),('PL_MEDIUM','Medium',3,1,NULL),('PL_NONE','None',1,1,NULL);
/*!40000 ALTER TABLE `llx_c_prospectlevel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_regions`
--

DROP TABLE IF EXISTS `llx_c_regions`;
CREATE TABLE `llx_c_regions` (
  `rowid` int(11) NOT NULL auto_increment,
  `code_region` int(11) NOT NULL,
  `fk_pays` int(11) NOT NULL,
  `cheflieu` varchar(50) default NULL,
  `tncc` int(11) default NULL,
  `nom` varchar(50) default NULL,
  `active` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `code_region` (`code_region`),
  KEY `idx_c_regions_fk_pays` (`fk_pays`),
  CONSTRAINT `fk_c_regions_fk_pays` FOREIGN KEY (`fk_pays`) REFERENCES `llx_c_pays` (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=15402 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_regions`
--

LOCK TABLES `llx_c_regions` WRITE;
/*!40000 ALTER TABLE `llx_c_regions` DISABLE KEYS */;
INSERT INTO `llx_c_regions` VALUES (1,0,0,'0',0,'-',1),(101,1,1,'97105',3,'Guadeloupe',1),(102,2,1,'97209',3,'Martinique',1),(103,3,1,'97302',3,'Guyane',1),(104,4,1,'97411',3,'Réunion',1),(105,11,1,'75056',1,'Île-de-France',1),(106,21,1,'51108',0,'Champagne-Ardenne',1),(107,22,1,'80021',0,'Picardie',1),(108,23,1,'76540',0,'Haute-Normandie',1),(109,24,1,'45234',2,'Centre',1),(110,25,1,'14118',0,'Basse-Normandie',1),(111,26,1,'21231',0,'Bourgogne',1),(112,31,1,'59350',2,'Nord-Pas-de-Calais',1),(113,41,1,'57463',0,'Lorraine',1),(114,42,1,'67482',1,'Alsace',1),(115,43,1,'25056',0,'Franche-Comté',1),(116,52,1,'44109',4,'Pays de la Loire',1),(117,53,1,'35238',0,'Bretagne',1),(118,54,1,'86194',2,'Poitou-Charentes',1),(119,72,1,'33063',1,'Aquitaine',1),(120,73,1,'31555',0,'Midi-Pyrénées',1),(121,74,1,'87085',2,'Limousin',1),(122,82,1,'69123',2,'Rhône-Alpes',1),(123,83,1,'63113',1,'Auvergne',1),(124,91,1,'34172',2,'Languedoc-Roussillon',1),(125,93,1,'13055',0,'Provence-Alpes-Côte d\'Azur',1),(126,94,1,'2A004',0,'Corse',1),(201,201,2,'',1,'Flandre',1),(202,202,2,'',2,'Wallonie',1),(203,203,2,'',3,'Bruxelles-Capitale',1),(301,301,3,NULL,1,'Abruzzo',1),(302,302,3,NULL,1,'Basilicata',1),(303,303,3,NULL,1,'Calabria',1),(304,304,3,NULL,1,'Campania',1),(305,305,3,NULL,1,'Emilia-Romagna',1),(306,306,3,NULL,1,'Friuli-Venezia Giulia',1),(307,307,3,NULL,1,'Lazio',1),(308,308,3,NULL,1,'Liguria',1),(309,309,3,NULL,1,'Lombardia',1),(310,310,3,NULL,1,'Marche',1),(311,311,3,NULL,1,'Molise',1),(312,312,3,NULL,1,'Piemonte',1),(313,313,3,NULL,1,'Puglia',1),(314,314,3,NULL,1,'Sardegna',1),(315,315,3,NULL,1,'Sicilia',1),(316,316,3,NULL,1,'Toscana',1),(317,317,3,NULL,1,'Trentino-Alto Adige',1),(318,318,3,NULL,1,'Umbria',1),(319,319,3,NULL,1,'Valle d Aosta',1),(320,320,3,NULL,1,'Veneto',1),(401,401,4,'',0,'Andalucia',1),(402,402,4,'',0,'Aragón',1),(403,403,4,'',0,'Castilla y León',1),(404,404,4,'',0,'Castilla la Mancha',1),(405,405,4,'',0,'Canarias',1),(406,406,4,'',0,'Cataluña',1),(407,407,4,'',0,'Comunidad de Ceuta',1),(408,408,4,'',0,'Comunidad Foral de Navarra',1),(409,409,4,'',0,'Comunidad de Melilla',1),(410,410,4,'',0,'Cantabria',1),(411,411,4,'',0,'Comunidad Valenciana',1),(412,412,4,'',0,'Extemadura',1),(413,413,4,'',0,'Galicia',1),(414,414,4,'',0,'Islas Baleares',1),(415,415,4,'',0,'La Rioja',1),(416,416,4,'',0,'Comunidad de Madrid',1),(417,417,4,'',0,'Región de Murcia',1),(418,418,4,'',0,'Principado de Asturias',1),(419,419,4,'',0,'Pais Vasco',1),(420,420,4,'',0,'Otros',1),(601,601,6,'',1,'Cantons',1),(1001,1001,10,'',0,'Ariana',1),(1002,1002,10,'',0,'Béja',1),(1003,1003,10,'',0,'Ben Arous',1),(1004,1004,10,'',0,'Bizerte',1),(1005,1005,10,'',0,'Gabès',1),(1006,1006,10,'',0,'Gafsa',1),(1007,1007,10,'',0,'Jendouba',1),(1008,1008,10,'',0,'Kairouan',1),(1009,1009,10,'',0,'Kasserine',1),(1010,1010,10,'',0,'Kébili',1),(1011,1011,10,'',0,'La Manouba',1),(1012,1012,10,'',0,'Le Kef',1),(1013,1013,10,'',0,'Mahdia',1),(1014,1014,10,'',0,'Médenine',1),(1015,1015,10,'',0,'Monastir',1),(1016,1016,10,'',0,'Nabeul',1),(1017,1017,10,'',0,'Sfax',1),(1018,1018,10,'',0,'Sidi Bouzid',1),(1019,1019,10,'',0,'Siliana',1),(1020,1020,10,'',0,'Sousse',1),(1021,1021,10,'',0,'Tataouine',1),(1022,1022,10,'',0,'Tozeur',1),(1023,1023,10,'',0,'Tunis',1),(1024,1024,10,'',0,'Zaghouan',1),(1101,1101,11,'',0,'United-States',1),(2301,2301,23,'',0,'Norte',1),(2302,2302,23,'',0,'Litoral',1),(2303,2303,23,'',0,'Cuyana',1),(2304,2304,23,'',0,'Central',1),(2305,2305,23,'',0,'Patagonia',1),(2801,2801,28,'',0,'Australia',1),(4601,4601,46,'',0,'Barbados',1),(6701,6701,67,NULL,NULL,'Tarapacá',1),(6702,6702,67,NULL,NULL,'Antofagasta',1),(6703,6703,67,NULL,NULL,'Atacama',1),(6704,6704,67,NULL,NULL,'Coquimbo',1),(6705,6705,67,NULL,NULL,'Valparaíso',1),(6706,6706,67,NULL,NULL,'General Bernardo O Higgins',1),(6707,6707,67,NULL,NULL,'Maule',1),(6708,6708,67,NULL,NULL,'Biobío',1),(6709,6709,67,NULL,NULL,'Raucanía',1),(6710,6710,67,NULL,NULL,'Los Lagos',1),(6711,6711,67,NULL,NULL,'Aysén General Carlos Ibáñez del Campo',1),(6712,6712,67,NULL,NULL,'Magallanes y Antártica Chilena',1),(6713,6713,67,NULL,NULL,'Metropolitana de Santiago',1),(6714,6714,67,NULL,NULL,'Los Ríos',1),(6715,6715,67,NULL,NULL,'Arica y Parinacota',1),(7001,7001,70,'',0,'Colombie',1),(8601,8601,86,NULL,NULL,'Central',1),(8602,8602,86,NULL,NULL,'Oriental',1),(8603,8603,86,NULL,NULL,'Occidental',1),(11401,11401,114,'',0,'Honduras',1),(11701,11701,117,'',0,'India',1),(15201,15201,152,'',0,'Rivière Noire',1),(15202,15202,152,'',0,'Flacq',1),(15203,15203,152,'',0,'Grand Port',1),(15204,15204,152,'',0,'Moka',1),(15205,15205,152,'',0,'Pamplemousses',1),(15206,15206,152,'',0,'Plaines Wilhems',1),(15207,15207,152,'',0,'Port-Louis',1),(15208,15208,152,'',0,'Rivière du Rempart',1),(15209,15209,152,'',0,'Savanne',1),(15210,15210,152,'',0,'Rodrigues',1),(15211,15211,152,'',0,'Les îles Agaléga',1),(15212,15212,152,'',0,'Les écueils des Cargados Carajos',1),(15401,15401,154,'',0,'Mexique',1);
/*!40000 ALTER TABLE `llx_c_regions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_shipment_mode`
--

DROP TABLE IF EXISTS `llx_c_shipment_mode`;
CREATE TABLE `llx_c_shipment_mode` (
  `rowid` int(11) NOT NULL,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `code` varchar(30) NOT NULL,
  `libelle` varchar(50) NOT NULL,
  `description` text,
  `active` tinyint(4) default '0',
  `module` varchar(32) default NULL,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_shipment_mode`
--

LOCK TABLES `llx_c_shipment_mode` WRITE;
/*!40000 ALTER TABLE `llx_c_shipment_mode` DISABLE KEYS */;
INSERT INTO `llx_c_shipment_mode` VALUES (1,'2013-08-28 17:08:23','CATCH','Catch','Catch by client',1,NULL),(2,'2013-08-28 17:08:23','TRANS','Transporter','Generic transporter',1,NULL),(3,'2013-08-28 17:08:23','COLSUI','Colissimo Suivi','Colissimo Suivi',0,NULL),(4,'2013-08-28 17:08:23','LETTREMAX','Lettre Max','Courrier Suivi et Lettre Max',0,NULL);
/*!40000 ALTER TABLE `llx_c_shipment_mode` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_stcomm`
--

DROP TABLE IF EXISTS `llx_c_stcomm`;
CREATE TABLE `llx_c_stcomm` (
  `id` int(11) NOT NULL,
  `code` varchar(12) NOT NULL,
  `libelle` varchar(30) default NULL,
  `active` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_stcomm`
--

LOCK TABLES `llx_c_stcomm` WRITE;
/*!40000 ALTER TABLE `llx_c_stcomm` DISABLE KEYS */;
INSERT INTO `llx_c_stcomm` VALUES (-1,'ST_NO','Ne pas contacter',1),(0,'ST_NEVER','Jamais contacté',1),(1,'ST_TODO','A contacter',1),(2,'ST_PEND','Contact en cours',1),(3,'ST_DONE','Contactée',1);
/*!40000 ALTER TABLE `llx_c_stcomm` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_tva`
--

DROP TABLE IF EXISTS `llx_c_tva`;
CREATE TABLE `llx_c_tva` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_pays` int(11) NOT NULL,
  `taux` double NOT NULL,
  `localtax1` double NOT NULL default '0',
  `localtax2` double NOT NULL default '0',
  `recuperableonly` int(11) NOT NULL default '0',
  `note` varchar(128) default NULL,
  `active` tinyint(4) NOT NULL default '1',
  `accountancy_code` varchar(15) default NULL,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=2462 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_tva`
--

LOCK TABLES `llx_c_tva` WRITE;
/*!40000 ALTER TABLE `llx_c_tva` DISABLE KEYS */;
INSERT INTO `llx_c_tva` VALUES (11,1,19.6,0,0,0,'VAT standard rate (France hors DOM-TOM)',1,NULL),(12,1,8.5,0,0,0,'VAT standard rate (DOM sauf Guyane et Saint-Martin)',0,NULL),(13,1,8.5,0,0,1,'VAT standard rate (DOM sauf Guyane et Saint-Martin), non perçu par le vendeur mais récupérable par acheteur',0,NULL),(14,1,5.5,0,0,0,'VAT reduced rate (France hors DOM-TOM)',1,NULL),(15,1,0,0,0,0,'VAT Rate 0 ou non applicable',1,NULL),(16,1,2.1,0,0,0,'VAT super-reduced rate',1,NULL),(17,1,7,0,0,0,'VAT reduced rate',1,NULL),(21,2,21,0,0,0,'VAT standard rate',1,NULL),(22,2,6,0,0,0,'VAT reduced rate',1,NULL),(23,2,0,0,0,0,'VAT Rate 0 ou non applicable',1,NULL),(24,2,12,0,0,0,'VAT reduced rate',1,NULL),(31,3,21,0,0,0,'VAT standard rate',1,NULL),(32,3,10,0,0,0,'VAT reduced rate',1,NULL),(33,3,4,0,0,0,'VAT super-reduced rate',1,NULL),(34,3,0,0,0,0,'VAT Rate 0',1,NULL),(41,4,18,4,0,0,'VAT standard rate',1,NULL),(42,4,8,1,0,0,'VAT reduced rate',1,NULL),(43,4,4,0.5,0,0,'VAT super-reduced rate',1,NULL),(44,4,0,0,0,0,'VAT Rate 0',1,NULL),(51,5,19,0,0,0,'VAT standard rate',1,NULL),(52,5,7,0,0,0,'VAT reduced rate',1,NULL),(53,5,0,0,0,0,'VAT Rate 0',1,NULL),(61,6,7.6,0,0,0,'VAT standard rate',1,NULL),(62,6,3.6,0,0,0,'VAT reduced rate',1,NULL),(63,6,2.4,0,0,0,'VAT super-reduced rate',1,NULL),(64,6,0,0,0,0,'VAT Rate 0',1,NULL),(71,7,20,0,0,0,'VAT standard rate',1,NULL),(72,7,17.5,0,0,0,'VAT standard rate before 2011',1,NULL),(73,7,5,0,0,0,'VAT reduced rate',1,NULL),(74,7,0,0,0,0,'VAT Rate 0',1,NULL),(91,9,17,0,0,0,'VAT standard rate',1,NULL),(92,9,13,0,0,0,'VAT reduced rate 0',1,NULL),(93,9,3,0,0,0,'VAT super reduced rate 0',1,NULL),(94,9,0,0,0,0,'VAT Rate 0',1,NULL),(101,10,6,0,0,0,'VAT 6%',1,NULL),(102,10,12,0,0,0,'VAT 12%',1,NULL),(103,10,18,0,0,0,'VAT 18%',1,NULL),(104,10,7.5,0,0,0,'VAT 6% Majoré à 25% (7.5%)',1,NULL),(105,10,15,0,0,0,'VAT 12% Majoré à 25% (15%)',1,NULL),(106,10,22.5,0,0,0,'VAT 18% Majoré à 25% (22.5%)',1,NULL),(107,10,0,0,0,0,'VAT Rate 0',1,NULL),(111,11,0,0,0,0,'No Sales Tax',1,NULL),(112,11,4,0,0,0,'Sales Tax 4%',1,NULL),(113,11,6,0,0,0,'Sales Tax 6%',1,NULL),(121,12,20,0,0,0,'VAT standard rate',1,NULL),(122,12,14,0,0,0,'VAT reduced rate',1,NULL),(123,12,10,0,0,0,'VAT reduced rate',1,NULL),(124,12,7,0,0,0,'VAT super-reduced rate',1,NULL),(125,12,0,0,0,0,'VAT Rate 0',1,NULL),(141,14,7,0,0,0,'VAT standard rate',1,NULL),(142,14,0,0,0,0,'VAT Rate 0',1,NULL),(171,17,19,0,0,0,'VAT standard rate',1,NULL),(172,17,6,0,0,0,'VAT reduced rate',1,NULL),(173,17,0,0,0,0,'VAT Rate 0',1,NULL),(201,20,25,0,0,0,'VAT standard rate',1,NULL),(202,20,12,0,0,0,'VAT reduced rate',1,NULL),(203,20,6,0,0,0,'VAT super-reduced rate',1,NULL),(204,20,0,0,0,0,'VAT Rate 0',1,NULL),(231,23,21,0,0,0,'IVA standard rate',1,NULL),(232,23,10.5,0,0,0,'IVA reduced rate',1,NULL),(233,23,0,0,0,0,'IVA Rate 0',1,NULL),(251,25,20,0,0,0,'VAT standard rate',1,NULL),(252,25,12,0,0,0,'VAT reduced rate',1,NULL),(253,25,0,0,0,0,'VAT Rate 0',1,NULL),(254,25,5,0,0,0,'VAT reduced rate',1,NULL),(281,28,10,0,0,0,'VAT standard rate',1,NULL),(282,28,0,0,0,0,'VAT Rate 0',1,NULL),(411,41,20,0,0,0,'VAT standard rate',1,NULL),(412,41,10,0,0,0,'VAT reduced rate',1,NULL),(413,41,0,0,0,0,'VAT Rate 0',1,NULL),(461,46,0,0,0,0,'No VAT',1,NULL),(462,46,15,0,0,0,'VAT 15%',1,NULL),(463,46,7.5,0,0,0,'VAT 7.5%',1,NULL),(591,59,20,0,0,0,'VAT standard rate',1,NULL),(592,59,7,0,0,0,'VAT reduced rate',1,NULL),(593,59,0,0,0,0,'VAT Rate 0',1,NULL),(671,67,19,0,0,0,'VAT standard rate',1,NULL),(672,67,0,0,0,0,'VAT Rate 0',1,NULL),(801,80,25,0,0,0,'VAT standard rate',1,NULL),(802,80,0,0,0,0,'VAT Rate 0',1,NULL),(861,86,13,0,0,0,'IVA 13',1,NULL),(862,86,0,0,0,0,'SIN IVA',1,NULL),(1141,114,0,0,0,0,'No ISV',1,NULL),(1142,114,12,0,0,0,'ISV 12%',1,NULL),(1161,116,25.5,0,0,0,'VAT standard rate',1,NULL),(1162,116,7,0,0,0,'VAT reduced rate',1,NULL),(1163,116,0,0,0,0,'VAT rate 0',1,NULL),(1171,117,12.5,0,0,0,'VAT standard rate',1,NULL),(1172,117,4,0,0,0,'VAT reduced rate',1,NULL),(1173,117,1,0,0,0,'VAT super-reduced rate',1,NULL),(1174,117,0,0,0,0,'VAT Rate 0',1,NULL),(1231,123,0,0,0,0,'VAT Rate 0',1,NULL),(1232,123,5,0,0,0,'VAT Rate 5',1,NULL),(1401,140,15,0,0,0,'VAT standard rate',1,NULL),(1402,140,12,0,0,0,'VAT reduced rate',1,NULL),(1403,140,6,0,0,0,'VAT reduced rate',1,NULL),(1404,140,3,0,0,0,'VAT super-reduced rate',1,NULL),(1405,140,0,0,0,0,'VAT Rate 0',1,NULL),(1521,152,0,0,0,0,'VAT Rate 0',1,NULL),(1522,152,15,0,0,0,'VAT Rate 15',1,NULL),(1541,154,0,0,0,0,'No VAT',1,NULL),(1542,154,16,0,0,0,'VAT 16%',1,NULL),(1543,154,10,0,0,0,'VAT Frontero',1,NULL),(1662,166,15,0,0,0,'VAT standard rate',1,NULL),(1663,166,0,0,0,0,'VAT Rate 0',1,NULL),(1731,173,25,0,0,0,'VAT standard rate',1,NULL),(1732,173,14,0,0,0,'VAT reduced rate',1,NULL),(1733,173,8,0,0,0,'VAT reduced rate',1,NULL),(1734,173,0,0,0,0,'VAT Rate 0',1,NULL),(1841,184,20,0,0,0,'VAT standard rate',1,NULL),(1842,184,7,0,0,0,'VAT reduced rate',1,NULL),(1843,184,3,0,0,0,'VAT reduced rate',1,NULL),(1844,184,0,0,0,0,'VAT Rate 0',1,NULL),(1881,188,24,0,0,0,'VAT standard rate',1,NULL),(1882,188,9,0,0,0,'VAT reduced rate',1,NULL),(1883,188,0,0,0,0,'VAT Rate 0',1,NULL),(1884,188,5,0,0,0,'VAT reduced rate',1,NULL),(1931,193,0,0,0,0,'No VAT in SPM',1,NULL),(2011,201,19,0,0,0,'VAT standard rate',1,NULL),(2012,201,10,0,0,0,'VAT reduced rate',1,NULL),(2013,201,0,0,0,0,'VAT Rate 0',1,NULL),(2021,202,20,0,0,0,'VAT standard rate',1,NULL),(2022,202,8.5,0,0,0,'VAT reduced rate',1,NULL),(2023,202,0,0,0,0,'VAT Rate 0',1,NULL),(2461,246,0,0,0,0,'VAT Rate 0',1,NULL);
/*!40000 ALTER TABLE `llx_c_tva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_type_contact`
--

DROP TABLE IF EXISTS `llx_c_type_contact`;
CREATE TABLE `llx_c_type_contact` (
  `rowid` int(11) NOT NULL,
  `element` varchar(30) NOT NULL,
  `source` varchar(8) NOT NULL default 'external',
  `code` varchar(16) NOT NULL,
  `libelle` varchar(64) NOT NULL,
  `active` tinyint(4) NOT NULL default '1',
  `module` varchar(32) default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `idx_c_type_contact_uk` (`element`,`source`,`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_type_contact`
--

LOCK TABLES `llx_c_type_contact` WRITE;
/*!40000 ALTER TABLE `llx_c_type_contact` DISABLE KEYS */;
INSERT INTO `llx_c_type_contact` VALUES (10,'contrat','internal','SALESREPSIGN','Commercial signataire du contrat',1,NULL),(11,'contrat','internal','SALESREPFOLL','Commercial suivi du contrat',1,NULL),(20,'contrat','external','BILLING','Contact client facturation contrat',1,NULL),(21,'contrat','external','CUSTOMER','Contact client suivi contrat',1,NULL),(22,'contrat','external','SALESREPSIGN','Contact client signataire contrat',1,NULL),(31,'propal','internal','SALESREPFOLL','Commercial à l\'origine de la propale',1,NULL),(40,'propal','external','BILLING','Contact client facturation propale',1,NULL),(41,'propal','external','CUSTOMER','Contact client suivi propale',1,NULL),(50,'facture','internal','SALESREPFOLL','Responsable suivi du paiement',1,NULL),(60,'facture','external','BILLING','Contact client facturation',1,NULL),(61,'facture','external','SHIPPING','Contact client livraison',1,NULL),(62,'facture','external','SERVICE','Contact client prestation',1,NULL),(70,'invoice_supplier','internal','SALESREPFOLL','Responsable suivi du paiement',1,NULL),(71,'invoice_supplier','external','BILLING','Contact fournisseur facturation',1,NULL),(72,'invoice_supplier','external','SHIPPING','Contact fournisseur livraison',1,NULL),(73,'invoice_supplier','external','SERVICE','Contact fournisseur prestation',1,NULL),(91,'commande','internal','SALESREPFOLL','Responsable suivi de la commande',1,NULL),(100,'commande','external','BILLING','Contact client facturation commande',1,NULL),(101,'commande','external','CUSTOMER','Contact client suivi commande',1,NULL),(102,'commande','external','SHIPPING','Contact client livraison commande',1,NULL),(120,'fichinter','internal','INTERREPFOLL','Responsable suivi de l\'intervention',1,NULL),(121,'fichinter','internal','INTERVENING','Intervenant',1,NULL),(130,'fichinter','external','BILLING','Contact client facturation intervention',1,NULL),(131,'fichinter','external','CUSTOMER','Contact client suivi de l\'intervention',1,NULL),(140,'order_supplier','internal','SALESREPFOLL','Responsable suivi de la commande',1,NULL),(141,'order_supplier','internal','SHIPPING','Responsable réception de la commande',1,NULL),(142,'order_supplier','external','BILLING','Contact fournisseur facturation commande',1,NULL),(143,'order_supplier','external','CUSTOMER','Contact fournisseur suivi commande',1,NULL),(145,'order_supplier','external','SHIPPING','Contact fournisseur livraison commande',1,NULL),(160,'project','internal','PROJECTLEADER','Chef de Projet',1,NULL),(161,'project','internal','CONTRIBUTOR','Intervenant',1,NULL),(170,'project','external','PROJECTLEADER','Chef de Projet',1,NULL),(171,'project','external','CONTRIBUTOR','Intervenant',1,NULL),(180,'project_task','internal','TASKEXECUTIVE','Responsable',1,NULL),(181,'project_task','internal','CONTRIBUTOR','Intervenant',1,NULL),(190,'project_task','external','TASKEXECUTIVE','Responsable',1,NULL),(191,'project_task','external','CONTRIBUTOR','Intervenant',1,NULL);
/*!40000 ALTER TABLE `llx_c_type_contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_type_fees`
--

DROP TABLE IF EXISTS `llx_c_type_fees`;
CREATE TABLE `llx_c_type_fees` (
  `id` int(11) NOT NULL auto_increment,
  `code` varchar(12) NOT NULL,
  `libelle` varchar(30) default NULL,
  `active` tinyint(4) NOT NULL default '1',
  `module` varchar(32) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_type_fees`
--

LOCK TABLES `llx_c_type_fees` WRITE;
/*!40000 ALTER TABLE `llx_c_type_fees` DISABLE KEYS */;
INSERT INTO `llx_c_type_fees` VALUES (1,'TF_OTHER','Other',1,NULL),(2,'TF_TRIP','Trip',1,NULL),(3,'TF_LUNCH','Lunch',1,NULL);
/*!40000 ALTER TABLE `llx_c_type_fees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_typent`
--

DROP TABLE IF EXISTS `llx_c_typent`;
CREATE TABLE `llx_c_typent` (
  `id` int(11) NOT NULL,
  `code` varchar(12) NOT NULL,
  `libelle` varchar(30) default NULL,
  `active` tinyint(4) NOT NULL default '1',
  `module` varchar(32) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_typent`
--

LOCK TABLES `llx_c_typent` WRITE;
/*!40000 ALTER TABLE `llx_c_typent` DISABLE KEYS */;
INSERT INTO `llx_c_typent` VALUES (0,'TE_UNKNOWN','-',1,NULL),(1,'TE_STARTUP','Start-up',0,NULL),(2,'TE_GROUP','Grand groupe',1,NULL),(3,'TE_MEDIUM','PME/PMI',1,NULL),(4,'TE_SMALL','TPE',1,NULL),(5,'TE_ADMIN','Administration',1,NULL),(6,'TE_WHOLE','Grossiste',0,NULL),(7,'TE_RETAIL','Revendeur',0,NULL),(8,'TE_PRIVATE','Particulier',1,NULL),(100,'TE_OTHER','Autres',1,NULL);
/*!40000 ALTER TABLE `llx_c_typent` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_ziptown`
--

DROP TABLE IF EXISTS `llx_c_ziptown`;
CREATE TABLE `llx_c_ziptown` (
  `rowid` int(11) NOT NULL auto_increment,
  `code` varchar(5) default NULL,
  `fk_county` int(11) default NULL,
  `fk_pays` int(11) NOT NULL default '0',
  `zip` varchar(10) NOT NULL,
  `town` varchar(255) NOT NULL,
  `active` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_ziptown_fk_pays` (`zip`,`town`,`fk_pays`),
  KEY `idx_c_ziptown_fk_county` (`fk_county`),
  KEY `idx_c_ziptown_fk_pays` (`fk_pays`),
  KEY `idx_c_ziptown_zip` (`zip`),
  CONSTRAINT `fk_c_ziptown_fk_county` FOREIGN KEY (`fk_county`) REFERENCES `llx_c_departements` (`rowid`),
  CONSTRAINT `fk_c_ziptown_fk_pays` FOREIGN KEY (`fk_pays`) REFERENCES `llx_c_pays` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_c_ziptown`
--

LOCK TABLES `llx_c_ziptown` WRITE;
/*!40000 ALTER TABLE `llx_c_ziptown` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_c_ziptown` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_categorie`
--

DROP TABLE IF EXISTS `llx_categorie`;
CREATE TABLE `llx_categorie` (
  `rowid` int(11) NOT NULL auto_increment,
  `label` varchar(255) default NULL,
  `type` tinyint(4) NOT NULL default '1',
  `entity` int(11) NOT NULL default '1',
  `description` text,
  `fk_soc` int(11) default NULL,
  `visible` tinyint(4) NOT NULL default '1',
  `import_key` varchar(14) default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_categorie_ref` (`label`,`type`,`entity`),
  KEY `idx_categorie_type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_categorie`
--

LOCK TABLES `llx_categorie` WRITE;
/*!40000 ALTER TABLE `llx_categorie` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_categorie` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_categorie_association`
--

DROP TABLE IF EXISTS `llx_categorie_association`;
CREATE TABLE `llx_categorie_association` (
  `fk_categorie_mere` int(11) NOT NULL,
  `fk_categorie_fille` int(11) NOT NULL,
  UNIQUE KEY `uk_categorie_association` (`fk_categorie_mere`,`fk_categorie_fille`),
  UNIQUE KEY `uk_categorie_association_fk_categorie_fille` (`fk_categorie_fille`),
  CONSTRAINT `fk_categorie_asso_fk_categorie_fille` FOREIGN KEY (`fk_categorie_fille`) REFERENCES `llx_categorie` (`rowid`),
  CONSTRAINT `fk_categorie_asso_fk_categorie_mere` FOREIGN KEY (`fk_categorie_mere`) REFERENCES `llx_categorie` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_categorie_association`
--

LOCK TABLES `llx_categorie_association` WRITE;
/*!40000 ALTER TABLE `llx_categorie_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_categorie_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_categorie_fournisseur`
--

DROP TABLE IF EXISTS `llx_categorie_fournisseur`;
CREATE TABLE `llx_categorie_fournisseur` (
  `fk_categorie` int(11) NOT NULL,
  `fk_societe` int(11) NOT NULL,
  UNIQUE KEY `fk_categorie` (`fk_categorie`,`fk_societe`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_categorie_fournisseur`
--

LOCK TABLES `llx_categorie_fournisseur` WRITE;
/*!40000 ALTER TABLE `llx_categorie_fournisseur` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_categorie_fournisseur` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_categorie_member`
--

DROP TABLE IF EXISTS `llx_categorie_member`;
CREATE TABLE `llx_categorie_member` (
  `fk_categorie` int(11) NOT NULL,
  `fk_member` int(11) NOT NULL,
  PRIMARY KEY  (`fk_categorie`,`fk_member`),
  KEY `idx_categorie_member_fk_categorie` (`fk_categorie`),
  KEY `idx_categorie_member_fk_member` (`fk_member`),
  CONSTRAINT `fk_categorie_member_categorie_rowid` FOREIGN KEY (`fk_categorie`) REFERENCES `llx_categorie` (`rowid`),
  CONSTRAINT `fk_categorie_member_member_rowid` FOREIGN KEY (`fk_member`) REFERENCES `llx_adherent` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_categorie_member`
--

LOCK TABLES `llx_categorie_member` WRITE;
/*!40000 ALTER TABLE `llx_categorie_member` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_categorie_member` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_categorie_product`
--

DROP TABLE IF EXISTS `llx_categorie_product`;
CREATE TABLE `llx_categorie_product` (
  `fk_categorie` int(11) NOT NULL,
  `fk_product` int(11) NOT NULL,
  PRIMARY KEY  (`fk_categorie`,`fk_product`),
  KEY `idx_categorie_product_fk_categorie` (`fk_categorie`),
  KEY `idx_categorie_product_fk_product` (`fk_product`),
  CONSTRAINT `fk_categorie_product_categorie_rowid` FOREIGN KEY (`fk_categorie`) REFERENCES `llx_categorie` (`rowid`),
  CONSTRAINT `fk_categorie_product_product_rowid` FOREIGN KEY (`fk_product`) REFERENCES `llx_product` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_categorie_product`
--

LOCK TABLES `llx_categorie_product` WRITE;
/*!40000 ALTER TABLE `llx_categorie_product` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_categorie_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_categorie_societe`
--

DROP TABLE IF EXISTS `llx_categorie_societe`;
CREATE TABLE `llx_categorie_societe` (
  `fk_categorie` int(11) NOT NULL,
  `fk_societe` int(11) NOT NULL,
  PRIMARY KEY  (`fk_categorie`,`fk_societe`),
  KEY `idx_categorie_societe_fk_categorie` (`fk_categorie`),
  KEY `idx_categorie_societe_fk_societe` (`fk_societe`),
  CONSTRAINT `fk_categorie_societe_categorie_rowid` FOREIGN KEY (`fk_categorie`) REFERENCES `llx_categorie` (`rowid`),
  CONSTRAINT `fk_categorie_societe_fk_soc` FOREIGN KEY (`fk_societe`) REFERENCES `llx_societe` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_categorie_societe`
--

LOCK TABLES `llx_categorie_societe` WRITE;
/*!40000 ALTER TABLE `llx_categorie_societe` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_categorie_societe` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_chargesociales`
--

DROP TABLE IF EXISTS `llx_chargesociales`;
CREATE TABLE `llx_chargesociales` (
  `rowid` int(11) NOT NULL auto_increment,
  `date_ech` datetime NOT NULL,
  `libelle` varchar(80) NOT NULL,
  `entity` int(11) NOT NULL default '1',
  `fk_type` int(11) NOT NULL,
  `amount` double NOT NULL default '0',
  `paye` smallint(6) NOT NULL default '0',
  `periode` date default NULL,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_chargesociales`
--

LOCK TABLES `llx_chargesociales` WRITE;
/*!40000 ALTER TABLE `llx_chargesociales` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_chargesociales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_commande`
--

DROP TABLE IF EXISTS `llx_commande`;
CREATE TABLE `llx_commande` (
  `rowid` int(11) NOT NULL auto_increment,
  `ref` varchar(30) NOT NULL,
  `entity` int(11) NOT NULL default '1',
  `ref_ext` varchar(50) default NULL,
  `ref_int` varchar(50) default NULL,
  `ref_client` varchar(50) default NULL,
  `fk_soc` int(11) NOT NULL,
  `fk_projet` int(11) default '0',
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `date_creation` datetime default NULL,
  `date_valid` datetime default NULL,
  `date_cloture` datetime default NULL,
  `date_commande` date default NULL,
  `fk_user_author` int(11) default NULL,
  `fk_user_valid` int(11) default NULL,
  `fk_user_cloture` int(11) default NULL,
  `source` smallint(6) default NULL,
  `fk_statut` smallint(6) default '0',
  `amount_ht` double default '0',
  `remise_percent` double default '0',
  `remise_absolue` double default '0',
  `remise` double default '0',
  `tva` double(24,8) default '0.00000000',
  `localtax1` double(24,8) default '0.00000000',
  `localtax2` double(24,8) default '0.00000000',
  `total_ht` double(24,8) default '0.00000000',
  `total_ttc` double(24,8) default '0.00000000',
  `note` text,
  `note_public` text,
  `model_pdf` varchar(255) default NULL,
  `facture` tinyint(4) default '0',
  `fk_cond_reglement` int(11) default NULL,
  `fk_mode_reglement` int(11) default NULL,
  `date_livraison` date default NULL,
  `fk_availability` int(11) default NULL,
  `fk_demand_reason` int(11) default NULL,
  `fk_adresse_livraison` int(11) default NULL,
  `import_key` varchar(14) default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_commande_ref` (`ref`,`entity`),
  KEY `idx_commande_fk_soc` (`fk_soc`),
  CONSTRAINT `fk_commande_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_commande`
--

LOCK TABLES `llx_commande` WRITE;
/*!40000 ALTER TABLE `llx_commande` DISABLE KEYS */;
INSERT INTO `llx_commande` VALUES (1,'CO1304-0001',1,NULL,NULL,'1238564 ',2,2,'2013-10-19 15:41:03','2013-10-19 17:32:44','2013-10-19 17:41:03',NULL,'2013-04-17',1,1,NULL,NULL,1,0,0,NULL,0,58.80000000,0.00000000,0.00000000,300.00000000,358.80000000,'','','einstein',0,3,2,'2013-09-06',2,1,NULL,NULL);
/*!40000 ALTER TABLE `llx_commande` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_commande_fournisseur`
--

DROP TABLE IF EXISTS `llx_commande_fournisseur`;
CREATE TABLE `llx_commande_fournisseur` (
  `rowid` int(11) NOT NULL auto_increment,
  `ref` varchar(30) NOT NULL,
  `entity` int(11) NOT NULL default '1',
  `ref_ext` varchar(30) default NULL,
  `ref_supplier` varchar(30) default NULL,
  `fk_soc` int(11) NOT NULL,
  `fk_projet` int(11) default '0',
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `date_creation` datetime default NULL,
  `date_valid` datetime default NULL,
  `date_cloture` datetime default NULL,
  `date_commande` date default NULL,
  `fk_user_author` int(11) default NULL,
  `fk_user_valid` int(11) default NULL,
  `fk_user_cloture` int(11) default NULL,
  `source` smallint(6) NOT NULL,
  `fk_statut` smallint(6) default '0',
  `amount_ht` double default '0',
  `remise_percent` double default '0',
  `remise` double default '0',
  `tva` double(24,8) default '0.00000000',
  `localtax1` double(24,8) default '0.00000000',
  `localtax2` double(24,8) default '0.00000000',
  `total_ht` double(24,8) default '0.00000000',
  `total_ttc` double(24,8) default '0.00000000',
  `note` text,
  `note_public` text,
  `model_pdf` varchar(255) default NULL,
  `fk_cond_reglement` int(11) default NULL,
  `fk_mode_reglement` int(11) default NULL,
  `fk_methode_commande` int(11) default '0',
  `import_key` varchar(14) default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_commande_fournisseur_ref` (`ref`,`fk_soc`,`entity`),
  KEY `idx_commande_fournisseur_fk_soc` (`fk_soc`),
  CONSTRAINT `fk_commande_fournisseur_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_commande_fournisseur`
--

LOCK TABLES `llx_commande_fournisseur` WRITE;
/*!40000 ALTER TABLE `llx_commande_fournisseur` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_commande_fournisseur` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_commande_fournisseur_dispatch`
--

DROP TABLE IF EXISTS `llx_commande_fournisseur_dispatch`;
CREATE TABLE `llx_commande_fournisseur_dispatch` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_commande` int(11) default NULL,
  `fk_product` int(11) default NULL,
  `qty` float default NULL,
  `fk_entrepot` int(11) default NULL,
  `fk_user` int(11) default NULL,
  `datec` datetime default NULL,
  PRIMARY KEY  (`rowid`),
  KEY `idx_commande_fournisseur_dispatch_fk_commande` (`fk_commande`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_commande_fournisseur_dispatch`
--

LOCK TABLES `llx_commande_fournisseur_dispatch` WRITE;
/*!40000 ALTER TABLE `llx_commande_fournisseur_dispatch` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_commande_fournisseur_dispatch` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_commande_fournisseur_log`
--

DROP TABLE IF EXISTS `llx_commande_fournisseur_log`;
CREATE TABLE `llx_commande_fournisseur_log` (
  `rowid` int(11) NOT NULL auto_increment,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `datelog` datetime NOT NULL,
  `fk_commande` int(11) NOT NULL,
  `fk_statut` smallint(6) NOT NULL,
  `fk_user` int(11) NOT NULL,
  `comment` varchar(255) default NULL,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_commande_fournisseur_log`
--

LOCK TABLES `llx_commande_fournisseur_log` WRITE;
/*!40000 ALTER TABLE `llx_commande_fournisseur_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_commande_fournisseur_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_commande_fournisseurdet`
--

DROP TABLE IF EXISTS `llx_commande_fournisseurdet`;
CREATE TABLE `llx_commande_fournisseurdet` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_commande` int(11) NOT NULL,
  `fk_product` int(11) default NULL,
  `ref` varchar(50) default NULL,
  `label` varchar(255) default NULL,
  `description` text,
  `tva_tx` double(6,3) default '0.000',
  `localtax1_tx` double(6,3) default '0.000',
  `localtax2_tx` double(6,3) default '0.000',
  `qty` double default NULL,
  `remise_percent` double default '0',
  `remise` double default '0',
  `subprice` double(24,8) default '0.00000000',
  `total_ht` double(24,8) default '0.00000000',
  `total_tva` double(24,8) default '0.00000000',
  `total_localtax1` double(24,8) default '0.00000000',
  `total_localtax2` double(24,8) default '0.00000000',
  `total_ttc` double(24,8) default '0.00000000',
  `product_type` int(11) default '0',
  `date_start` datetime default NULL,
  `date_end` datetime default NULL,
  `info_bits` int(11) default '0',
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_commande_fournisseurdet`
--

LOCK TABLES `llx_commande_fournisseurdet` WRITE;
/*!40000 ALTER TABLE `llx_commande_fournisseurdet` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_commande_fournisseurdet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_commandedet`
--

DROP TABLE IF EXISTS `llx_commandedet`;
CREATE TABLE `llx_commandedet` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_commande` int(11) NOT NULL,
  `fk_parent_line` int(11) default NULL,
  `fk_product` int(11) default NULL,
  `description` text,
  `tva_tx` double(6,3) default NULL,
  `localtax1_tx` double(6,3) default NULL,
  `localtax2_tx` double(6,3) default NULL,
  `qty` double default NULL,
  `remise_percent` double default '0',
  `remise` double default '0',
  `fk_remise_except` int(11) default NULL,
  `price` double default NULL,
  `subprice` double(24,8) default '0.00000000',
  `total_ht` double(24,8) default '0.00000000',
  `total_tva` double(24,8) default '0.00000000',
  `total_localtax1` double(24,8) default '0.00000000',
  `total_localtax2` double(24,8) default '0.00000000',
  `total_ttc` double(24,8) default '0.00000000',
  `product_type` int(11) default '0',
  `date_start` datetime default NULL,
  `date_end` datetime default NULL,
  `info_bits` int(11) default '0',
  `marge_tx` double(6,3) default '0.000',
  `marque_tx` double(6,3) default '0.000',
  `special_code` int(10) unsigned default '0',
  `rang` int(11) default '0',
  `import_key` varchar(14) default NULL,
  PRIMARY KEY  (`rowid`),
  KEY `idx_commandedet_fk_commande` (`fk_commande`),
  KEY `idx_commandedet_fk_product` (`fk_product`),
  CONSTRAINT `fk_commandedet_fk_commande` FOREIGN KEY (`fk_commande`) REFERENCES `llx_commande` (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_commandedet`
--

LOCK TABLES `llx_commandedet` WRITE;
/*!40000 ALTER TABLE `llx_commandedet` DISABLE KEYS */;
INSERT INTO `llx_commandedet` VALUES (1,1,NULL,22,'jour de prestation Audit &nbsp;ISO 9001 par &eacute;tape Niv2 AFNOR',19.600,0.000,0.000,0.75,0,0,NULL,400,400.00000000,300.00000000,58.80000000,0.00000000,0.00000000,358.80000000,1,NULL,NULL,0,NULL,NULL,0,1,NULL);
/*!40000 ALTER TABLE `llx_commandedet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_compta`
--

DROP TABLE IF EXISTS `llx_compta`;
CREATE TABLE `llx_compta` (
  `rowid` int(11) NOT NULL auto_increment,
  `datec` datetime default NULL,
  `datev` date default NULL,
  `amount` double NOT NULL default '0',
  `label` varchar(255) default NULL,
  `fk_compta_account` int(11) default NULL,
  `fk_user_author` int(11) default NULL,
  `fk_user_valid` int(11) default NULL,
  `valid` tinyint(4) default '0',
  `note` text,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_compta`
--

LOCK TABLES `llx_compta` WRITE;
/*!40000 ALTER TABLE `llx_compta` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_compta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_compta_account`
--

DROP TABLE IF EXISTS `llx_compta_account`;
CREATE TABLE `llx_compta_account` (
  `rowid` int(11) NOT NULL auto_increment,
  `datec` datetime default NULL,
  `number` varchar(12) default NULL,
  `label` varchar(255) default NULL,
  `fk_user_author` int(11) default NULL,
  `note` text,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_compta_account`
--

LOCK TABLES `llx_compta_account` WRITE;
/*!40000 ALTER TABLE `llx_compta_account` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_compta_account` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_compta_compte_generaux`
--

DROP TABLE IF EXISTS `llx_compta_compte_generaux`;
CREATE TABLE `llx_compta_compte_generaux` (
  `rowid` int(11) NOT NULL auto_increment,
  `date_creation` datetime default NULL,
  `numero` varchar(50) default NULL,
  `intitule` varchar(255) default NULL,
  `fk_user_author` int(11) default NULL,
  `note` text,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `numero` (`numero`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_compta_compte_generaux`
--

LOCK TABLES `llx_compta_compte_generaux` WRITE;
/*!40000 ALTER TABLE `llx_compta_compte_generaux` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_compta_compte_generaux` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_const`
--

DROP TABLE IF EXISTS `llx_const`;
CREATE TABLE `llx_const` (
  `rowid` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL,
  `entity` int(11) NOT NULL default '1',
  `value` text NOT NULL,
  `type` varchar(6) default NULL,
  `visible` tinyint(4) NOT NULL default '1',
  `note` text,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_const` (`name`,`entity`)
) ENGINE=InnoDB AUTO_INCREMENT=368 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_const`
--

LOCK TABLES `llx_const` WRITE;
/*!40000 ALTER TABLE `llx_const` DISABLE KEYS */;
INSERT INTO `llx_const` VALUES (2,'MAIN_FEATURES_LEVEL',0,'0','chaine',1,'Level of features to show (0=stable only, 1=stable+experimental, 2=stable+experimental+development','2013-08-28 17:08:23'),(3,'SYSLOG_FILE',0,'DOL_DATA_ROOT/dolibarr.log','chaine',0,'Directory where to write log file','2013-08-28 17:08:23'),(4,'SYSLOG_LEVEL',0,'7','chaine',0,'Level of debug info to show','2013-08-28 17:08:23'),(5,'MAIN_MAIL_SMTP_SERVER',0,'','chaine',0,'Host or ip address for SMTP server','2013-08-28 17:08:23'),(6,'MAIN_MAIL_SMTP_PORT',0,'','chaine',0,'Port for SMTP server','2013-08-28 17:08:23'),(7,'MAIN_UPLOAD_DOC',0,'2048','chaine',0,'Max size for file upload (0 means no upload allowed)','2013-08-28 17:08:23'),(9,'MAIN_MAIL_EMAIL_FROM',1,'dolibarr-robot@domain.com','chaine',0,'EMail emetteur pour les emails automatiques Dolibarr','2013-08-28 17:08:23'),(10,'MAIN_SIZE_LISTE_LIMIT',0,'25','chaine',0,'Longueur maximum des listes','2013-08-28 17:08:23'),(11,'MAIN_SHOW_WORKBOARD',0,'1','yesno',0,'Affichage tableau de bord de travail Dolibarr','2013-08-28 17:08:23'),(12,'MAIN_MENU_STANDARD',1,'eldy_backoffice.php','chaine',0,'Module de gestion de la barre de menu pour utilisateurs internes','2013-08-28 17:08:23'),(13,'MAIN_MENUFRONT_STANDARD',1,'eldy_frontoffice.php','chaine',0,'Module de gestion de la barre de menu pour utilisateurs externes','2013-08-28 17:08:23'),(14,'MAIN_MENU_SMARTPHONE',1,'eldy_backoffice.php','chaine',0,'Module de gestion de la barre de menu smartphone pour utilisateurs internes','2013-08-28 17:08:23'),(15,'MAIN_MENUFRONT_SMARTPHONE',1,'eldy_frontoffice.php','chaine',0,'Module de gestion de la barre de menu smartphone pour utilisateurs externes','2013-08-28 17:08:23'),(24,'MAIN_DELAY_NOT_ACTIVATED_SERVICES',1,'0','chaine',0,'Tolérance de retard avant alerte (en jours) sur services à activer','2013-08-28 17:08:23'),(25,'MAIN_DELAY_RUNNING_SERVICES',1,'0','chaine',0,'Tolérance de retard avant alerte (en jours) sur services expirés','2013-08-28 17:08:23'),(26,'MAIN_DELAY_MEMBERS',1,'31','chaine',0,'Tolérance de retard avant alerte (en jours) sur cotisations adhérent en retard','2013-08-28 17:08:23'),(28,'SOCIETE_NOLIST_COURRIER',0,'1','yesno',0,'Liste les fichiers du repertoire courrier','2013-08-28 17:08:23'),(29,'SOCIETE_CODECLIENT_ADDON',1,'mod_codeclient_leopard','yesno',0,'Module to control third parties codes','2013-08-28 17:08:23'),(30,'SOCIETE_CODECOMPTA_ADDON',1,'mod_codecompta_panicum','yesno',0,'Module to control third parties codes','2013-08-28 17:08:23'),(31,'MAILING_EMAIL_FROM',1,'dolibarr@domain.com','chaine',0,'EMail emmetteur pour les envois d emailings','2013-08-28 17:08:23'),(32,'MAIN_MODULE_USER',0,'1',NULL,0,NULL,'2013-08-28 17:09:36'),(33,'MAIN_VERSION_LAST_INSTALL',0,'3.1.1','chaine',0,'Dolibarr version when install','2013-08-28 17:09:37'),(34,'MAIN_REMOVE_INSTALL_WARNING',0,'1','chaine',1,'Disable install warnings','2013-08-28 17:09:37'),(69,'COMPANY_ADDON_PDF_ODT_PATH',1,'DOL_DATA_ROOT/doctemplates/thirdparties','chaine',0,NULL,'2013-08-28 18:01:36'),(70,'MAIN_MODULE_PROPALE',1,'1',NULL,0,NULL,'2013-08-28 18:01:54'),(71,'PROPALE_ADDON_PDF',1,'azur','chaine',0,'Nom du gestionnaire de generation des propales en PDF','2013-08-28 18:01:54'),(72,'PROPALE_ADDON',1,'mod_propale_marbre','chaine',0,'Nom du gestionnaire de numerotation des propales','2013-08-28 18:01:54'),(73,'PROPALE_VALIDITY_DURATION',1,'15','chaine',0,'Duration of validity of business proposals','2013-08-28 18:01:54'),(76,'COMMANDE_ADDON_PDF',1,'einstein','chaine',0,'Nom du gestionnaire de generation des commandes en PDF','2013-08-28 18:01:55'),(77,'COMMANDE_ADDON',1,'mod_commande_marbre','chaine',0,'Nom du gestionnaire de numerotation des commandes','2013-08-28 18:01:55'),(79,'MAIN_MODULE_CONTRAT',1,'1',NULL,0,NULL,'2013-08-28 18:01:56'),(80,'CONTRACT_ADDON',1,'mod_contract_serpis','chaine',0,'Nom du gestionnaire de numerotation des contrats','2013-08-28 18:01:56'),(81,'MAIN_MODULE_SERVICE',1,'1',NULL,0,NULL,'2013-08-28 18:01:56'),(82,'MAIN_MODULE_FICHEINTER',1,'1',NULL,0,NULL,'2013-08-28 18:01:57'),(83,'FICHEINTER_ADDON_PDF',1,'soleil','chaine',0,NULL,'2013-08-28 18:01:57'),(84,'FICHEINTER_ADDON',1,'pacific','chaine',0,NULL,'2013-08-28 18:01:57'),(86,'MAIN_MODULE_EXPEDITION',1,'1',NULL,0,NULL,'2013-08-28 18:01:58'),(87,'EXPEDITION_ADDON_PDF',1,'rouget','chaine',0,'Nom du gestionnaire de generation des bons expeditions en PDF','2013-08-28 18:01:58'),(88,'EXPEDITION_ADDON',1,'elevement','chaine',0,'Nom du gestionnaire du type d\'expedition','2013-08-28 18:01:58'),(89,'LIVRAISON_ADDON_PDF',1,'typhon','chaine',0,'Nom du gestionnaire de generation des bons de reception en PDF','2013-08-28 18:01:58'),(90,'LIVRAISON_ADDON',1,'mod_livraison_jade','chaine',0,'Nom du gestionnaire de numerotation des bons de reception','2013-08-28 18:01:58'),(91,'EXPEDITION_ADDON_NUMBER',1,'mod_expedition_safor','chaine',0,'Nom du gestionnaire de numerotation des expeditions','2013-08-28 18:01:58'),(92,'MAIN_MODULE_COMMANDE',1,'1',NULL,0,NULL,'2013-08-28 18:01:58'),(94,'MAIN_MODULE_ECM',1,'1',NULL,0,NULL,'2013-08-28 18:02:32'),(95,'MAIN_MODULE_COMPTABILITE',1,'1',NULL,0,NULL,'2013-08-28 18:02:34'),(104,'MAIN_MODULE_TAX',1,'1',NULL,0,NULL,'2013-08-28 18:02:37'),(105,'MAIN_MODULE_PRELEVEMENT',1,'1',NULL,0,NULL,'2013-08-28 18:02:38'),(106,'MAIN_MODULE_FACTURE',1,'1',NULL,0,NULL,'2013-08-28 18:02:38'),(109,'MAIN_MODULE_DON',1,'1',NULL,0,NULL,'2013-08-28 18:02:39'),(110,'DON_ADDON_MODEL',1,'html_cerfafr','chaine',0,'Nom du gestionnaire de generation de recu de dons','2013-08-28 18:02:39'),(111,'MAIN_MODULE_DEPLACEMENT',1,'1',NULL,0,NULL,'2013-08-28 18:02:40'),(112,'MAIN_MODULE_BANQUE',1,'1',NULL,0,NULL,'2013-08-28 18:02:40'),(113,'MAIN_MODULE_FOURNISSEUR',1,'1',NULL,0,NULL,'2013-08-28 18:03:00'),(114,'COMMANDE_SUPPLIER_ADDON_PDF',1,'muscadet','chaine',0,NULL,'2013-08-28 18:03:00'),(115,'COMMANDE_SUPPLIER_ADDON',1,'mod_commande_fournisseur_muguet','chaine',0,NULL,'2013-08-28 18:03:00'),(116,'INVOICE_SUPPLIER_ADDON_PDF',1,'canelle','chaine',0,NULL,'2013-08-28 18:03:00'),(117,'MAIN_MODULE_SOCIETE',1,'1',NULL,0,NULL,'2013-08-28 18:03:00'),(119,'MAIN_AGENDA_ACTIONAUTO_COMPANY_CREATE',1,'1','chaine',0,NULL,'2013-08-28 18:03:36'),(120,'MAIN_AGENDA_ACTIONAUTO_CONTRACT_VALIDATE',1,'1','chaine',0,NULL,'2013-08-28 18:03:36'),(121,'MAIN_AGENDA_ACTIONAUTO_PROPAL_VALIDATE',1,'1','chaine',0,NULL,'2013-08-28 18:03:36'),(122,'MAIN_AGENDA_ACTIONAUTO_PROPAL_SENTBYMAIL',1,'1','chaine',0,NULL,'2013-08-28 18:03:36'),(123,'MAIN_AGENDA_ACTIONAUTO_ORDER_VALIDATE',1,'1','chaine',0,NULL,'2013-08-28 18:03:36'),(124,'MAIN_AGENDA_ACTIONAUTO_ORDER_SENTBYMAIL',1,'1','chaine',0,NULL,'2013-08-28 18:03:36'),(125,'MAIN_AGENDA_ACTIONAUTO_BILL_VALIDATE',1,'1','chaine',0,NULL,'2013-08-28 18:03:36'),(126,'MAIN_AGENDA_ACTIONAUTO_BILL_PAYED',1,'1','chaine',0,NULL,'2013-08-28 18:03:36'),(127,'MAIN_AGENDA_ACTIONAUTO_BILL_CANCEL',1,'1','chaine',0,NULL,'2013-08-28 18:03:36'),(128,'MAIN_AGENDA_ACTIONAUTO_BILL_SENTBYMAIL',1,'1','chaine',0,NULL,'2013-08-28 18:03:36'),(129,'MAIN_AGENDA_ACTIONAUTO_ORDER_SUPPLIER_VALIDATE',1,'1','chaine',0,NULL,'2013-08-28 18:03:36'),(130,'MAIN_AGENDA_ACTIONAUTO_BILL_SUPPLIER_VALIDATE',1,'1','chaine',0,NULL,'2013-08-28 18:03:36'),(131,'MAIN_AGENDA_ACTIONAUTO_SHIPPING_VALIDATE',1,'1','chaine',0,NULL,'2013-08-28 18:03:36'),(132,'MAIN_AGENDA_ACTIONAUTO_SHIPPING_SENTBYMAIL',1,'1','chaine',0,NULL,'2013-08-28 18:03:36'),(133,'MAIN_MODULE_PROJET',1,'1',NULL,0,NULL,'2013-08-28 18:03:38'),(134,'PROJECT_ADDON_PDF',1,'baleine','chaine',0,'Nom du gestionnaire de generation des projets en PDF','2013-08-28 18:03:38'),(135,'PROJECT_ADDON',1,'mod_project_simple','chaine',0,'Nom du gestionnaire de numerotation des projets','2013-08-28 18:03:38'),(136,'MAIN_MODULE_MAILING',1,'1',NULL,0,NULL,'2013-08-28 18:04:20'),(137,'MAIN_MODULE_EXPORT',1,'1',NULL,0,NULL,'2013-08-28 18:04:22'),(138,'MAIN_MODULE_IMPORT',1,'1',NULL,0,NULL,'2013-08-28 18:04:23'),(139,'MAIN_MODULE_FCKEDITOR',1,'1',NULL,0,NULL,'2013-08-28 18:05:14'),(140,'FCKEDITOR_ENABLE_USER',1,'1','yesno',0,'Activation fckeditor sur notes utilisateurs','2013-08-28 18:05:14'),(141,'FCKEDITOR_ENABLE_SOCIETE',1,'1','yesno',0,'Activation fckeditor sur notes societe','2013-08-28 18:05:14'),(142,'FCKEDITOR_ENABLE_PRODUCTDESC',1,'1','yesno',0,'Activation fckeditor sur notes produits','2013-08-28 18:05:14'),(143,'FCKEDITOR_ENABLE_MEMBER',1,'1','yesno',0,'Activation fckeditor sur notes adherent','2013-08-28 18:05:14'),(144,'FCKEDITOR_ENABLE_MAILING',1,'1','yesno',0,'Activation fckeditor sur emailing','2013-08-28 18:05:14'),(145,'MAIN_MODULE_BOOKMARK',1,'1',NULL,0,NULL,'2013-08-28 18:05:16'),(146,'MAIN_MODULE_WORKFLOW',1,'1',NULL,0,NULL,'2013-08-28 18:05:26'),(147,'MAIN_MODULE_WORKFLOW_TRIGGERS',1,'1','chaine',0,NULL,'2013-08-28 18:05:26'),(148,'MAIN_MODULE_EXTERNALSITE',1,'1',NULL,0,NULL,'2013-08-28 18:13:31'),(149,'MAIN_MODULE_FTP',1,'1',NULL,0,NULL,'2013-08-28 18:13:40'),(150,'MAIN_MODULE_LDAP',1,'1',NULL,0,NULL,'2013-08-28 18:14:28'),(151,'LDAP_SERVER_TYPE',1,'openldap','chaine',0,NULL,'2013-08-28 18:14:28'),(152,'LDAP_SERVER_PROTOCOLVERSION',1,'3','chaine',0,NULL,'2013-08-28 18:14:28'),(153,'LDAP_SERVER_HOST',1,'localhost','chaine',0,NULL,'2013-08-28 18:14:28'),(154,'LDAP_USER_DN',1,'ou=users,dc=my-domain,dc=com','chaine',0,NULL,'2013-08-28 18:14:28'),(155,'LDAP_GROUP_DN',1,'ou=groups,dc=my-domain,dc=com','chaine',0,NULL,'2013-08-28 18:14:28'),(156,'LDAP_FILTER_CONNECTION',1,'&(objectClass=user)(objectCategory=person)','chaine',0,NULL,'2013-08-28 18:14:28'),(157,'LDAP_FIELD_LOGIN',1,'uid','chaine',0,NULL,'2013-08-28 18:14:28'),(158,'LDAP_FIELD_FULLNAME',1,'cn','chaine',0,NULL,'2013-08-28 18:14:28'),(159,'LDAP_FIELD_NAME',1,'sn','chaine',0,NULL,'2013-08-28 18:14:28'),(160,'LDAP_FIELD_FIRSTNAME',1,'givenname','chaine',0,NULL,'2013-08-28 18:14:28'),(161,'LDAP_FIELD_MAIL',1,'mail','chaine',0,NULL,'2013-08-28 18:14:28'),(162,'LDAP_FIELD_PHONE',1,'telephonenumber','chaine',0,NULL,'2013-08-28 18:14:28'),(163,'LDAP_FIELD_FAX',1,'facsimiletelephonenumber','chaine',0,NULL,'2013-08-28 18:14:28'),(164,'LDAP_FIELD_MOBILE',1,'mobile','chaine',0,NULL,'2013-08-28 18:14:28'),(165,'MAIN_LANG_DEFAULT',1,'fr_FR','chaine',0,'','2013-08-28 18:22:13'),(166,'MAIN_MULTILANGS',1,'1','chaine',0,'','2013-08-28 18:22:13'),(167,'MAIN_SIZE_LISTE_LIMIT',1,'25','chaine',0,'','2013-08-28 18:22:13'),(168,'MAIN_DISABLE_JAVASCRIPT',1,'0','chaine',0,'','2013-08-28 18:22:13'),(169,'MAIN_START_WEEK',1,'1','chaine',0,'','2013-08-28 18:22:13'),(170,'MAIN_SHOW_LOGO',1,'1','chaine',0,'','2013-08-28 18:22:13'),(171,'MAIN_FIRSTNAME_NAME_POSITION',1,'1','chaine',0,'','2013-08-28 18:22:13'),(172,'MAIN_THEME',1,'cameleo','chaine',0,'','2013-08-28 18:22:13'),(173,'MAIN_SEARCHFORM_CONTACT',1,'1','chaine',0,'','2013-08-28 18:22:13'),(174,'MAIN_SEARCHFORM_SOCIETE',1,'1','chaine',0,'','2013-08-28 18:22:13'),(175,'MAIN_SEARCHFORM_PRODUITSERVICE',1,'1','chaine',0,'','2013-08-28 18:22:13'),(176,'MAIN_SEARCHFORM_ADHERENT',1,'0','chaine',0,'','2013-08-28 18:22:13'),(177,'MAIN_HELPCENTER_DISABLELINK',0,'0','chaine',0,'','2013-08-28 18:22:13'),(178,'MAIN_HELP_DISABLELINK',0,'0','chaine',0,'','2013-08-28 18:22:13'),(179,'MAIN_PROFID1_IN_ADDRESS',1,'1','chaine',0,'','2013-08-28 18:22:13'),(180,'MAIN_PROFID2_IN_ADDRESS',1,'0','chaine',0,'','2013-08-28 18:22:13'),(181,'MAIN_PROFID3_IN_ADDRESS',1,'1','chaine',0,'','2013-08-28 18:22:13'),(182,'MAIN_PROFID4_IN_ADDRESS',1,'1','chaine',0,'','2013-08-28 18:22:13'),(183,'MAIN_BOXES_MAXLINES',1,'10','',0,'','2013-08-28 18:26:38'),(184,'MAIN_DELAY_ACTIONS_TODO',1,'7','chaine',0,'','2013-08-28 18:29:38'),(185,'MAIN_DELAY_ORDERS_TO_PROCESS',1,'2','chaine',0,'','2013-08-28 18:29:38'),(186,'MAIN_DELAY_SUPPLIER_ORDERS_TO_PROCESS',1,'7','chaine',0,'','2013-08-28 18:29:38'),(187,'MAIN_DELAY_PROPALS_TO_CLOSE',1,'31','chaine',0,'','2013-08-28 18:29:38'),(188,'MAIN_DELAY_PROPALS_TO_BILL',1,'5','chaine',0,'','2013-08-28 18:29:38'),(189,'MAIN_DELAY_CUSTOMER_BILLS_UNPAYED',1,'31','chaine',0,'','2013-08-28 18:29:38'),(190,'MAIN_DELAY_SUPPLIER_BILLS_TO_PAY',1,'2','chaine',0,'','2013-08-28 18:29:38'),(191,'MAIN_DELAY_TRANSACTIONS_TO_CONCILIATE',1,'62','chaine',0,'','2013-08-28 18:29:38'),(192,'MAIN_DISABLE_METEO',1,'0','chaine',0,'','2013-08-28 18:29:38'),(193,'MAIN_MAX_DECIMALS_UNIT',1,'2','chaine',0,'','2013-08-28 18:30:14'),(194,'MAIN_MAX_DECIMALS_TOT',1,'2','chaine',0,'','2013-08-28 18:30:14'),(195,'MAIN_MAX_DECIMALS_SHOWN',1,'3','chaine',0,'','2013-08-28 18:30:14'),(199,'FACTURE_ADDON',1,'mod_facture_mercure','chaine',0,'','2013-10-07 19:30:48'),(282,'FACTURE_MERCURE_MASK_INVOICE',1,'Facture{mm}{yy}{ccccc}{00}{yyyy}','chaine',0,'','2013-10-07 20:48:36'),(283,'FACTURE_MERCURE_MASK_CREDIT',1,'Avoir {yy}{mm}{00}','chaine',0,'','2013-10-07 20:48:36'),(284,'FACTURE_ADDON_PDF_ODT_PATH',1,'DOL_DATA_ROOT/doctemplates/invoices','chaine',0,'','2013-10-07 20:50:17'),(285,'FACTURE_ADDON_PDF',1,'generic_invoice_odt','chaine',0,'','2013-10-07 20:50:41'),(286,'FACTURE_CHQ_NUMBER',1,'0','chaine',0,'','2013-10-07 20:51:34'),(329,'MAIN_MODULE_AGENDA',1,'1',NULL,0,NULL,'2013-10-19 15:07:41'),(349,'MAIN_INFO_SOCIETE_PAYS',1,'1:FR:France','chaine',0,'','2013-10-19 15:47:18'),(350,'MAIN_INFO_SOCIETE_NOM',1,'CLEMENT QUALITE CONSULTING','chaine',0,'','2013-10-19 15:47:18'),(351,'MAIN_INFO_SOCIETE_ADRESSE',1,'6 GRANDE RUE','chaine',0,'','2013-10-19 15:47:18'),(352,'MAIN_INFO_SOCIETE_VILLE',1,'GERMIGNEY','chaine',0,'','2013-10-19 15:47:18'),(353,'MAIN_INFO_SOCIETE_CP',1,'70100','chaine',0,'','2013-10-19 15:47:18'),(354,'MAIN_INFO_SOCIETE_DEPARTEMENT',1,'72','chaine',0,'','2013-10-19 15:47:18'),(355,'MAIN_MONNAIE',1,'EUR','chaine',0,'','2013-10-19 15:47:18'),(356,'MAIN_INFO_SOCIETE_TEL',1,'+33670545083','chaine',0,'','2013-10-19 15:47:18'),(357,'MAIN_INFO_SOCIETE_MAIL',1,'contactcqc@free.fr','chaine',0,'','2013-10-19 15:47:18'),(358,'MAIN_INFO_CAPITAL',1,'3000€','chaine',0,'','2013-10-19 15:47:18'),(359,'MAIN_INFO_SOCIETE_FORME_JURIDIQUE',1,'58','chaine',0,'','2013-10-19 15:47:18'),(360,'MAIN_INFO_SIREN',1,'514 056 977','chaine',0,'','2013-10-19 15:47:18'),(361,'MAIN_INFO_SIRET',1,'514 056 977 00010','chaine',0,'','2013-10-19 15:47:18'),(362,'MAIN_INFO_APE',1,'7022Z','chaine',0,'','2013-10-19 15:47:18'),(363,'MAIN_INFO_RCS',1,'VESOUL','chaine',0,'','2013-10-19 15:47:18'),(364,'MAIN_INFO_TVAINTRA',1,'FR50514056977','chaine',0,'','2013-10-19 15:47:18'),(365,'SOCIETE_FISCAL_MONTH_START',1,'1','chaine',0,'','2013-10-19 15:47:18'),(366,'FACTURE_TVAOPTION',1,'reel','chaine',0,'','2013-10-19 15:47:18'),(367,'SYSTEMTOOLS_MYSQLDUMP',1,'c:\\dolibarr\\bin\\mysql\\mysql5.0.45\\/bin/mysqldump','chaine',0,'','2013-10-21 05:59:40');
/*!40000 ALTER TABLE `llx_const` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_contrat`
--

DROP TABLE IF EXISTS `llx_contrat`;
CREATE TABLE `llx_contrat` (
  `rowid` int(11) NOT NULL auto_increment,
  `ref` varchar(30) default NULL,
  `entity` int(11) NOT NULL default '1',
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `datec` datetime default NULL,
  `date_contrat` datetime default NULL,
  `statut` smallint(6) default '0',
  `mise_en_service` datetime default NULL,
  `fin_validite` datetime default NULL,
  `date_cloture` datetime default NULL,
  `fk_soc` int(11) NOT NULL,
  `fk_projet` int(11) default NULL,
  `fk_commercial_signature` int(11) NOT NULL,
  `fk_commercial_suivi` int(11) NOT NULL,
  `fk_user_author` int(11) NOT NULL default '0',
  `fk_user_mise_en_service` int(11) default NULL,
  `fk_user_cloture` int(11) default NULL,
  `note` text,
  `note_public` text,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_contrat_ref` (`ref`,`entity`),
  KEY `idx_contrat_fk_soc` (`fk_soc`),
  KEY `idx_contrat_fk_user_author` (`fk_user_author`),
  CONSTRAINT `fk_contrat_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`),
  CONSTRAINT `fk_contrat_user_author` FOREIGN KEY (`fk_user_author`) REFERENCES `llx_user` (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_contrat`
--

LOCK TABLES `llx_contrat` WRITE;
/*!40000 ALTER TABLE `llx_contrat` DISABLE KEYS */;
INSERT INTO `llx_contrat` VALUES (1,'CT1309-0001',1,'2013-09-19 19:33:44','2013-09-19 21:33:44','2013-09-19 00:00:00',0,NULL,NULL,NULL,3,NULL,1,1,1,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `llx_contrat` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_contratdet`
--

DROP TABLE IF EXISTS `llx_contratdet`;
CREATE TABLE `llx_contratdet` (
  `rowid` int(11) NOT NULL auto_increment,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `fk_contrat` int(11) NOT NULL,
  `fk_product` int(11) default NULL,
  `statut` smallint(6) default '0',
  `label` text,
  `description` text,
  `fk_remise_except` int(11) default NULL,
  `date_commande` datetime default NULL,
  `date_ouverture_prevue` datetime default NULL,
  `date_ouverture` datetime default NULL,
  `date_fin_validite` datetime default NULL,
  `date_cloture` datetime default NULL,
  `tva_tx` double(6,3) default '0.000',
  `localtax1_tx` double(6,3) default '0.000',
  `localtax2_tx` double(6,3) default '0.000',
  `qty` double NOT NULL,
  `remise_percent` double default '0',
  `subprice` double(24,8) default '0.00000000',
  `price_ht` double default NULL,
  `remise` double default '0',
  `total_ht` double(24,8) default '0.00000000',
  `total_tva` double(24,8) default '0.00000000',
  `total_localtax1` double(24,8) default '0.00000000',
  `total_localtax2` double(24,8) default '0.00000000',
  `total_ttc` double(24,8) default '0.00000000',
  `info_bits` int(11) default '0',
  `fk_user_author` int(11) NOT NULL default '0',
  `fk_user_ouverture` int(11) default NULL,
  `fk_user_cloture` int(11) default NULL,
  `commentaire` text,
  PRIMARY KEY  (`rowid`),
  KEY `idx_contratdet_fk_contrat` (`fk_contrat`),
  KEY `idx_contratdet_fk_product` (`fk_product`),
  KEY `idx_contratdet_date_ouverture_prevue` (`date_ouverture_prevue`),
  KEY `idx_contratdet_date_ouverture` (`date_ouverture`),
  KEY `idx_contratdet_date_fin_validite` (`date_fin_validite`),
  CONSTRAINT `fk_contratdet_fk_contrat` FOREIGN KEY (`fk_contrat`) REFERENCES `llx_contrat` (`rowid`),
  CONSTRAINT `fk_contratdet_fk_product` FOREIGN KEY (`fk_product`) REFERENCES `llx_product` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_contratdet`
--

LOCK TABLES `llx_contratdet` WRITE;
/*!40000 ALTER TABLE `llx_contratdet` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_contratdet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_contratdet_log`
--

DROP TABLE IF EXISTS `llx_contratdet_log`;
CREATE TABLE `llx_contratdet_log` (
  `rowid` int(11) NOT NULL auto_increment,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `fk_contratdet` int(11) NOT NULL,
  `date` datetime NOT NULL,
  `statut` smallint(6) NOT NULL,
  `fk_user_author` int(11) NOT NULL,
  `commentaire` text,
  PRIMARY KEY  (`rowid`),
  KEY `idx_contratdet_log_fk_contratdet` (`fk_contratdet`),
  KEY `idx_contratdet_log_date` (`date`),
  CONSTRAINT `fk_contratdet_log_fk_contratdet` FOREIGN KEY (`fk_contratdet`) REFERENCES `llx_contratdet` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_contratdet_log`
--

LOCK TABLES `llx_contratdet_log` WRITE;
/*!40000 ALTER TABLE `llx_contratdet_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_contratdet_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_cotisation`
--

DROP TABLE IF EXISTS `llx_cotisation`;
CREATE TABLE `llx_cotisation` (
  `rowid` int(11) NOT NULL auto_increment,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `datec` datetime default NULL,
  `fk_adherent` int(11) default NULL,
  `dateadh` datetime default NULL,
  `datef` date default NULL,
  `cotisation` double default NULL,
  `fk_bank` int(11) default NULL,
  `note` text,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_cotisation` (`fk_adherent`,`dateadh`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_cotisation`
--

LOCK TABLES `llx_cotisation` WRITE;
/*!40000 ALTER TABLE `llx_cotisation` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_cotisation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_deplacement`
--

DROP TABLE IF EXISTS `llx_deplacement`;
CREATE TABLE `llx_deplacement` (
  `rowid` int(11) NOT NULL auto_increment,
  `ref` varchar(30) default NULL,
  `entity` int(11) NOT NULL default '1',
  `datec` datetime NOT NULL,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `dated` datetime default NULL,
  `fk_user` int(11) NOT NULL,
  `fk_user_author` int(11) default NULL,
  `type` varchar(12) NOT NULL,
  `fk_statut` int(11) NOT NULL default '1',
  `km` double default NULL,
  `fk_soc` int(11) default NULL,
  `fk_projet` int(11) default '0',
  `note` text,
  `note_public` text,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_deplacement`
--

LOCK TABLES `llx_deplacement` WRITE;
/*!40000 ALTER TABLE `llx_deplacement` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_deplacement` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_document`
--

DROP TABLE IF EXISTS `llx_document`;
CREATE TABLE `llx_document` (
  `rowid` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `file_extension` varchar(5) NOT NULL,
  `date_generation` datetime default NULL,
  `fk_owner` int(11) default NULL,
  `fk_group` int(11) default NULL,
  `permissions` char(9) default 'rw-rw-rw',
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_document`
--

LOCK TABLES `llx_document` WRITE;
/*!40000 ALTER TABLE `llx_document` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_document` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_document_generator`
--

DROP TABLE IF EXISTS `llx_document_generator`;
CREATE TABLE `llx_document_generator` (
  `rowid` int(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `classfile` varchar(255) NOT NULL,
  `class` varchar(255) NOT NULL,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_document_generator`
--

LOCK TABLES `llx_document_generator` WRITE;
/*!40000 ALTER TABLE `llx_document_generator` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_document_generator` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_document_model`
--

DROP TABLE IF EXISTS `llx_document_model`;
CREATE TABLE `llx_document_model` (
  `rowid` int(11) NOT NULL auto_increment,
  `nom` varchar(50) default NULL,
  `entity` int(11) NOT NULL default '1',
  `type` varchar(20) NOT NULL,
  `libelle` varchar(255) default NULL,
  `description` text,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_document_model` (`nom`,`type`,`entity`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_document_model`
--

LOCK TABLES `llx_document_model` WRITE;
/*!40000 ALTER TABLE `llx_document_model` DISABLE KEYS */;
INSERT INTO `llx_document_model` VALUES (1,'azur',1,'propal',NULL,NULL),(3,'soleil',1,'ficheinter',NULL,NULL),(4,'rouget',1,'shipping',NULL,NULL),(5,'elevement',1,'delivery',NULL,NULL),(6,'einstein',1,'order',NULL,NULL),(10,'html_cerfafr',1,'donation',NULL,NULL),(11,'muscadet',1,'order_supplier',NULL,NULL),(12,'baleine',1,'project',NULL,NULL),(14,'generic_invoice_odt',1,'invoice','ODT templates','FACTURE_ADDON_PDF_ODT_PATH');
/*!40000 ALTER TABLE `llx_document_model` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_dolibarr_modules`
--

DROP TABLE IF EXISTS `llx_dolibarr_modules`;
CREATE TABLE `llx_dolibarr_modules` (
  `numero` int(11) NOT NULL default '0',
  `entity` int(11) NOT NULL default '1',
  `active` tinyint(4) NOT NULL default '0',
  `active_date` datetime NOT NULL,
  `active_version` varchar(25) NOT NULL,
  PRIMARY KEY  (`numero`,`entity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_dolibarr_modules`
--

LOCK TABLES `llx_dolibarr_modules` WRITE;
/*!40000 ALTER TABLE `llx_dolibarr_modules` DISABLE KEYS */;
INSERT INTO `llx_dolibarr_modules` VALUES (0,1,1,'2013-08-28 19:09:36','dolibarr'),(1,1,1,'2013-08-28 20:03:00','dolibarr'),(10,1,1,'2013-08-28 20:02:34','dolibarr'),(20,1,1,'2013-08-28 20:01:54','dolibarr'),(22,1,1,'2013-08-28 20:04:20','dolibarr'),(25,1,1,'2013-08-28 20:01:58','dolibarr'),(30,1,1,'2013-08-28 20:02:38','dolibarr'),(40,1,1,'2013-08-28 20:03:00','dolibarr'),(53,1,1,'2013-08-28 20:01:56','dolibarr'),(54,1,1,'2013-08-28 20:01:56','dolibarr'),(57,1,1,'2013-08-28 20:02:38','dolibarr'),(70,1,1,'2013-08-28 20:01:57','dolibarr'),(75,1,1,'2013-08-28 20:02:40','dolibarr'),(80,1,1,'2013-08-28 20:01:58','dolibarr'),(85,1,1,'2013-08-28 20:02:40','dolibarr'),(100,1,1,'2013-08-28 20:13:31','dolibarr'),(200,1,1,'2013-08-28 20:14:28','dolibarr'),(240,1,1,'2013-08-28 20:04:22','dolibarr'),(250,1,1,'2013-08-28 20:04:23','dolibarr'),(330,1,1,'2013-08-28 20:05:16','dolibarr'),(400,1,1,'2013-08-28 20:03:38','dolibarr'),(500,1,1,'2013-08-28 20:02:37','dolibarr'),(700,1,1,'2013-08-28 20:02:39','dolibarr'),(2000,1,1,'2013-08-28 20:05:14','dolibarr'),(2400,1,1,'2013-10-19 17:07:41','dolibarr'),(2500,1,1,'2013-08-28 20:02:32','dolibarr'),(2800,1,1,'2013-08-28 20:13:40','dolibarr'),(6000,1,1,'2013-08-28 20:05:26','dolibarr');
/*!40000 ALTER TABLE `llx_dolibarr_modules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_domain`
--

DROP TABLE IF EXISTS `llx_domain`;
CREATE TABLE `llx_domain` (
  `rowid` int(11) NOT NULL auto_increment,
  `datec` datetime default NULL,
  `label` varchar(255) default NULL,
  `note` text,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_domain`
--

LOCK TABLES `llx_domain` WRITE;
/*!40000 ALTER TABLE `llx_domain` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_domain` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_don`
--

DROP TABLE IF EXISTS `llx_don`;
CREATE TABLE `llx_don` (
  `rowid` int(11) NOT NULL auto_increment,
  `ref` varchar(30) default NULL,
  `entity` int(11) NOT NULL default '1',
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `fk_statut` smallint(6) NOT NULL default '0',
  `datec` datetime default NULL,
  `datedon` datetime default NULL,
  `amount` double default '0',
  `fk_paiement` int(11) default NULL,
  `prenom` varchar(50) default NULL,
  `nom` varchar(50) default NULL,
  `societe` varchar(50) default NULL,
  `adresse` text,
  `cp` varchar(30) default NULL,
  `ville` varchar(50) default NULL,
  `pays` varchar(50) default NULL,
  `email` varchar(255) default NULL,
  `phone` varchar(24) default NULL,
  `phone_mobile` varchar(24) default NULL,
  `public` smallint(6) NOT NULL default '1',
  `fk_don_projet` int(11) default NULL,
  `fk_user_author` int(11) NOT NULL,
  `fk_user_valid` int(11) default NULL,
  `note` text,
  `note_public` text,
  `model_pdf` varchar(255) default NULL,
  `import_key` varchar(14) default NULL,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_don`
--

LOCK TABLES `llx_don` WRITE;
/*!40000 ALTER TABLE `llx_don` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_don` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_ecm_directories`
--

DROP TABLE IF EXISTS `llx_ecm_directories`;
CREATE TABLE `llx_ecm_directories` (
  `rowid` int(11) NOT NULL auto_increment,
  `label` varchar(32) NOT NULL,
  `entity` int(11) NOT NULL default '1',
  `fk_parent` int(11) default NULL,
  `description` varchar(255) NOT NULL,
  `cachenbofdoc` int(11) NOT NULL default '0',
  `date_c` datetime default NULL,
  `date_m` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `fk_user_c` int(11) default NULL,
  `fk_user_m` int(11) default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `idx_ecm_directories` (`label`,`fk_parent`,`entity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_ecm_directories`
--

LOCK TABLES `llx_ecm_directories` WRITE;
/*!40000 ALTER TABLE `llx_ecm_directories` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_ecm_directories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_ecm_documents`
--

DROP TABLE IF EXISTS `llx_ecm_documents`;
CREATE TABLE `llx_ecm_documents` (
  `rowid` int(11) NOT NULL auto_increment,
  `ref` varchar(16) NOT NULL,
  `entity` int(11) NOT NULL default '1',
  `filename` varchar(255) NOT NULL,
  `filesize` int(11) NOT NULL,
  `filemime` varchar(32) NOT NULL,
  `fullpath_dol` varchar(255) NOT NULL,
  `fullpath_orig` varchar(255) NOT NULL,
  `description` text,
  `manualkeyword` text,
  `fk_create` int(11) NOT NULL,
  `fk_update` int(11) default NULL,
  `date_c` datetime NOT NULL,
  `date_u` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `fk_directory` int(11) default NULL,
  `fk_status` smallint(6) default '0',
  `private` smallint(6) default '0',
  `crc` varchar(32) NOT NULL default '',
  `cryptkey` varchar(50) NOT NULL default '',
  `cipher` varchar(50) NOT NULL default 'twofish',
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `idx_ecm_documents` (`fullpath_dol`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_ecm_documents`
--

LOCK TABLES `llx_ecm_documents` WRITE;
/*!40000 ALTER TABLE `llx_ecm_documents` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_ecm_documents` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_element_contact`
--

DROP TABLE IF EXISTS `llx_element_contact`;
CREATE TABLE `llx_element_contact` (
  `rowid` int(11) NOT NULL auto_increment,
  `datecreate` datetime default NULL,
  `statut` smallint(6) default '5',
  `element_id` int(11) NOT NULL,
  `fk_c_type_contact` int(11) NOT NULL,
  `fk_socpeople` int(11) NOT NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `idx_element_contact_idx1` (`element_id`,`fk_c_type_contact`,`fk_socpeople`),
  KEY `fk_element_contact_fk_c_type_contact` (`fk_c_type_contact`),
  KEY `idx_element_contact_fk_socpeople` (`fk_socpeople`),
  CONSTRAINT `fk_element_contact_fk_c_type_contact` FOREIGN KEY (`fk_c_type_contact`) REFERENCES `llx_c_type_contact` (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_element_contact`
--

LOCK TABLES `llx_element_contact` WRITE;
/*!40000 ALTER TABLE `llx_element_contact` DISABLE KEYS */;
INSERT INTO `llx_element_contact` VALUES (1,'2013-08-31 21:09:13',4,1,160,1),(2,'2013-08-31 21:41:32',4,1,170,1),(3,'2013-08-31 22:44:44',4,2,160,1),(4,'2013-08-31 22:52:52',4,2,170,2),(5,'2013-09-06 22:29:02',4,1,60,1),(6,'2013-09-19 21:33:44',4,1,10,1),(7,'2013-09-19 21:33:44',4,1,11,1),(8,'2013-10-19 17:32:45',4,1,101,3);
/*!40000 ALTER TABLE `llx_element_contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_element_element`
--

DROP TABLE IF EXISTS `llx_element_element`;
CREATE TABLE `llx_element_element` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_source` int(11) NOT NULL,
  `sourcetype` varchar(32) NOT NULL,
  `fk_target` int(11) NOT NULL,
  `targettype` varchar(32) NOT NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `idx_element_element_idx1` (`fk_source`,`sourcetype`,`fk_target`,`targettype`),
  KEY `idx_element_element_fk_target` (`fk_target`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_element_element`
--

LOCK TABLES `llx_element_element` WRITE;
/*!40000 ALTER TABLE `llx_element_element` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_element_element` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_element_lock`
--

DROP TABLE IF EXISTS `llx_element_lock`;
CREATE TABLE `llx_element_lock` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_element` int(11) NOT NULL,
  `elementtype` varchar(16) NOT NULL,
  `datel` datetime default NULL,
  `datem` datetime default NULL,
  `fk_user_modif` int(11) default NULL,
  `status` tinyint(4) default '0',
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_element_lock`
--

LOCK TABLES `llx_element_lock` WRITE;
/*!40000 ALTER TABLE `llx_element_lock` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_element_lock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_entrepot`
--

DROP TABLE IF EXISTS `llx_entrepot`;
CREATE TABLE `llx_entrepot` (
  `rowid` int(11) NOT NULL auto_increment,
  `datec` datetime default NULL,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `label` varchar(255) NOT NULL,
  `entity` int(11) NOT NULL default '1',
  `description` text,
  `lieu` varchar(64) default NULL,
  `address` varchar(255) default NULL,
  `cp` varchar(10) default NULL,
  `ville` varchar(50) default NULL,
  `fk_departement` int(11) default NULL,
  `fk_pays` int(11) default '0',
  `statut` tinyint(4) default '1',
  `valo_pmp` float(12,4) default NULL,
  `fk_user_author` int(11) default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_entrepot_label` (`label`,`entity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_entrepot`
--

LOCK TABLES `llx_entrepot` WRITE;
/*!40000 ALTER TABLE `llx_entrepot` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_entrepot` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_events`
--

DROP TABLE IF EXISTS `llx_events`;
CREATE TABLE `llx_events` (
  `rowid` int(11) NOT NULL auto_increment,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `type` varchar(32) NOT NULL,
  `entity` int(11) NOT NULL default '1',
  `dateevent` datetime default NULL,
  `fk_user` int(11) default NULL,
  `description` varchar(250) NOT NULL,
  `ip` varchar(32) NOT NULL,
  `user_agent` varchar(255) default NULL,
  `fk_object` int(11) default NULL,
  PRIMARY KEY  (`rowid`),
  KEY `idx_events_dateevent` (`dateevent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_events`
--

LOCK TABLES `llx_events` WRITE;
/*!40000 ALTER TABLE `llx_events` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_expedition`
--

DROP TABLE IF EXISTS `llx_expedition`;
CREATE TABLE `llx_expedition` (
  `rowid` int(11) NOT NULL auto_increment,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `ref` varchar(30) NOT NULL,
  `entity` int(11) NOT NULL default '1',
  `fk_soc` int(11) NOT NULL,
  `ref_ext` varchar(30) default NULL,
  `ref_int` varchar(30) default NULL,
  `ref_customer` varchar(30) default NULL,
  `date_creation` datetime default NULL,
  `fk_user_author` int(11) default NULL,
  `date_valid` datetime default NULL,
  `fk_user_valid` int(11) default NULL,
  `date_expedition` datetime default NULL,
  `date_delivery` datetime default NULL,
  `fk_address` int(11) default NULL,
  `fk_expedition_methode` int(11) default NULL,
  `tracking_number` varchar(50) default NULL,
  `fk_statut` smallint(6) default '0',
  `height` int(11) default NULL,
  `width` int(11) default NULL,
  `size_units` int(11) default NULL,
  `size` int(11) default NULL,
  `weight_units` int(11) default NULL,
  `weight` int(11) default NULL,
  `note` text,
  `model_pdf` varchar(255) default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `idx_expedition_uk_ref` (`ref`,`entity`),
  KEY `idx_expedition_fk_soc` (`fk_soc`),
  KEY `idx_expedition_fk_user_author` (`fk_user_author`),
  KEY `idx_expedition_fk_user_valid` (`fk_user_valid`),
  KEY `idx_expedition_fk_expedition_methode` (`fk_expedition_methode`),
  CONSTRAINT `fk_expedition_fk_expedition_methode` FOREIGN KEY (`fk_expedition_methode`) REFERENCES `llx_c_shipment_mode` (`rowid`),
  CONSTRAINT `fk_expedition_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`),
  CONSTRAINT `fk_expedition_fk_user_author` FOREIGN KEY (`fk_user_author`) REFERENCES `llx_user` (`rowid`),
  CONSTRAINT `fk_expedition_fk_user_valid` FOREIGN KEY (`fk_user_valid`) REFERENCES `llx_user` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_expedition`
--

LOCK TABLES `llx_expedition` WRITE;
/*!40000 ALTER TABLE `llx_expedition` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_expedition` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_expeditiondet`
--

DROP TABLE IF EXISTS `llx_expeditiondet`;
CREATE TABLE `llx_expeditiondet` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_expedition` int(11) NOT NULL,
  `fk_origin_line` int(11) default NULL,
  `fk_entrepot` int(11) default NULL,
  `qty` double default NULL,
  `rang` int(11) default '0',
  PRIMARY KEY  (`rowid`),
  KEY `idx_expeditiondet_fk_expedition` (`fk_expedition`),
  CONSTRAINT `fk_expeditiondet_fk_expedition` FOREIGN KEY (`fk_expedition`) REFERENCES `llx_expedition` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_expeditiondet`
--

LOCK TABLES `llx_expeditiondet` WRITE;
/*!40000 ALTER TABLE `llx_expeditiondet` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_expeditiondet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_export_compta`
--

DROP TABLE IF EXISTS `llx_export_compta`;
CREATE TABLE `llx_export_compta` (
  `rowid` int(11) NOT NULL auto_increment,
  `ref` varchar(12) NOT NULL,
  `date_export` datetime NOT NULL,
  `fk_user` int(11) NOT NULL,
  `note` text,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_export_compta`
--

LOCK TABLES `llx_export_compta` WRITE;
/*!40000 ALTER TABLE `llx_export_compta` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_export_compta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_export_model`
--

DROP TABLE IF EXISTS `llx_export_model`;
CREATE TABLE `llx_export_model` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_user` int(11) NOT NULL default '0',
  `label` varchar(50) NOT NULL,
  `type` varchar(20) NOT NULL,
  `field` text NOT NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_export_model` (`label`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_export_model`
--

LOCK TABLES `llx_export_model` WRITE;
/*!40000 ALTER TABLE `llx_export_model` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_export_model` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_extrafields`
--

DROP TABLE IF EXISTS `llx_extrafields`;
CREATE TABLE `llx_extrafields` (
  `rowid` int(11) NOT NULL auto_increment,
  `name` varchar(64) NOT NULL,
  `entity` int(11) NOT NULL default '1',
  `elementtype` varchar(64) NOT NULL default 'member',
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `label` varchar(255) NOT NULL,
  `type` varchar(8) default NULL,
  `size` int(11) default '0',
  `pos` int(11) default '0',
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_extrafields_name` (`name`,`entity`,`elementtype`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_extrafields`
--

LOCK TABLES `llx_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_facture`
--

DROP TABLE IF EXISTS `llx_facture`;
CREATE TABLE `llx_facture` (
  `rowid` int(11) NOT NULL auto_increment,
  `facnumber` varchar(30) NOT NULL,
  `entity` int(11) NOT NULL default '1',
  `ref_ext` varchar(50) default NULL,
  `ref_int` varchar(50) default NULL,
  `ref_client` varchar(50) default NULL,
  `type` smallint(6) NOT NULL default '0',
  `increment` varchar(10) default NULL,
  `fk_soc` int(11) NOT NULL,
  `datec` datetime default NULL,
  `datef` date default NULL,
  `date_valid` date default NULL,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `paye` smallint(6) NOT NULL default '0',
  `amount` double(24,8) NOT NULL default '0.00000000',
  `remise_percent` double default '0',
  `remise_absolue` double default '0',
  `remise` double default '0',
  `close_code` varchar(16) default NULL,
  `close_note` varchar(128) default NULL,
  `tva` double(24,8) default '0.00000000',
  `localtax1` double(24,8) default '0.00000000',
  `localtax2` double(24,8) default '0.00000000',
  `total` double(24,8) default '0.00000000',
  `total_ttc` double(24,8) default '0.00000000',
  `fk_statut` smallint(6) NOT NULL default '0',
  `fk_user_author` int(11) default NULL,
  `fk_user_valid` int(11) default NULL,
  `fk_facture_source` int(11) default NULL,
  `fk_projet` int(11) default NULL,
  `fk_cond_reglement` int(11) NOT NULL default '1',
  `fk_mode_reglement` int(11) default NULL,
  `date_lim_reglement` date default NULL,
  `note` text,
  `note_public` text,
  `model_pdf` varchar(255) default NULL,
  `import_key` varchar(14) default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `idx_facture_uk_facnumber` (`facnumber`,`entity`),
  KEY `idx_facture_fk_soc` (`fk_soc`),
  KEY `idx_facture_fk_user_author` (`fk_user_author`),
  KEY `idx_facture_fk_user_valid` (`fk_user_valid`),
  KEY `idx_facture_fk_facture_source` (`fk_facture_source`),
  KEY `idx_facture_fk_projet` (`fk_projet`),
  CONSTRAINT `fk_facture_fk_facture_source` FOREIGN KEY (`fk_facture_source`) REFERENCES `llx_facture` (`rowid`),
  CONSTRAINT `fk_facture_fk_projet` FOREIGN KEY (`fk_projet`) REFERENCES `llx_projet` (`rowid`),
  CONSTRAINT `fk_facture_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`),
  CONSTRAINT `fk_facture_fk_user_author` FOREIGN KEY (`fk_user_author`) REFERENCES `llx_user` (`rowid`),
  CONSTRAINT `fk_facture_fk_user_valid` FOREIGN KEY (`fk_user_valid`) REFERENCES `llx_user` (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_facture`
--

LOCK TABLES `llx_facture` WRITE;
/*!40000 ALTER TABLE `llx_facture` DISABLE KEYS */;
INSERT INTO `llx_facture` VALUES (1,'CounterMustHaveMoreThan3Digits',1,NULL,NULL,NULL,0,NULL,1,'2013-09-06 22:16:32','2013-09-06',NULL,'2013-10-19 14:35:25',1,0.00000000,NULL,NULL,0,NULL,NULL,539.00000000,0.00000000,0.00000000,2750.00000000,3289.00000000,2,1,1,NULL,1,0,2,'2013-09-06',NULL,NULL,'crabe',NULL);
/*!40000 ALTER TABLE `llx_facture` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_facture_fourn`
--

DROP TABLE IF EXISTS `llx_facture_fourn`;
CREATE TABLE `llx_facture_fourn` (
  `rowid` int(11) NOT NULL auto_increment,
  `facnumber` varchar(50) NOT NULL,
  `entity` int(11) NOT NULL default '1',
  `ref_ext` varchar(30) default NULL,
  `type` smallint(6) NOT NULL default '0',
  `fk_soc` int(11) NOT NULL,
  `datec` datetime default NULL,
  `datef` date default NULL,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `libelle` varchar(255) default NULL,
  `paye` smallint(6) NOT NULL default '0',
  `amount` double(24,8) NOT NULL default '0.00000000',
  `remise` double(24,8) default '0.00000000',
  `close_code` varchar(16) default NULL,
  `close_note` varchar(128) default NULL,
  `tva` double(24,8) default '0.00000000',
  `localtax1` double(24,8) default '0.00000000',
  `localtax2` double(24,8) default '0.00000000',
  `total` double(24,8) default '0.00000000',
  `total_ht` double(24,8) default '0.00000000',
  `total_tva` double(24,8) default '0.00000000',
  `total_ttc` double(24,8) default '0.00000000',
  `fk_statut` smallint(6) NOT NULL default '0',
  `fk_user_author` int(11) default NULL,
  `fk_user_valid` int(11) default NULL,
  `fk_facture_source` int(11) default NULL,
  `fk_projet` int(11) default NULL,
  `fk_cond_reglement` int(11) NOT NULL default '1',
  `date_lim_reglement` date default NULL,
  `note` text,
  `note_public` text,
  `model_pdf` varchar(255) default NULL,
  `import_key` varchar(14) default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_facture_fourn_ref` (`facnumber`,`fk_soc`,`entity`),
  KEY `idx_facture_fourn_date_lim_reglement` (`date_lim_reglement`),
  KEY `idx_facture_fourn_fk_soc` (`fk_soc`),
  KEY `idx_facture_fourn_fk_user_author` (`fk_user_author`),
  KEY `idx_facture_fourn_fk_user_valid` (`fk_user_valid`),
  KEY `idx_facture_fourn_fk_projet` (`fk_projet`),
  CONSTRAINT `fk_facture_fourn_fk_projet` FOREIGN KEY (`fk_projet`) REFERENCES `llx_projet` (`rowid`),
  CONSTRAINT `fk_facture_fourn_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`),
  CONSTRAINT `fk_facture_fourn_fk_user_author` FOREIGN KEY (`fk_user_author`) REFERENCES `llx_user` (`rowid`),
  CONSTRAINT `fk_facture_fourn_fk_user_valid` FOREIGN KEY (`fk_user_valid`) REFERENCES `llx_user` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_facture_fourn`
--

LOCK TABLES `llx_facture_fourn` WRITE;
/*!40000 ALTER TABLE `llx_facture_fourn` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_facture_fourn` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_facture_fourn_det`
--

DROP TABLE IF EXISTS `llx_facture_fourn_det`;
CREATE TABLE `llx_facture_fourn_det` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_facture_fourn` int(11) NOT NULL,
  `fk_product` int(11) default NULL,
  `ref` varchar(50) default NULL,
  `label` varchar(255) default NULL,
  `description` text,
  `pu_ht` double(24,8) default NULL,
  `pu_ttc` double(24,8) default NULL,
  `qty` double default NULL,
  `tva_tx` double(6,3) default NULL,
  `localtax1_tx` double(6,3) default '0.000',
  `localtax2_tx` double(6,3) default '0.000',
  `total_ht` double(24,8) default NULL,
  `tva` double(24,8) default NULL,
  `total_localtax1` double(24,8) default '0.00000000',
  `total_localtax2` double(24,8) default '0.00000000',
  `total_ttc` double(24,8) default NULL,
  `product_type` int(11) default '0',
  `date_start` datetime default NULL,
  `date_end` datetime default NULL,
  `import_key` varchar(14) default NULL,
  PRIMARY KEY  (`rowid`),
  KEY `idx_facture_fourn_det_fk_facture` (`fk_facture_fourn`),
  CONSTRAINT `fk_facture_fourn_det_fk_facture` FOREIGN KEY (`fk_facture_fourn`) REFERENCES `llx_facture_fourn` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_facture_fourn_det`
--

LOCK TABLES `llx_facture_fourn_det` WRITE;
/*!40000 ALTER TABLE `llx_facture_fourn_det` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_facture_fourn_det` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_facture_rec`
--

DROP TABLE IF EXISTS `llx_facture_rec`;
CREATE TABLE `llx_facture_rec` (
  `rowid` int(11) NOT NULL auto_increment,
  `titre` varchar(50) NOT NULL,
  `entity` int(11) NOT NULL default '1',
  `fk_soc` int(11) NOT NULL,
  `datec` datetime default NULL,
  `amount` double(24,8) NOT NULL default '0.00000000',
  `remise` double default '0',
  `remise_percent` double default '0',
  `remise_absolue` double default '0',
  `tva` double(24,8) default '0.00000000',
  `localtax1` double(24,8) default '0.00000000',
  `localtax2` double(24,8) default '0.00000000',
  `total` double(24,8) default '0.00000000',
  `total_ttc` double(24,8) default '0.00000000',
  `fk_user_author` int(11) default NULL,
  `fk_projet` int(11) default NULL,
  `fk_cond_reglement` int(11) default '0',
  `fk_mode_reglement` int(11) default '0',
  `date_lim_reglement` date default NULL,
  `note` text,
  `note_public` text,
  `frequency` int(11) default NULL,
  `unit_frequency` varchar(2) default 'd',
  `date_when` datetime default NULL,
  `date_last_gen` datetime default NULL,
  `nb_gen_done` int(11) default NULL,
  `nb_gen_max` int(11) default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `idx_facture_rec_uk_titre` (`titre`,`entity`),
  KEY `idx_facture_rec_fk_soc` (`fk_soc`),
  KEY `idx_facture_rec_fk_user_author` (`fk_user_author`),
  KEY `idx_facture_rec_fk_projet` (`fk_projet`),
  CONSTRAINT `fk_facture_rec_fk_projet` FOREIGN KEY (`fk_projet`) REFERENCES `llx_projet` (`rowid`),
  CONSTRAINT `fk_facture_rec_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`),
  CONSTRAINT `fk_facture_rec_fk_user_author` FOREIGN KEY (`fk_user_author`) REFERENCES `llx_user` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_facture_rec`
--

LOCK TABLES `llx_facture_rec` WRITE;
/*!40000 ALTER TABLE `llx_facture_rec` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_facture_rec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_facturedet`
--

DROP TABLE IF EXISTS `llx_facturedet`;
CREATE TABLE `llx_facturedet` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_facture` int(11) NOT NULL,
  `fk_parent_line` int(11) default NULL,
  `fk_product` int(11) default NULL,
  `description` text,
  `tva_tx` double(6,3) default NULL,
  `localtax1_tx` double(6,3) default '0.000',
  `localtax2_tx` double(6,3) default '0.000',
  `qty` double default NULL,
  `remise_percent` double default '0',
  `remise` double default '0',
  `fk_remise_except` int(11) default NULL,
  `subprice` double(24,8) default NULL,
  `price` double(24,8) default NULL,
  `total_ht` double(24,8) default NULL,
  `total_tva` double(24,8) default NULL,
  `total_localtax1` double(24,8) default '0.00000000',
  `total_localtax2` double(24,8) default '0.00000000',
  `total_ttc` double(24,8) default NULL,
  `product_type` int(11) default '0',
  `date_start` datetime default NULL,
  `date_end` datetime default NULL,
  `info_bits` int(11) default '0',
  `fk_code_ventilation` int(11) NOT NULL default '0',
  `fk_export_compta` int(11) NOT NULL default '0',
  `special_code` int(10) unsigned default '0',
  `rang` int(11) default '0',
  `import_key` varchar(14) default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_fk_remise_except` (`fk_remise_except`,`fk_facture`),
  KEY `idx_facturedet_fk_facture` (`fk_facture`),
  KEY `idx_facturedet_fk_product` (`fk_product`),
  CONSTRAINT `fk_facturedet_fk_facture` FOREIGN KEY (`fk_facture`) REFERENCES `llx_facture` (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_facturedet`
--

LOCK TABLES `llx_facturedet` WRITE;
/*!40000 ALTER TABLE `llx_facturedet` DISABLE KEYS */;
INSERT INTO `llx_facturedet` VALUES (1,1,NULL,25,'- Les principes généraux ( définition, SMQ, l\'approche processus, le cycle PDCA, les enjeux de la certification<br />\r\n- les exigences normatives ISO 9001 ( domaine d\'application, référence normative, définition et forme de la norme, SMQ, responsabilité de la direction, management des ressources, réalisation du produit, mesure analyse et amélioration)<br />\r\n- le plan d\'action interne (planification, mise en place, vérification, suivi des actions)',19.600,0.000,0.000,1,0,0,NULL,2750.00000000,2750.00000000,2750.00000000,539.00000000,0.00000000,0.00000000,3289.00000000,1,NULL,NULL,0,0,0,0,1,NULL);
/*!40000 ALTER TABLE `llx_facturedet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_facturedet_rec`
--

DROP TABLE IF EXISTS `llx_facturedet_rec`;
CREATE TABLE `llx_facturedet_rec` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_facture` int(11) NOT NULL,
  `fk_parent_line` int(11) default NULL,
  `fk_product` int(11) default NULL,
  `product_type` int(11) default '0',
  `description` text,
  `tva_tx` double(6,3) default '19.600',
  `localtax1_tx` double(6,3) default '0.000',
  `localtax2_tx` double(6,3) default '0.000',
  `qty` double default NULL,
  `remise_percent` double default '0',
  `remise` double default '0',
  `subprice` double(24,8) default NULL,
  `price` double(24,8) default NULL,
  `total_ht` double(24,8) default NULL,
  `total_tva` double(24,8) default NULL,
  `total_localtax1` double(24,8) default '0.00000000',
  `total_localtax2` double(24,8) default '0.00000000',
  `total_ttc` double(24,8) default NULL,
  `special_code` int(10) unsigned default '0',
  `rang` int(11) default '0',
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_facturedet_rec`
--

LOCK TABLES `llx_facturedet_rec` WRITE;
/*!40000 ALTER TABLE `llx_facturedet_rec` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_facturedet_rec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_fichinter`
--

DROP TABLE IF EXISTS `llx_fichinter`;
CREATE TABLE `llx_fichinter` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_soc` int(11) NOT NULL,
  `fk_projet` int(11) default '0',
  `fk_contrat` int(11) default '0',
  `ref` varchar(30) NOT NULL,
  `entity` int(11) NOT NULL default '1',
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `datec` datetime default NULL,
  `date_valid` datetime default NULL,
  `datei` date default NULL,
  `fk_user_author` int(11) default NULL,
  `fk_user_valid` int(11) default NULL,
  `fk_statut` smallint(6) default '0',
  `duree` double default NULL,
  `description` text,
  `note_private` text,
  `note_public` text,
  `model_pdf` varchar(255) default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_fichinter_ref` (`ref`,`entity`),
  KEY `idx_fichinter_fk_soc` (`fk_soc`),
  CONSTRAINT `fk_fichinter_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_fichinter`
--

LOCK TABLES `llx_fichinter` WRITE;
/*!40000 ALTER TABLE `llx_fichinter` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_fichinter` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_fichinterdet`
--

DROP TABLE IF EXISTS `llx_fichinterdet`;
CREATE TABLE `llx_fichinterdet` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_fichinter` int(11) default NULL,
  `date` datetime default NULL,
  `description` text,
  `duree` int(11) default NULL,
  `rang` int(11) default '0',
  PRIMARY KEY  (`rowid`),
  KEY `idx_fichinterdet_fk_fichinter` (`fk_fichinter`),
  CONSTRAINT `fk_fichinterdet_fk_fichinter` FOREIGN KEY (`fk_fichinter`) REFERENCES `llx_fichinter` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_fichinterdet`
--

LOCK TABLES `llx_fichinterdet` WRITE;
/*!40000 ALTER TABLE `llx_fichinterdet` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_fichinterdet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_import_model`
--

DROP TABLE IF EXISTS `llx_import_model`;
CREATE TABLE `llx_import_model` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_user` int(11) NOT NULL default '0',
  `label` varchar(50) NOT NULL,
  `type` varchar(20) NOT NULL,
  `field` text NOT NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_import_model` (`label`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_import_model`
--

LOCK TABLES `llx_import_model` WRITE;
/*!40000 ALTER TABLE `llx_import_model` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_import_model` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_livraison`
--

DROP TABLE IF EXISTS `llx_livraison`;
CREATE TABLE `llx_livraison` (
  `rowid` int(11) NOT NULL auto_increment,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `ref` varchar(30) NOT NULL,
  `entity` int(11) NOT NULL default '1',
  `fk_soc` int(11) NOT NULL,
  `ref_ext` varchar(30) default NULL,
  `ref_int` varchar(30) default NULL,
  `ref_customer` varchar(30) default NULL,
  `date_creation` datetime default NULL,
  `fk_user_author` int(11) default NULL,
  `date_valid` datetime default NULL,
  `fk_user_valid` int(11) default NULL,
  `date_delivery` date default NULL,
  `fk_address` int(11) default NULL,
  `fk_statut` smallint(6) default '0',
  `total_ht` double(24,8) default '0.00000000',
  `note` text,
  `note_public` text,
  `model_pdf` varchar(255) default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `idx_livraison_uk_ref` (`ref`,`entity`),
  KEY `idx_livraison_fk_soc` (`fk_soc`),
  KEY `idx_livraison_fk_user_author` (`fk_user_author`),
  KEY `idx_livraison_fk_user_valid` (`fk_user_valid`),
  CONSTRAINT `fk_livraison_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`),
  CONSTRAINT `fk_livraison_fk_user_author` FOREIGN KEY (`fk_user_author`) REFERENCES `llx_user` (`rowid`),
  CONSTRAINT `fk_livraison_fk_user_valid` FOREIGN KEY (`fk_user_valid`) REFERENCES `llx_user` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_livraison`
--

LOCK TABLES `llx_livraison` WRITE;
/*!40000 ALTER TABLE `llx_livraison` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_livraison` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_livraisondet`
--

DROP TABLE IF EXISTS `llx_livraisondet`;
CREATE TABLE `llx_livraisondet` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_livraison` int(11) default NULL,
  `fk_origin_line` int(11) default NULL,
  `fk_product` int(11) default NULL,
  `description` text,
  `qty` double default NULL,
  `subprice` double(24,8) default '0.00000000',
  `total_ht` double(24,8) default '0.00000000',
  `rang` int(11) default '0',
  PRIMARY KEY  (`rowid`),
  KEY `idx_livraisondet_fk_expedition` (`fk_livraison`),
  CONSTRAINT `fk_livraisondet_fk_livraison` FOREIGN KEY (`fk_livraison`) REFERENCES `llx_livraison` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_livraisondet`
--

LOCK TABLES `llx_livraisondet` WRITE;
/*!40000 ALTER TABLE `llx_livraisondet` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_livraisondet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_mailing`
--

DROP TABLE IF EXISTS `llx_mailing`;
CREATE TABLE `llx_mailing` (
  `rowid` int(11) NOT NULL auto_increment,
  `statut` smallint(6) default '0',
  `titre` varchar(60) default NULL,
  `entity` int(11) NOT NULL default '1',
  `sujet` varchar(60) default NULL,
  `body` text,
  `bgcolor` varchar(8) default NULL,
  `bgimage` varchar(255) default NULL,
  `cible` varchar(60) default NULL,
  `nbemail` int(11) default NULL,
  `email_from` varchar(160) default NULL,
  `email_replyto` varchar(160) default NULL,
  `email_errorsto` varchar(160) default NULL,
  `tag` varchar(128) default NULL,
  `date_creat` datetime default NULL,
  `date_valid` datetime default NULL,
  `date_appro` datetime default NULL,
  `date_envoi` datetime default NULL,
  `fk_user_creat` int(11) default NULL,
  `fk_user_valid` int(11) default NULL,
  `fk_user_appro` int(11) default NULL,
  `joined_file1` varchar(255) default NULL,
  `joined_file2` varchar(255) default NULL,
  `joined_file3` varchar(255) default NULL,
  `joined_file4` varchar(255) default NULL,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_mailing`
--

LOCK TABLES `llx_mailing` WRITE;
/*!40000 ALTER TABLE `llx_mailing` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_mailing` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_mailing_cibles`
--

DROP TABLE IF EXISTS `llx_mailing_cibles`;
CREATE TABLE `llx_mailing_cibles` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_mailing` int(11) NOT NULL,
  `fk_contact` int(11) NOT NULL,
  `nom` varchar(160) default NULL,
  `prenom` varchar(160) default NULL,
  `email` varchar(160) NOT NULL,
  `other` varchar(255) default NULL,
  `tag` varchar(128) default NULL,
  `statut` smallint(6) NOT NULL default '0',
  `source_url` varchar(160) default NULL,
  `source_id` int(11) default NULL,
  `source_type` varchar(16) default NULL,
  `date_envoi` datetime default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_mailing_cibles` (`fk_mailing`,`email`),
  KEY `idx_mailing_cibles_email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_mailing_cibles`
--

LOCK TABLES `llx_mailing_cibles` WRITE;
/*!40000 ALTER TABLE `llx_mailing_cibles` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_mailing_cibles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_menu`
--

DROP TABLE IF EXISTS `llx_menu`;
CREATE TABLE `llx_menu` (
  `rowid` int(11) NOT NULL auto_increment,
  `menu_handler` varchar(16) NOT NULL,
  `entity` int(11) NOT NULL default '1',
  `module` varchar(64) default NULL,
  `type` varchar(4) NOT NULL,
  `mainmenu` varchar(100) NOT NULL,
  `leftmenu` varchar(100) default NULL,
  `fk_menu` int(11) NOT NULL,
  `fk_mainmenu` varchar(16) default NULL,
  `fk_leftmenu` varchar(16) default NULL,
  `position` int(11) NOT NULL,
  `url` varchar(255) NOT NULL,
  `target` varchar(100) default NULL,
  `titre` varchar(255) NOT NULL,
  `langs` varchar(100) default NULL,
  `level` smallint(6) default NULL,
  `perms` varchar(255) default NULL,
  `enabled` varchar(255) default '1',
  `usertype` int(11) NOT NULL default '0',
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `idx_menu_uk_menu` (`menu_handler`,`fk_menu`,`position`,`url`,`entity`),
  KEY `idx_menu_menuhandler_type` (`menu_handler`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_menu`
--

LOCK TABLES `llx_menu` WRITE;
/*!40000 ALTER TABLE `llx_menu` DISABLE KEYS */;
INSERT INTO `llx_menu` VALUES (1,'all',1,'ecm','top','ecm','1',0,NULL,NULL,100,'/ecm/index.php','','MenuECM','ecm',NULL,'$user->rights->ecm->read || $user->rights->ecm->upload || $user->rights->ecm->setup','$conf->ecm->enabled',2,'2013-08-28 18:02:32'),(2,'all',1,'ecm','left','ecm','0',1,NULL,NULL,101,'/ecm/index.php','','ECMArea','ecm',NULL,'$user->rights->ecm->read || $user->rights->ecm->upload','$user->rights->ecm->read || $user->rights->ecm->upload',2,'2013-08-28 18:02:32'),(3,'all',1,'ecm','left','ecm','0',2,NULL,NULL,100,'/ecm/docdir.php?action=create','','ECMNewSection','ecm',NULL,'$user->rights->ecm->setup','$user->rights->ecm->setup',2,'2013-08-28 18:02:32'),(4,'all',1,'ecm','left','ecm','0',2,NULL,NULL,102,'/ecm/index.php?action=file_manager','','ECMFileManager','ecm',NULL,'$user->rights->ecm->read || $user->rights->ecm->upload','$user->rights->ecm->read || $user->rights->ecm->upload',2,'2013-08-28 18:02:32'),(5,'all',1,'ecm','left','ecm','0',2,NULL,NULL,103,'/ecm/search.php','','Search','ecm',NULL,'$user->rights->ecm->read','$user->rights->ecm->read',2,'2013-08-28 18:02:32'),(20,'all',1,'externalsite','top','externalsite','1',0,NULL,NULL,100,'/externalsite/frames.php','','ExternalSites','other',NULL,'','$conf->externalsite->enabled',0,'2013-08-28 18:13:31'),(21,'all',1,'ftp','top','ftp','0',0,NULL,NULL,100,'/ftp/index.php','','FTP','ftp',NULL,'$user->rights->ftp->read || $user->rights->ftp->write || $user->rights->ftp->setup','$conf->ftp->enabled',2,'2013-08-28 18:13:40'),(22,'all',1,'agenda','top','agenda','1',0,NULL,NULL,100,'/comm/action/index.php','','Agenda','agenda',NULL,'$user->rights->agenda->myactions->read','$conf->agenda->enabled',2,'2013-10-19 15:07:41'),(23,'all',1,'agenda','left','agenda','0',22,NULL,NULL,100,'/comm/action/index.php?mainmenu=agenda&amp;leftmenu=agenda','','Actions','agenda',NULL,'$user->rights->agenda->myactions->read','$conf->agenda->enabled',2,'2013-10-19 15:07:41'),(24,'all',1,'agenda','left','agenda','0',23,NULL,NULL,101,'/comm/action/fiche.php?mainmenu=agenda&amp;leftmenu=agenda&amp;action=create','','NewAction','commercial',NULL,'($user->rights->agenda->myactions->create||$user->rights->agenda->allactions->create)','$conf->agenda->enabled',2,'2013-10-19 15:07:41'),(25,'all',1,'agenda','left','agenda','0',23,NULL,NULL,102,'/comm/action/index.php?mainmenu=agenda&amp;leftmenu=agenda','','Calendar','agenda',NULL,'$user->rights->agenda->myactions->read','$conf->agenda->enabled',2,'2013-10-19 15:07:41'),(26,'all',1,'agenda','left','agenda','0',25,NULL,NULL,103,'/comm/action/index.php?mainmenu=agenda&amp;leftmenu=agenda&amp;status=todo&amp;filter=mine','','MenuToDoMyActions','agenda',NULL,'$user->rights->agenda->myactions->read','$conf->agenda->enabled',2,'2013-10-19 15:07:41'),(27,'all',1,'agenda','left','agenda','0',25,NULL,NULL,104,'/comm/action/index.php?mainmenu=agenda&amp;leftmenu=agenda&amp;status=done&amp;filter=mine','','MenuDoneMyActions','agenda',NULL,'$user->rights->agenda->myactions->read','$conf->agenda->enabled',2,'2013-10-19 15:07:41'),(28,'all',1,'agenda','left','agenda','0',25,NULL,NULL,105,'/comm/action/index.php?mainmenu=agenda&amp;leftmenu=agenda&amp;status=todo','','MenuToDoActions','agenda',NULL,'$user->rights->agenda->allactions->read','$user->rights->agenda->allactions->read',2,'2013-10-19 15:07:41'),(29,'all',1,'agenda','left','agenda','0',25,NULL,NULL,106,'/comm/action/index.php?mainmenu=agenda&amp;leftmenu=agenda&amp;status=done','','MenuDoneActions','agenda',NULL,'$user->rights->agenda->allactions->read','$user->rights->agenda->allactions->read',2,'2013-10-19 15:07:41'),(30,'all',1,'agenda','left','agenda','0',23,NULL,NULL,112,'/comm/action/listactions.php?mainmenu=agenda&amp;leftmenu=agenda','','List','agenda',NULL,'$user->rights->agenda->myactions->read','$conf->agenda->enabled',2,'2013-10-19 15:07:41'),(31,'all',1,'agenda','left','agenda','0',30,NULL,NULL,113,'/comm/action/listactions.php?mainmenu=agenda&amp;leftmenu=agenda&amp;status=todo&amp;filter=mine','','MenuToDoMyActions','agenda',NULL,'$user->rights->agenda->myactions->read','$conf->agenda->enabled',2,'2013-10-19 15:07:41'),(32,'all',1,'agenda','left','agenda','0',30,NULL,NULL,114,'/comm/action/listactions.php?mainmenu=agenda&amp;leftmenu=agenda&amp;status=done&amp;filter=mine','','MenuDoneMyActions','agenda',NULL,'$user->rights->agenda->myactions->read','$conf->agenda->enabled',2,'2013-10-19 15:07:41'),(33,'all',1,'agenda','left','agenda','0',30,NULL,NULL,115,'/comm/action/listactions.php?mainmenu=agenda&amp;leftmenu=agenda&amp;status=todo','','MenuToDoActions','agenda',NULL,'$user->rights->agenda->allactions->read','$user->rights->agenda->allactions->read',2,'2013-10-19 15:07:41'),(34,'all',1,'agenda','left','agenda','0',30,NULL,NULL,116,'/comm/action/listactions.php?mainmenu=agenda&amp;leftmenu=agenda&amp;status=done','','MenuDoneActions','agenda',NULL,'$user->rights->agenda->allactions->read','$user->rights->agenda->allactions->read',2,'2013-10-19 15:07:41'),(35,'all',1,'agenda','left','agenda','0',23,NULL,NULL,120,'/comm/action/rapport/index.php?mainmenu=agenda&amp;leftmenu=agenda','','Reportings','agenda',NULL,'$user->rights->agenda->allactions->read','$conf->agenda->enabled',2,'2013-10-19 15:07:41');
/*!40000 ALTER TABLE `llx_menu` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_notify`
--

DROP TABLE IF EXISTS `llx_notify`;
CREATE TABLE `llx_notify` (
  `rowid` int(11) NOT NULL auto_increment,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `daten` datetime default NULL,
  `fk_action` int(11) NOT NULL,
  `fk_contact` int(11) default NULL,
  `fk_user` int(11) default NULL,
  `objet_type` varchar(24) NOT NULL,
  `objet_id` int(11) NOT NULL,
  `email` varchar(255) default NULL,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_notify`
--

LOCK TABLES `llx_notify` WRITE;
/*!40000 ALTER TABLE `llx_notify` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_notify` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_notify_def`
--

DROP TABLE IF EXISTS `llx_notify_def`;
CREATE TABLE `llx_notify_def` (
  `rowid` int(11) NOT NULL auto_increment,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `datec` date default NULL,
  `fk_action` int(11) NOT NULL,
  `fk_soc` int(11) NOT NULL,
  `fk_contact` int(11) default NULL,
  `fk_user` int(11) default NULL,
  `type` varchar(16) default 'email',
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_notify_def`
--

LOCK TABLES `llx_notify_def` WRITE;
/*!40000 ALTER TABLE `llx_notify_def` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_notify_def` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_paiement`
--

DROP TABLE IF EXISTS `llx_paiement`;
CREATE TABLE `llx_paiement` (
  `rowid` int(11) NOT NULL auto_increment,
  `datec` datetime default NULL,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `datep` datetime default NULL,
  `amount` double(24,8) default '0.00000000',
  `fk_paiement` int(11) NOT NULL,
  `num_paiement` varchar(50) default NULL,
  `note` text,
  `fk_bank` int(11) NOT NULL default '0',
  `fk_user_creat` int(11) default NULL,
  `fk_user_modif` int(11) default NULL,
  `statut` smallint(6) NOT NULL default '0',
  `fk_export_compta` int(11) NOT NULL default '0',
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_paiement`
--

LOCK TABLES `llx_paiement` WRITE;
/*!40000 ALTER TABLE `llx_paiement` DISABLE KEYS */;
INSERT INTO `llx_paiement` VALUES (1,'2013-10-19 16:35:25','2013-10-19 14:35:25','2013-09-10 12:00:00',3289.00000000,2,'','',2,1,NULL,0,0);
/*!40000 ALTER TABLE `llx_paiement` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_paiement_facture`
--

DROP TABLE IF EXISTS `llx_paiement_facture`;
CREATE TABLE `llx_paiement_facture` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_paiement` int(11) default NULL,
  `fk_facture` int(11) default NULL,
  `amount` double(24,8) default '0.00000000',
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_paiement_facture` (`fk_paiement`,`fk_facture`),
  KEY `idx_paiement_facture_fk_facture` (`fk_facture`),
  KEY `idx_paiement_facture_fk_paiement` (`fk_paiement`),
  CONSTRAINT `fk_paiement_facture_fk_facture` FOREIGN KEY (`fk_facture`) REFERENCES `llx_facture` (`rowid`),
  CONSTRAINT `fk_paiement_facture_fk_paiement` FOREIGN KEY (`fk_paiement`) REFERENCES `llx_paiement` (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_paiement_facture`
--

LOCK TABLES `llx_paiement_facture` WRITE;
/*!40000 ALTER TABLE `llx_paiement_facture` DISABLE KEYS */;
INSERT INTO `llx_paiement_facture` VALUES (1,1,1,3289.00000000);
/*!40000 ALTER TABLE `llx_paiement_facture` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_paiementcharge`
--

DROP TABLE IF EXISTS `llx_paiementcharge`;
CREATE TABLE `llx_paiementcharge` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_charge` int(11) default NULL,
  `datec` datetime default NULL,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `datep` datetime default NULL,
  `amount` double default '0',
  `fk_typepaiement` int(11) NOT NULL,
  `num_paiement` varchar(50) default NULL,
  `note` text,
  `fk_bank` int(11) NOT NULL,
  `fk_user_creat` int(11) default NULL,
  `fk_user_modif` int(11) default NULL,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_paiementcharge`
--

LOCK TABLES `llx_paiementcharge` WRITE;
/*!40000 ALTER TABLE `llx_paiementcharge` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_paiementcharge` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_paiementfourn`
--

DROP TABLE IF EXISTS `llx_paiementfourn`;
CREATE TABLE `llx_paiementfourn` (
  `rowid` int(11) NOT NULL auto_increment,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `datec` datetime default NULL,
  `datep` datetime default NULL,
  `amount` double default '0',
  `fk_user_author` int(11) default NULL,
  `fk_paiement` int(11) NOT NULL,
  `num_paiement` varchar(50) default NULL,
  `note` text,
  `fk_bank` int(11) NOT NULL,
  `statut` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_paiementfourn`
--

LOCK TABLES `llx_paiementfourn` WRITE;
/*!40000 ALTER TABLE `llx_paiementfourn` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_paiementfourn` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_paiementfourn_facturefourn`
--

DROP TABLE IF EXISTS `llx_paiementfourn_facturefourn`;
CREATE TABLE `llx_paiementfourn_facturefourn` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_paiementfourn` int(11) default NULL,
  `fk_facturefourn` int(11) default NULL,
  `amount` double(24,8) default '0.00000000',
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_paiementfourn_facturefourn` (`fk_paiementfourn`,`fk_facturefourn`),
  KEY `idx_paiementfourn_facturefourn_fk_facture` (`fk_facturefourn`),
  KEY `idx_paiementfourn_facturefourn_fk_paiement` (`fk_paiementfourn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_paiementfourn_facturefourn`
--

LOCK TABLES `llx_paiementfourn_facturefourn` WRITE;
/*!40000 ALTER TABLE `llx_paiementfourn_facturefourn` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_paiementfourn_facturefourn` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_pos_tmp`
--

DROP TABLE IF EXISTS `llx_pos_tmp`;
CREATE TABLE `llx_pos_tmp` (
  `id` int(11) NOT NULL auto_increment,
  `fk_article` int(11) NOT NULL,
  `qte` double NOT NULL,
  `fk_tva` int(11) NOT NULL,
  `remise_percent` double NOT NULL,
  `remise` double NOT NULL,
  `total_ht` double(24,8) NOT NULL,
  `total_tva` double(24,8) NOT NULL,
  `total_ttc` double(24,8) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_pos_tmp`
--

LOCK TABLES `llx_pos_tmp` WRITE;
/*!40000 ALTER TABLE `llx_pos_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_pos_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_prelevement_bons`
--

DROP TABLE IF EXISTS `llx_prelevement_bons`;
CREATE TABLE `llx_prelevement_bons` (
  `rowid` int(11) NOT NULL auto_increment,
  `ref` varchar(12) default NULL,
  `entity` int(11) NOT NULL default '1',
  `datec` datetime default NULL,
  `amount` double default '0',
  `statut` smallint(6) default '0',
  `credite` smallint(6) default '0',
  `note` text,
  `date_trans` datetime default NULL,
  `method_trans` smallint(6) default NULL,
  `fk_user_trans` int(11) default NULL,
  `date_credit` datetime default NULL,
  `fk_user_credit` int(11) default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_prelevement_bons_ref` (`ref`,`entity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_prelevement_bons`
--

LOCK TABLES `llx_prelevement_bons` WRITE;
/*!40000 ALTER TABLE `llx_prelevement_bons` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_prelevement_bons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_prelevement_facture`
--

DROP TABLE IF EXISTS `llx_prelevement_facture`;
CREATE TABLE `llx_prelevement_facture` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_facture` int(11) NOT NULL,
  `fk_prelevement_lignes` int(11) NOT NULL,
  PRIMARY KEY  (`rowid`),
  KEY `idx_prelevement_facture_fk_prelevement_lignes` (`fk_prelevement_lignes`),
  CONSTRAINT `fk_prelevement_facture_fk_prelevement_lignes` FOREIGN KEY (`fk_prelevement_lignes`) REFERENCES `llx_prelevement_lignes` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_prelevement_facture`
--

LOCK TABLES `llx_prelevement_facture` WRITE;
/*!40000 ALTER TABLE `llx_prelevement_facture` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_prelevement_facture` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_prelevement_facture_demande`
--

DROP TABLE IF EXISTS `llx_prelevement_facture_demande`;
CREATE TABLE `llx_prelevement_facture_demande` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_facture` int(11) NOT NULL,
  `amount` double NOT NULL,
  `date_demande` datetime NOT NULL,
  `traite` smallint(6) default '0',
  `date_traite` datetime default NULL,
  `fk_prelevement_bons` int(11) default NULL,
  `fk_user_demande` int(11) NOT NULL,
  `code_banque` varchar(7) default NULL,
  `code_guichet` varchar(6) default NULL,
  `number` varchar(255) default NULL,
  `cle_rib` varchar(5) default NULL,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_prelevement_facture_demande`
--

LOCK TABLES `llx_prelevement_facture_demande` WRITE;
/*!40000 ALTER TABLE `llx_prelevement_facture_demande` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_prelevement_facture_demande` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_prelevement_lignes`
--

DROP TABLE IF EXISTS `llx_prelevement_lignes`;
CREATE TABLE `llx_prelevement_lignes` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_prelevement_bons` int(11) default NULL,
  `fk_soc` int(11) NOT NULL,
  `statut` smallint(6) default '0',
  `client_nom` varchar(255) default NULL,
  `amount` double default '0',
  `code_banque` varchar(7) default NULL,
  `code_guichet` varchar(6) default NULL,
  `number` varchar(255) default NULL,
  `cle_rib` varchar(5) default NULL,
  `note` text,
  PRIMARY KEY  (`rowid`),
  KEY `idx_prelevement_lignes_fk_prelevement_bons` (`fk_prelevement_bons`),
  CONSTRAINT `fk_prelevement_lignes_fk_prelevement_bons` FOREIGN KEY (`fk_prelevement_bons`) REFERENCES `llx_prelevement_bons` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_prelevement_lignes`
--

LOCK TABLES `llx_prelevement_lignes` WRITE;
/*!40000 ALTER TABLE `llx_prelevement_lignes` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_prelevement_lignes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_prelevement_rejet`
--

DROP TABLE IF EXISTS `llx_prelevement_rejet`;
CREATE TABLE `llx_prelevement_rejet` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_prelevement_lignes` int(11) default NULL,
  `date_rejet` datetime default NULL,
  `motif` int(11) default NULL,
  `date_creation` datetime default NULL,
  `fk_user_creation` int(11) default NULL,
  `note` text,
  `afacturer` tinyint(4) default '0',
  `fk_facture` int(11) default NULL,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_prelevement_rejet`
--

LOCK TABLES `llx_prelevement_rejet` WRITE;
/*!40000 ALTER TABLE `llx_prelevement_rejet` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_prelevement_rejet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_product`
--

DROP TABLE IF EXISTS `llx_product`;
CREATE TABLE `llx_product` (
  `rowid` int(11) NOT NULL auto_increment,
  `ref` varchar(32) NOT NULL,
  `entity` int(11) NOT NULL default '1',
  `ref_ext` varchar(32) default NULL,
  `datec` datetime default NULL,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `virtual` tinyint(4) NOT NULL default '0',
  `fk_parent` int(11) default '0',
  `label` varchar(255) NOT NULL,
  `description` text,
  `note` text,
  `customcode` varchar(32) default NULL,
  `fk_country` int(11) default NULL,
  `price` double(24,8) default '0.00000000',
  `price_ttc` double(24,8) default '0.00000000',
  `price_min` double(24,8) default '0.00000000',
  `price_min_ttc` double(24,8) default '0.00000000',
  `price_base_type` varchar(3) default 'HT',
  `tva_tx` double(6,3) default NULL,
  `recuperableonly` int(11) NOT NULL default '0',
  `localtax1_tx` double(6,3) default '0.000',
  `localtax2_tx` double(6,3) default '0.000',
  `fk_user_author` int(11) default NULL,
  `tosell` tinyint(4) default '1',
  `tobuy` tinyint(4) default '1',
  `fk_product_type` int(11) default '0',
  `duration` varchar(6) default NULL,
  `seuil_stock_alerte` int(11) default '0',
  `barcode` varchar(255) default NULL,
  `fk_barcode_type` int(11) default '0',
  `accountancy_code_sell` varchar(15) default NULL,
  `accountancy_code_buy` varchar(15) default NULL,
  `partnumber` varchar(32) default NULL,
  `weight` float default NULL,
  `weight_units` tinyint(4) default NULL,
  `length` float default NULL,
  `length_units` tinyint(4) default NULL,
  `surface` float default NULL,
  `surface_units` tinyint(4) default NULL,
  `volume` float default NULL,
  `volume_units` tinyint(4) default NULL,
  `stock` int(11) default NULL,
  `pmp` double(24,8) NOT NULL default '0.00000000',
  `canvas` varchar(32) default 'default@product',
  `finished` tinyint(4) default NULL,
  `hidden` tinyint(4) default '0',
  `import_key` varchar(14) default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_product_ref` (`ref`,`entity`),
  KEY `idx_product_label` (`label`),
  KEY `idx_product_barcode` (`barcode`),
  KEY `idx_product_import_key` (`import_key`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_product`
--

LOCK TABLES `llx_product` WRITE;
/*!40000 ALTER TABLE `llx_product` DISABLE KEYS */;
INSERT INTO `llx_product` VALUES (1,'001',1,NULL,'2013-08-28 21:56:59','2013-08-30 23:10:29',0,0,'Prestations Système Management PG','- g&eacute;rer votre syst&egrave;me d&#39;organisation, construire votre tableau de bord<br />\r\n- analyser les risques Qualit&eacute;s,S&eacute;curit&eacute; et Environnement<br />\r\n- pr&eacute;parer vos certifications qualit&eacute;s<br />\r\n- former aux outils d&#39;am&eacute;lioration<br />\r\n- animer les groupes de travail<br />\r\n- auditer vos organisations,auditeur ICA QSE','Gestion du Syst&egrave;me de Management QSE','',NULL,343.75000000,411.13000000,0.00000000,0.00000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'1d',NULL,NULL,0,'706000','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(2,'002',1,NULL,'2013-08-28 22:24:05','2013-08-31 21:48:58',0,0,'Prestations Conseil Système Management','- g&eacute;rer votre syst&egrave;me d&#39;organisation, construire votre tableau de bord<br />\r\n- analyser les risques Qualit&eacute;s,S&eacute;curit&eacute; et Environnement','Gestion du Syst&egrave;me de Management QSE','',NULL,875.00000000,1046.50000000,450.00000000,538.20000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'1d',NULL,NULL,0,'706200','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(3,'003',1,NULL,'2013-08-28 22:37:37','2013-08-30 23:37:59',0,0,'prestation Audit 1 référentiel renouvellement AFNOR','jour de prestation Audit de renouvellement AFNOR','jour de prestation Audit de renouvellement AFNOR','',NULL,350.00000000,418.60000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'1d',NULL,NULL,0,'706100','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(4,'004',1,NULL,'2013-08-28 22:43:39','2013-08-31 21:45:22',0,0,'prestation Audit 1 référentiel surveillance 1 AFNOR','jour de prestation Audit de surveillance 1 AFNOR','jour de prestation Audit de surveillance 1 AFNOR','',NULL,350.00000000,418.60000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'1d',NULL,NULL,0,'706400','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(5,'005',1,NULL,'2013-08-29 22:34:27','2013-08-31 21:44:57',0,0,'prestation Audit 1 référentiel surveillance 2 AFNOR','jour de prestation Audit de surveillance 2 AFNOR','jour de prestation Audit de surveillance 2 AFNOR','',NULL,350.00000000,418.60000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'1d',NULL,NULL,0,'706400','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(6,'006',1,NULL,'2013-08-29 23:02:23','2013-08-31 21:43:00',0,0,'prestation Audit 2 référentiels renouvellement AFNOR','jour de prestation Audit de renouvellement QE/QS/SE AFNOR','jour de prestation Audit de renouvellement AFNOR','',NULL,400.00000000,478.40000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'1d',NULL,NULL,0,'706400','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(7,'007',1,NULL,'2013-08-29 23:13:23','2013-08-31 21:41:30',0,0,'prestation Audit 2 référentiels surveillance 1 AFNOR','jour de prestation Audit de surveillance 1 QE/QS/SE AFNOR','jour de prestation Audit de surveillance 1 AFNOR','',NULL,400.00000000,478.40000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'1d',NULL,NULL,0,'706400','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(8,'008',1,NULL,'2013-08-29 23:21:00','2013-08-31 21:38:50',0,0,'prestation Audit 2 référentiels surveillance 2 AFNOR','jour de prestation Audit de surveillance 2 QE/QS/SE AFNOR','jour de prestation Audit de surveillance 2 AFNOR','',NULL,400.00000000,478.40000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'1d',NULL,NULL,0,'706400','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(9,'009',1,NULL,'2013-08-30 23:43:22','2013-08-31 21:37:45',0,0,'prestation Audit 3 référentiels renouvellement AFNOR','jour de prestation Audit de renouvellement QSE AFNOR','jour de prestation Audit de renouvellement AFNOR','',NULL,460.00000000,550.16000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'1d',NULL,NULL,0,'706400','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(10,'010',1,NULL,'2013-08-30 23:47:52','2013-08-31 21:37:05',0,0,'prestation Audit 3 référentiels surveillance 1 AFNOR','jour de prestation Audit de surveillance 1 QSE AFNOR','jour de prestation Audit de surveillance 1 AFNOR','',NULL,460.00000000,550.16000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'1d',NULL,NULL,0,'706400','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(11,'011',1,NULL,'2013-08-30 23:53:25','2013-08-31 21:36:23',0,0,'prestation Audit 3 référentiels surveillance 2 AFNOR','jour de prestation Audit de surveillance 2 QSE AFNOR','jour de prestation Audit de surveillance 2 AFNOR','',NULL,460.00000000,550.16000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'1d',NULL,NULL,0,'706400','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(12,'012',1,NULL,'2013-08-30 23:59:24','2013-08-31 21:33:40',0,0,'prestation R Audit 1 référentiel renouvellement AFNOR','jour de prestation Responsable Audit de renouvellement Q/S/E AFNOR','jour de prestation Audit de renouvellement AFNOR','',NULL,400.00000000,478.40000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'1d',NULL,NULL,0,'706400','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(13,'013',1,NULL,'2013-08-31 00:07:07','2013-08-31 21:33:05',0,0,'prestation R Audit 1 référentiel surveillance 1 AFNOR','jour de prestation Responsable Audit de &nbsp;surveillance 1 Q/S/E AFNOR','jour de prestation Audit de &nbsp;surveillance 1 AFNOR','',NULL,400.00000000,478.40000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'1d',NULL,NULL,0,'706400','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(14,'014',1,NULL,'2013-08-31 00:12:22','2013-08-31 21:32:31',0,0,'prestation R Audit 1 référentiel surveillance 2 AFNOR','jour de prestation Responsable Audit de &nbsp;surveillance 2 Q/S/E AFNOR','jour de prestation Audit de &nbsp;surveillance 2 AFNOR','',NULL,400.00000000,478.40000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'1d',NULL,NULL,0,'706400','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(15,'015',1,NULL,'2013-08-31 00:16:08','2013-08-31 21:27:31',0,0,'prestation R Audit 2 référentiels renouvellement AFNOR','jour de prestation Responsable Audit de renouvellement QE/QS/SE AFNOR','jour de prestation Audit de renouvellement AFNOR','',NULL,460.00000000,550.16000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'1d',NULL,NULL,0,'706400','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(16,'016',1,NULL,'2013-08-31 00:21:38','2013-08-31 21:25:32',0,0,'prestation R Audit 2 référentiels surveillance 1 AFNOR','jour de prestation Responsable Audit de surveillance 1 QE/QS/SE AFNOR','jour de prestation Audit de surveillance 1 AFNOR','',NULL,460.00000000,550.16000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'1d',NULL,NULL,0,'706400','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(17,'017',1,NULL,'2013-08-31 00:23:32','2013-08-31 21:24:39',0,0,'prestation R Audit 2 référentiels surveillance 2 AFNOR','jour de prestation Responsable Audit de surveillance 2 QE/QS/SE AFNOR','jour de prestation Audit de surveillance 2 AFNOR','',NULL,460.00000000,550.16000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'1d',NULL,NULL,0,'706400','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(18,'018',1,NULL,'2013-08-31 00:33:00','2013-08-31 21:23:26',0,0,'prestation R Audit 3 référentiels renouvellement AFNOR','jour de prestation Responsable Audit de renouvellement QSE AFNOR','jour de prestation Audit de renouvellement AFNOR','',NULL,520.00000000,621.92000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'1d',NULL,NULL,0,'706400','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(19,'019',1,NULL,'2013-08-31 00:39:13','2013-08-31 21:22:47',0,0,'prestation R Audit 3 référentiels surveillance 1 AFNOR','jour de prestation Responsable Audit de surveillance 1 QSE AFNOR','jour de prestation Audit de surveillance 1 AFNOR','',NULL,520.00000000,621.92000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'1d',NULL,NULL,0,'706400','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(20,'020',1,NULL,'2013-08-31 00:42:21','2013-08-31 21:22:18',0,0,'prestation R Audit 3 référentiels surveillance 2 AFNOR','jour de prestation Responsable Audit de surveillance 2 QSE AFNOR','jour de prestation Audit de surveillance 2 AFNOR','',NULL,520.00000000,621.92000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'1d',NULL,NULL,0,'706400','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(21,'021',1,NULL,'2013-08-31 19:37:10','2013-08-31 21:21:00',0,0,'prestation Audit  ISO 9001 par étape Niv1 AFNOR','jour de prestation Audit &nbsp;ISO 9001 par &eacute;tape Niv1 AFNOR','jour de prestation Audit &nbsp;ISO 9001 par &eacute;tape Niv1 AFNOR','',NULL,400.00000000,478.40000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'1d',NULL,NULL,0,'706400','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(22,'022',1,NULL,'2013-08-31 19:39:45','2013-08-31 21:20:18',0,0,'prestation Audit  ISO 9001 par étape Niv2 AFNOR','jour de prestation Audit &nbsp;ISO 9001 par &eacute;tape Niv2 AFNOR','jour de prestation Audit &nbsp;ISO 9001 par &eacute;tape Niv2 AFNOR','',NULL,400.00000000,478.40000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'1d',NULL,NULL,0,'706400','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(23,'023',1,NULL,'2013-08-31 19:40:42','2013-08-31 21:19:41',0,0,'prestation Audit  ISO 9001 par étape Niv3 AFNOR','jour de prestation Audit &nbsp;ISO 9001 par &eacute;tape Niv3 AFNOR','jour de prestation Audit &nbsp;ISO 9001 par &eacute;tape Niv3 AFNOR','',NULL,400.00000000,478.40000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'1d',NULL,NULL,0,'706400','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(24,'024',1,NULL,'2013-09-01 00:25:19','2013-08-31 22:28:58',0,0,'prestation Audit Externe','jour de prestation Audit &nbsp;tout r&eacute;f&eacute;rentiel','jour de prestation jour de prestation Audit &nbsp;tout r&eacute;f&eacute;rentiel','',NULL,700.00000000,837.20000000,650.00000000,777.40000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'1d',NULL,NULL,0,'706300','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(25,'025',1,NULL,'2013-09-20 00:51:57','2013-10-19 15:10:15',0,0,'Formation Préparation à la ceriification ISO 9001','- Les principes g&eacute;n&eacute;raux ( d&eacute;finition, SMQ, l&#39;approche processus, le cycle PDCA, les enjeux de la certification<br />\r\n- les exigences normatives ISO 9001 ( domaine d&#39;application, r&eacute;f&eacute;rence normative, d&eacute;finition et forme de la norme, SMQ, responsabilit&eacute; de la direction, management des ressources, r&eacute;alisation du produit, mesure analyse et am&eacute;lioration)<br />\r\n- le plan d&#39;action interne (planification, mise en place, v&eacute;rification, suivi des actions)','','',NULL,1750.00000000,2093.00000000,0.00000000,0.00000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'2d',NULL,NULL,0,'','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(26,'026',1,NULL,'2013-10-19 17:52:44','2013-10-20 15:32:56',0,0,'Déplacement Kilométrique HT AFNOR','d&eacute;placement kilom&eacute;trique HT AFNOR','','',1,0.40000000,0.47000000,0.00000000,0.00000000,'HT',19.600,0,0.000,0.000,1,1,1,1,'',NULL,NULL,0,'','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(27,'027',1,NULL,'2013-10-20 17:14:12','2013-10-20 15:43:18',0,0,'parking TTC AFNOR','','prestation parking','',1,0.00000000,0.00000000,0.00000000,0.00000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'d',NULL,NULL,0,'','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(28,'028',1,NULL,'2013-10-20 17:39:43','2013-10-20 15:39:43',0,0,'Déplacement Avion TTC AFNOR','d&eacute;placement &nbsp;Avion TTC','','',1,0.00000000,0.00000000,0.00000000,0.00000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'',NULL,NULL,0,'','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL),(29,'029',1,NULL,'2013-10-20 17:44:56','2013-10-20 15:46:43',0,0,'Déplacement Train TTC AFNOR','d&eacute;placement &nbsp;train TTC','','',1,0.00000000,0.00000000,0.00000000,0.00000000,'HT',19.600,0,0.000,0.000,1,1,0,1,'',NULL,NULL,0,'','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00000000,'',0,0,NULL);
/*!40000 ALTER TABLE `llx_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_product_association`
--

DROP TABLE IF EXISTS `llx_product_association`;
CREATE TABLE `llx_product_association` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_product_pere` int(11) NOT NULL default '0',
  `fk_product_fils` int(11) NOT NULL default '0',
  `qty` double default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_product_association` (`fk_product_pere`,`fk_product_fils`),
  KEY `idx_product_association_fils` (`fk_product_fils`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_product_association`
--

LOCK TABLES `llx_product_association` WRITE;
/*!40000 ALTER TABLE `llx_product_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_product_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_product_ca`
--

DROP TABLE IF EXISTS `llx_product_ca`;
CREATE TABLE `llx_product_ca` (
  `fk_product` int(11) default NULL,
  `date_calcul` datetime default NULL,
  `year` smallint(5) unsigned default NULL,
  `ca_genere` float default NULL,
  UNIQUE KEY `fk_product` (`fk_product`,`year`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_product_ca`
--

LOCK TABLES `llx_product_ca` WRITE;
/*!40000 ALTER TABLE `llx_product_ca` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_product_ca` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_product_extrafields`
--

DROP TABLE IF EXISTS `llx_product_extrafields`;
CREATE TABLE `llx_product_extrafields` (
  `rowid` int(11) NOT NULL auto_increment,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  PRIMARY KEY  (`rowid`),
  KEY `idx_product_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_product_extrafields`
--

LOCK TABLES `llx_product_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_product_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_product_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_product_fournisseur`
--

DROP TABLE IF EXISTS `llx_product_fournisseur`;
CREATE TABLE `llx_product_fournisseur` (
  `rowid` int(11) NOT NULL auto_increment,
  `datec` datetime default NULL,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `fk_product` int(11) default NULL,
  `fk_soc` int(11) default NULL,
  `ref_fourn` varchar(30) default NULL,
  `entity` int(11) NOT NULL default '1',
  `fk_user_author` int(11) default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_product_fournisseur_ref` (`ref_fourn`,`fk_soc`,`entity`),
  KEY `idx_product_fourn_fk_product` (`fk_product`,`entity`),
  KEY `idx_product_fourn_fk_soc` (`fk_soc`,`entity`),
  CONSTRAINT `fk_product_fournisseur_fk_product` FOREIGN KEY (`fk_product`) REFERENCES `llx_product` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_product_fournisseur`
--

LOCK TABLES `llx_product_fournisseur` WRITE;
/*!40000 ALTER TABLE `llx_product_fournisseur` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_product_fournisseur` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_product_fournisseur_price`
--

DROP TABLE IF EXISTS `llx_product_fournisseur_price`;
CREATE TABLE `llx_product_fournisseur_price` (
  `rowid` int(11) NOT NULL auto_increment,
  `datec` datetime default NULL,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `fk_product_fournisseur` int(11) NOT NULL,
  `price` double(24,8) default '0.00000000',
  `quantity` double default NULL,
  `unitprice` double(24,8) default '0.00000000',
  `fk_user` int(11) default NULL,
  PRIMARY KEY  (`rowid`),
  KEY `idx_product_fournisseur_price_fk_user` (`fk_user`),
  KEY `idx_product_fournisseur_price_fk_product_fournisseur` (`fk_product_fournisseur`),
  CONSTRAINT `fk_product_fournisseur_price_fk_product_fournisseur` FOREIGN KEY (`fk_product_fournisseur`) REFERENCES `llx_product_fournisseur` (`rowid`),
  CONSTRAINT `fk_product_fournisseur_price_fk_user` FOREIGN KEY (`fk_user`) REFERENCES `llx_user` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_product_fournisseur_price`
--

LOCK TABLES `llx_product_fournisseur_price` WRITE;
/*!40000 ALTER TABLE `llx_product_fournisseur_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_product_fournisseur_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_product_fournisseur_price_log`
--

DROP TABLE IF EXISTS `llx_product_fournisseur_price_log`;
CREATE TABLE `llx_product_fournisseur_price_log` (
  `rowid` int(11) NOT NULL auto_increment,
  `datec` datetime default NULL,
  `fk_product_fournisseur` int(11) NOT NULL,
  `price` double(24,8) default '0.00000000',
  `quantity` double default NULL,
  `fk_user` int(11) default NULL,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_product_fournisseur_price_log`
--

LOCK TABLES `llx_product_fournisseur_price_log` WRITE;
/*!40000 ALTER TABLE `llx_product_fournisseur_price_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_product_fournisseur_price_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_product_lang`
--

DROP TABLE IF EXISTS `llx_product_lang`;
CREATE TABLE `llx_product_lang` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_product` int(11) NOT NULL default '0',
  `lang` varchar(5) NOT NULL default '0',
  `label` varchar(255) NOT NULL,
  `description` text,
  `note` text,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_product_lang` (`fk_product`,`lang`),
  CONSTRAINT `fk_product_lang_fk_product` FOREIGN KEY (`fk_product`) REFERENCES `llx_product` (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_product_lang`
--

LOCK TABLES `llx_product_lang` WRITE;
/*!40000 ALTER TABLE `llx_product_lang` DISABLE KEYS */;
INSERT INTO `llx_product_lang` VALUES (1,1,'fr_FR','Prestations Système Management PG','- g&eacute;rer votre syst&egrave;me d&#39;organisation, construire votre tableau de bord<br />\r\n- analyser les risques Qualit&eacute;s,S&eacute;curit&eacute; et Environnement<br />\r\n- pr&eacute;parer vos certifications qualit&eacute;s<br />\r\n- former aux outils d&#39;am&eacute;lioration<br />\r\n- animer les groupes de travail<br />\r\n- auditer vos organisations,auditeur ICA QSE','Gestion du Syst&egrave;me de Management QSE'),(2,2,'fr_FR','Prestations Conseil Système Management','- g&eacute;rer votre syst&egrave;me d&#39;organisation, construire votre tableau de bord<br />\r\n- analyser les risques Qualit&eacute;s,S&eacute;curit&eacute; et Environnement','Gestion du Syst&egrave;me de Management QSE'),(3,3,'fr_FR','prestation Audit 1 référentiel renouvellement AFNOR','jour de prestation Audit de renouvellement AFNOR','jour de prestation Audit de renouvellement AFNOR'),(4,4,'fr_FR','prestation Audit 1 référentiel surveillance 1 AFNOR','jour de prestation Audit de surveillance 1 AFNOR','jour de prestation Audit de surveillance 1 AFNOR'),(5,5,'fr_FR','prestation Audit 1 référentiel surveillance 2 AFNOR','jour de prestation Audit de surveillance 2 AFNOR','jour de prestation Audit de surveillance 2 AFNOR'),(6,6,'fr_FR','prestation Audit 2 référentiels renouvellement AFNOR','jour de prestation Audit de renouvellement QE/QS/SE AFNOR','jour de prestation Audit de renouvellement AFNOR'),(7,7,'fr_FR','prestation Audit 2 référentiels surveillance 1 AFNOR','jour de prestation Audit de surveillance 1 QE/QS/SE AFNOR','jour de prestation Audit de surveillance 1 AFNOR'),(8,8,'fr_FR','prestation Audit 2 référentiels surveillance 2 AFNOR','jour de prestation Audit de surveillance 2 QE/QS/SE AFNOR','jour de prestation Audit de surveillance 2 AFNOR'),(9,9,'fr_FR','prestation Audit 3 référentiels renouvellement AFNOR','jour de prestation Audit de renouvellement QSE AFNOR','jour de prestation Audit de renouvellement AFNOR'),(10,10,'fr_FR','prestation Audit 3 référentiels surveillance 1 AFNOR','jour de prestation Audit de surveillance 1 QSE AFNOR','jour de prestation Audit de surveillance 1 AFNOR'),(11,11,'fr_FR','prestation Audit 3 référentiels surveillance 2 AFNOR','jour de prestation Audit de surveillance 2 QSE AFNOR','jour de prestation Audit de surveillance 2 AFNOR'),(12,12,'fr_FR','prestation R Audit 1 référentiel renouvellement AFNOR','jour de prestation Responsable Audit de renouvellement Q/S/E AFNOR','jour de prestation Audit de renouvellement AFNOR'),(13,13,'fr_FR','prestation R Audit 1 référentiel surveillance 1 AFNOR','jour de prestation Responsable Audit de &nbsp;surveillance 1 Q/S/E AFNOR','jour de prestation Audit de &nbsp;surveillance 1 AFNOR'),(14,14,'fr_FR','prestation R Audit 1 référentiel surveillance 2 AFNOR','jour de prestation Responsable Audit de &nbsp;surveillance 2 Q/S/E AFNOR','jour de prestation Audit de &nbsp;surveillance 2 AFNOR'),(15,15,'fr_FR','prestation R Audit 2 référentiels renouvellement AFNOR','jour de prestation Responsable Audit de renouvellement QE/QS/SE AFNOR','jour de prestation Audit de renouvellement AFNOR'),(16,16,'fr_FR','prestation R Audit 2 référentiels surveillance 1 AFNOR','jour de prestation Responsable Audit de surveillance 1 QE/QS/SE AFNOR','jour de prestation Audit de surveillance 1 AFNOR'),(17,17,'fr_FR','prestation R Audit 2 référentiels surveillance 2 AFNOR','jour de prestation Responsable Audit de surveillance 2 QE/QS/SE AFNOR','jour de prestation Audit de surveillance 2 AFNOR'),(18,18,'fr_FR','prestation R Audit 3 référentiels renouvellement AFNOR','jour de prestation Responsable Audit de renouvellement QSE AFNOR','jour de prestation Audit de renouvellement AFNOR'),(19,19,'fr_FR','prestation R Audit 3 référentiels surveillance 1 AFNOR','jour de prestation Responsable Audit de surveillance 1 QSE AFNOR','jour de prestation Audit de surveillance 1 AFNOR'),(20,20,'fr_FR','prestation R Audit 3 référentiels surveillance 2 AFNOR','jour de prestation Responsable Audit de surveillance 2 QSE AFNOR','jour de prestation Audit de surveillance 2 AFNOR'),(21,21,'fr_FR','prestation Audit  ISO 9001 par étape Niv1 AFNOR','jour de prestation Audit &nbsp;ISO 9001 par &eacute;tape Niv1 AFNOR','jour de prestation Audit &nbsp;ISO 9001 par &eacute;tape Niv1 AFNOR'),(22,22,'fr_FR','prestation Audit  ISO 9001 par étape Niv2 AFNOR','jour de prestation Audit &nbsp;ISO 9001 par &eacute;tape Niv2 AFNOR','jour de prestation Audit &nbsp;ISO 9001 par &eacute;tape Niv2 AFNOR'),(23,23,'fr_FR','prestation Audit  ISO 9001 par étape Niv3 AFNOR','jour de prestation Audit &nbsp;ISO 9001 par &eacute;tape Niv3 AFNOR','jour de prestation Audit &nbsp;ISO 9001 par &eacute;tape Niv3 AFNOR'),(24,24,'fr_FR','prestation Audit Externe','jour de prestation Audit &nbsp;tout r&eacute;f&eacute;rentiel','jour de prestation jour de prestation Audit &nbsp;tout r&eacute;f&eacute;rentiel'),(25,25,'fr_FR','Formation Préparation à la ceriification ISO 9001','- Les principes g&eacute;n&eacute;raux ( d&eacute;finition, SMQ, l&#39;approche processus, le cycle PDCA, les enjeux de la certification<br />\r\n- les exigences normatives ISO 9001 ( domaine d&#39;application, r&eacute;f&eacute;rence normative, d&eacute;finition et forme de la norme, SMQ, responsabilit&eacute; de la direction, management des ressources, r&eacute;alisation du produit, mesure analyse et am&eacute;lioration)<br />\r\n- le plan d&#39;action interne (planification, mise en place, v&eacute;rification, suivi des actions)',''),(26,26,'fr_FR','Déplacement Kilométrique HT AFNOR','d&eacute;placement kilom&eacute;trique HT AFNOR',''),(27,27,'fr_FR','parking TTC AFNOR','','prestation parking'),(28,28,'fr_FR','Déplacement Avion TTC AFNOR','d&eacute;placement &nbsp;Avion TTC',''),(29,29,'fr_FR','Déplacement Train TTC AFNOR','d&eacute;placement &nbsp;train TTC','');
/*!40000 ALTER TABLE `llx_product_lang` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_product_price`
--

DROP TABLE IF EXISTS `llx_product_price`;
CREATE TABLE `llx_product_price` (
  `rowid` int(11) NOT NULL auto_increment,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `fk_product` int(11) NOT NULL,
  `date_price` datetime NOT NULL,
  `price_level` smallint(6) default '1',
  `price` double(24,8) default NULL,
  `price_ttc` double(24,8) default NULL,
  `price_min` double(24,8) default NULL,
  `price_min_ttc` double(24,8) default NULL,
  `price_base_type` varchar(3) default 'HT',
  `tva_tx` double(6,3) NOT NULL,
  `recuperableonly` int(11) NOT NULL default '0',
  `localtax1_tx` double(6,3) default '0.000',
  `localtax2_tx` double(6,3) default '0.000',
  `fk_user_author` int(11) default NULL,
  `tosell` tinyint(4) default '1',
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_product_price`
--

LOCK TABLES `llx_product_price` WRITE;
/*!40000 ALTER TABLE `llx_product_price` DISABLE KEYS */;
INSERT INTO `llx_product_price` VALUES (1,'2013-08-28 19:56:59',1,'2013-08-28 21:56:59',1,343.75000000,411.13000000,0.00000000,0.00000000,'HT',19.600,0,0.000,0.000,1,1),(2,'2013-08-28 20:24:05',2,'2013-08-28 22:24:05',1,343.75000000,411.13000000,0.00000000,0.00000000,'HT',19.600,0,0.000,0.000,1,0),(3,'2013-08-28 20:26:30',2,'2013-08-28 22:26:30',1,875.00000000,1046.50000000,450.00000000,538.20000000,'HT',19.600,0,0.000,0.000,1,1),(4,'2013-08-28 20:37:37',3,'2013-08-28 22:37:37',1,350.00000000,418.60000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1),(5,'2013-08-28 20:43:39',4,'2013-08-28 22:43:39',1,350.00000000,418.60000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,0),(6,'2013-08-29 20:34:27',5,'2013-08-29 22:34:27',1,350.00000000,418.60000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,0),(7,'2013-08-29 21:02:23',6,'2013-08-29 23:02:23',1,350.00000000,418.60000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,0),(8,'2013-08-29 21:05:30',6,'2013-08-29 23:05:30',1,400.00000000,478.40000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1),(9,'2013-08-29 21:13:23',7,'2013-08-29 23:13:23',1,350.00000000,418.60000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,0),(10,'2013-08-29 21:16:26',7,'2013-08-29 23:16:26',1,400.00000000,478.40000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1),(11,'2013-08-29 21:21:00',8,'2013-08-29 23:21:00',1,350.00000000,418.60000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,0),(12,'2013-08-29 21:23:03',8,'2013-08-29 23:23:03',1,400.00000000,478.40000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1),(13,'2013-08-30 21:43:22',9,'2013-08-30 23:43:22',1,400.00000000,478.40000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,0),(14,'2013-08-30 21:46:51',9,'2013-08-30 23:46:51',1,460.00000000,550.16000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1),(15,'2013-08-30 21:47:52',10,'2013-08-30 23:47:52',1,400.00000000,478.40000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,0),(16,'2013-08-30 21:52:16',10,'2013-08-30 23:52:16',1,460.00000000,550.16000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1),(17,'2013-08-30 21:53:25',11,'2013-08-30 23:53:25',1,400.00000000,478.40000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,0),(18,'2013-08-30 21:54:51',11,'2013-08-30 23:54:51',1,460.00000000,550.16000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1),(19,'2013-08-30 21:59:24',12,'2013-08-30 23:59:24',1,400.00000000,478.40000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,0),(20,'2013-08-30 22:04:57',12,'2013-08-31 00:04:57',1,460.00000000,550.16000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1),(21,'2013-08-30 22:07:07',13,'2013-08-31 00:07:07',1,460.00000000,550.16000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,0),(22,'2013-08-30 22:08:58',13,'2013-08-31 00:08:58',1,400.00000000,478.40000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1),(23,'2013-08-30 22:09:56',12,'2013-08-31 00:09:56',1,400.00000000,478.40000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1),(24,'2013-08-30 22:12:22',14,'2013-08-31 00:12:22',1,400.00000000,478.40000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,0),(25,'2013-08-30 22:16:08',15,'2013-08-31 00:16:08',1,400.00000000,478.40000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,0),(26,'2013-08-30 22:19:01',15,'2013-08-31 00:19:01',1,460.00000000,550.16000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1),(27,'2013-08-30 22:21:38',16,'2013-08-31 00:21:38',1,460.00000000,550.16000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,0),(28,'2013-08-30 22:23:32',17,'2013-08-31 00:23:32',1,460.00000000,550.16000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,0),(29,'2013-08-30 22:33:00',18,'2013-08-31 00:33:00',1,460.00000000,550.16000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,0),(30,'2013-08-30 22:35:55',18,'2013-08-31 00:35:55',1,520.00000000,621.92000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1),(31,'2013-08-30 22:39:14',19,'2013-08-31 00:39:14',1,460.00000000,550.16000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,0),(32,'2013-08-30 22:41:12',19,'2013-08-31 00:41:12',1,520.00000000,621.92000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1),(33,'2013-08-30 22:42:21',20,'2013-08-31 00:42:21',1,460.00000000,550.16000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,0),(34,'2013-08-30 22:43:59',20,'2013-08-31 00:43:59',1,520.00000000,621.92000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1),(35,'2013-08-31 17:37:10',21,'2013-08-31 19:37:10',1,350.00000000,418.60000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,0),(36,'2013-08-31 17:39:16',21,'2013-08-31 19:39:16',1,400.00000000,478.40000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,1),(37,'2013-08-31 17:39:45',22,'2013-08-31 19:39:45',1,400.00000000,478.40000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,0),(38,'2013-08-31 17:40:42',23,'2013-08-31 19:40:42',1,400.00000000,478.40000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,0),(39,'2013-08-31 22:25:19',24,'2013-09-01 00:25:19',1,400.00000000,478.40000000,350.00000000,418.60000000,'HT',19.600,0,0.000,0.000,1,0),(40,'2013-08-31 22:28:58',24,'2013-09-01 00:28:58',1,700.00000000,837.20000000,650.00000000,777.40000000,'HT',19.600,0,0.000,0.000,1,1),(41,'2013-09-19 22:51:57',25,'2013-09-20 00:51:57',1,1750.00000000,2093.00000000,0.00000000,0.00000000,'HT',19.600,0,0.000,0.000,1,1),(42,'2013-10-19 15:52:44',26,'2013-10-19 17:52:44',1,0.40000000,0.47000000,0.00000000,0.00000000,'HT',19.600,0,0.000,0.000,1,1),(43,'2013-10-20 15:14:12',27,'2013-10-20 17:14:12',1,0.00000000,0.00000000,0.00000000,0.00000000,'HT',19.600,0,0.000,0.000,1,1),(44,'2013-10-20 15:39:43',28,'2013-10-20 17:39:43',1,0.00000000,0.00000000,0.00000000,0.00000000,'HT',19.600,0,0.000,0.000,1,1),(45,'2013-10-20 15:44:56',29,'2013-10-20 17:44:56',1,0.00000000,0.00000000,0.00000000,0.00000000,'HT',19.600,0,0.000,0.000,1,0);
/*!40000 ALTER TABLE `llx_product_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_product_stock`
--

DROP TABLE IF EXISTS `llx_product_stock`;
CREATE TABLE `llx_product_stock` (
  `rowid` int(11) NOT NULL auto_increment,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `fk_product` int(11) NOT NULL,
  `fk_entrepot` int(11) NOT NULL,
  `reel` double default NULL,
  `pmp` double(24,8) NOT NULL default '0.00000000',
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_product_stock` (`fk_product`,`fk_entrepot`),
  KEY `idx_product_stock_fk_product` (`fk_product`),
  KEY `idx_product_stock_fk_entrepot` (`fk_entrepot`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_product_stock`
--

LOCK TABLES `llx_product_stock` WRITE;
/*!40000 ALTER TABLE `llx_product_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_product_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_projet`
--

DROP TABLE IF EXISTS `llx_projet`;
CREATE TABLE `llx_projet` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_soc` int(11) default NULL,
  `datec` date default NULL,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `dateo` date default NULL,
  `datee` date default NULL,
  `ref` varchar(50) default NULL,
  `entity` int(11) NOT NULL default '1',
  `title` varchar(255) NOT NULL,
  `description` text,
  `fk_user_creat` int(11) NOT NULL,
  `public` int(11) default NULL,
  `fk_statut` smallint(6) NOT NULL default '0',
  `note_private` text,
  `note_public` text,
  `model_pdf` varchar(255) default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_projet_ref` (`ref`,`entity`),
  KEY `idx_projet_fk_soc` (`fk_soc`),
  CONSTRAINT `fk_projet_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_projet`
--

LOCK TABLES `llx_projet` WRITE;
/*!40000 ALTER TABLE `llx_projet` DISABLE KEYS */;
INSERT INTO `llx_projet` VALUES (1,1,'2013-08-31','2013-08-31 19:36:37','2009-08-05',NULL,'PJ1308-0001',1,'Gestion du SMQHSE','',1,0,1,NULL,NULL,'baleine'),(2,2,'2013-08-31','2013-08-31 20:49:23','2011-08-31',NULL,'PJ1308-0002',1,'prestation audit','audit de certification',1,0,1,NULL,NULL,'baleine');
/*!40000 ALTER TABLE `llx_projet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_projet_task`
--

DROP TABLE IF EXISTS `llx_projet_task`;
CREATE TABLE `llx_projet_task` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_projet` int(11) NOT NULL,
  `fk_task_parent` int(11) NOT NULL default '0',
  `datec` datetime default NULL,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `dateo` datetime default NULL,
  `datee` datetime default NULL,
  `datev` datetime default NULL,
  `label` varchar(255) NOT NULL,
  `description` text,
  `duration_effective` double NOT NULL default '0',
  `progress` int(11) default '0',
  `priority` int(11) default '0',
  `fk_user_creat` int(11) default NULL,
  `fk_user_valid` int(11) default NULL,
  `fk_statut` smallint(6) NOT NULL default '0',
  `note_private` text,
  `note_public` text,
  `rang` int(11) default '0',
  PRIMARY KEY  (`rowid`),
  KEY `idx_projet_task_fk_projet` (`fk_projet`),
  KEY `idx_projet_task_fk_user_creat` (`fk_user_creat`),
  KEY `idx_projet_task_fk_user_valid` (`fk_user_valid`),
  CONSTRAINT `fk_projet_task_fk_projet` FOREIGN KEY (`fk_projet`) REFERENCES `llx_projet` (`rowid`),
  CONSTRAINT `fk_projet_task_fk_user_creat` FOREIGN KEY (`fk_user_creat`) REFERENCES `llx_user` (`rowid`),
  CONSTRAINT `fk_projet_task_fk_user_valid` FOREIGN KEY (`fk_user_valid`) REFERENCES `llx_user` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_projet_task`
--

LOCK TABLES `llx_projet_task` WRITE;
/*!40000 ALTER TABLE `llx_projet_task` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_projet_task` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_projet_task_time`
--

DROP TABLE IF EXISTS `llx_projet_task_time`;
CREATE TABLE `llx_projet_task_time` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_task` int(11) NOT NULL,
  `task_date` date default NULL,
  `task_duration` double default NULL,
  `fk_user` int(11) default NULL,
  `note` text,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_projet_task_time`
--

LOCK TABLES `llx_projet_task_time` WRITE;
/*!40000 ALTER TABLE `llx_projet_task_time` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_projet_task_time` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_propal`
--

DROP TABLE IF EXISTS `llx_propal`;
CREATE TABLE `llx_propal` (
  `rowid` int(11) NOT NULL auto_increment,
  `ref` varchar(30) NOT NULL,
  `entity` int(11) NOT NULL default '1',
  `ref_ext` varchar(50) default NULL,
  `ref_int` varchar(50) default NULL,
  `ref_client` varchar(50) default NULL,
  `fk_soc` int(11) default NULL,
  `fk_projet` int(11) default '0',
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `datec` datetime default NULL,
  `datep` date default NULL,
  `fin_validite` datetime default NULL,
  `date_valid` datetime default NULL,
  `date_cloture` datetime default NULL,
  `fk_user_author` int(11) default NULL,
  `fk_user_valid` int(11) default NULL,
  `fk_user_cloture` int(11) default NULL,
  `fk_statut` smallint(6) NOT NULL default '0',
  `price` double default '0',
  `remise_percent` double default '0',
  `remise_absolue` double default '0',
  `remise` double default '0',
  `total_ht` double(24,8) default '0.00000000',
  `tva` double(24,8) default '0.00000000',
  `localtax1` double(24,8) default '0.00000000',
  `localtax2` double(24,8) default '0.00000000',
  `total` double(24,8) default '0.00000000',
  `fk_cond_reglement` int(11) default NULL,
  `fk_mode_reglement` int(11) default NULL,
  `note` text,
  `note_public` text,
  `model_pdf` varchar(255) default NULL,
  `date_livraison` date default NULL,
  `fk_availability` int(11) default NULL,
  `fk_demand_reason` int(11) default NULL,
  `fk_adresse_livraison` int(11) default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_propal_ref` (`ref`,`entity`),
  KEY `idx_propal_fk_soc` (`fk_soc`),
  CONSTRAINT `fk_propal_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_propal`
--

LOCK TABLES `llx_propal` WRITE;
/*!40000 ALTER TABLE `llx_propal` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_propal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_propaldet`
--

DROP TABLE IF EXISTS `llx_propaldet`;
CREATE TABLE `llx_propaldet` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_propal` int(11) NOT NULL,
  `fk_parent_line` int(11) default NULL,
  `fk_product` int(11) default NULL,
  `description` text,
  `fk_remise_except` int(11) default NULL,
  `tva_tx` double(6,3) default '0.000',
  `localtax1_tx` double(6,3) default '0.000',
  `localtax2_tx` double(6,3) default '0.000',
  `qty` double default NULL,
  `remise_percent` double default '0',
  `remise` double default '0',
  `price` double default NULL,
  `subprice` double(24,8) default '0.00000000',
  `total_ht` double(24,8) default '0.00000000',
  `total_tva` double(24,8) default '0.00000000',
  `total_localtax1` double(24,8) default '0.00000000',
  `total_localtax2` double(24,8) default '0.00000000',
  `total_ttc` double(24,8) default '0.00000000',
  `product_type` int(11) default '0',
  `date_start` datetime default NULL,
  `date_end` datetime default NULL,
  `info_bits` int(11) default '0',
  `pa_ht` double(24,8) default '0.00000000',
  `marge_tx` double(6,3) default '0.000',
  `marque_tx` double(6,3) default '0.000',
  `special_code` int(11) default '0',
  `rang` int(11) default '0',
  PRIMARY KEY  (`rowid`),
  KEY `idx_propaldet_fk_propal` (`fk_propal`),
  KEY `idx_propaldet_fk_product` (`fk_product`),
  CONSTRAINT `fk_propaldet_fk_propal` FOREIGN KEY (`fk_propal`) REFERENCES `llx_propal` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_propaldet`
--

LOCK TABLES `llx_propaldet` WRITE;
/*!40000 ALTER TABLE `llx_propaldet` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_propaldet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_rights_def`
--

DROP TABLE IF EXISTS `llx_rights_def`;
CREATE TABLE `llx_rights_def` (
  `id` int(11) NOT NULL default '0',
  `libelle` varchar(255) default NULL,
  `module` varchar(64) default NULL,
  `entity` int(11) NOT NULL default '1',
  `perms` varchar(50) default NULL,
  `subperms` varchar(50) default NULL,
  `type` varchar(1) default NULL,
  `bydefault` tinyint(4) default '0',
  PRIMARY KEY  (`id`,`entity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_rights_def`
--

LOCK TABLES `llx_rights_def` WRITE;
/*!40000 ALTER TABLE `llx_rights_def` DISABLE KEYS */;
INSERT INTO `llx_rights_def` VALUES (11,'Lire les factures','facture',1,'lire',NULL,'a',1),(12,'Creer/modifier les factures','facture',1,'creer',NULL,'a',0),(13,'Dévalider les factures','facture',1,'invoice_advance','unvalidate','a',0),(14,'Valider les factures','facture',1,'valider',NULL,'a',0),(15,'Envoyer les factures par mail','facture',1,'invoice_advance','send','a',0),(16,'Emettre des paiements sur les factures','facture',1,'paiement',NULL,'a',0),(19,'Supprimer les factures','facture',1,'supprimer',NULL,'a',0),(21,'Lire les propositions commerciales','propale',1,'lire',NULL,'r',1),(22,'Creer/modifier les propositions commerciales','propale',1,'creer',NULL,'w',0),(24,'Valider les propositions commerciales','propale',1,'valider',NULL,'d',0),(25,'Envoyer les propositions commerciales aux clients','propale',1,'propal_advance','send','d',0),(26,'Cloturer les propositions commerciales','propale',1,'cloturer',NULL,'d',0),(27,'Supprimer les propositions commerciales','propale',1,'supprimer',NULL,'d',0),(28,'Exporter les propositions commerciales et attributs','propale',1,'export',NULL,'r',0),(41,'Lire les projets et taches (partagés ou dont je suis contact)','projet',1,'lire',NULL,'r',1),(42,'Creer/modifier les projets et taches (partagés ou dont je suis contact)','projet',1,'creer',NULL,'w',0),(44,'Supprimer les projets et taches (partagés ou dont je suis contact)','projet',1,'supprimer',NULL,'d',0),(61,'Lire les fiches d\'intervention','ficheinter',1,'lire',NULL,'r',1),(62,'Creer/modifier les fiches d\'intervention','ficheinter',1,'creer',NULL,'w',0),(64,'Supprimer les fiches d\'intervention','ficheinter',1,'supprimer',NULL,'d',0),(67,'Exporter les fiches interventions','ficheinter',1,'export',NULL,'r',0),(68,'Envoyer les fiches d\'intervention par courriel','ficheinter',1,'ficheinter_advance','send','r',0),(81,'Lire les commandes clients','commande',1,'lire',NULL,'r',1),(82,'Creer/modifier les commandes clients','commande',1,'creer',NULL,'w',0),(84,'Valider les commandes clients','commande',1,'valider',NULL,'d',0),(86,'Envoyer les commandes clients','commande',1,'order_advance','send','d',0),(87,'Cloturer les commandes clients','commande',1,'cloturer',NULL,'d',0),(88,'Annuler les commandes clients','commande',1,'annuler',NULL,'d',0),(89,'Supprimer les commandes clients','commande',1,'supprimer',NULL,'d',0),(91,'Lire les charges','tax',1,'charges','lire','r',1),(92,'Creer/modifier les charges','tax',1,'charges','creer','w',0),(93,'Supprimer les charges','tax',1,'charges','supprimer','d',0),(94,'Exporter les charges','tax',1,'charges','export','r',0),(95,'Lire CA, bilans, resultats','compta',1,'resultat','lire','r',1),(96,'Parametrer la ventilation','compta',1,'ventilation','parametrer','r',0),(97,'Lire les ventilations de factures','compta',1,'ventilation','lire','r',1),(98,'Ventiler les lignes de factures','compta',1,'ventilation','creer','r',0),(101,'Lire les expeditions','expedition',1,'lire',NULL,'r',1),(102,'Creer modifier les expeditions','expedition',1,'creer',NULL,'w',0),(104,'Valider les expeditions','expedition',1,'valider',NULL,'d',0),(105,'Envoyer les expeditions aux clients','expedition',1,'shipping_advance','send','d',0),(109,'Supprimer les expeditions','expedition',1,'supprimer',NULL,'d',0),(111,'Lire les comptes bancaires','banque',1,'lire',NULL,'r',1),(112,'Creer/modifier montant/supprimer ecriture bancaire','banque',1,'modifier',NULL,'w',0),(113,'Configurer les comptes bancaires (creer, gerer categories)','banque',1,'configurer',NULL,'a',0),(114,'Rapprocher les ecritures bancaires','banque',1,'consolidate',NULL,'w',0),(115,'Exporter transactions et releves','banque',1,'export',NULL,'r',0),(116,'Virements entre comptes','banque',1,'transfer',NULL,'w',0),(117,'Gerer les envois de cheques','banque',1,'cheque',NULL,'w',0),(121,'Lire les societes','societe',1,'lire',NULL,'r',1),(122,'Creer modifier les societes','societe',1,'creer',NULL,'w',0),(125,'Supprimer les societes','societe',1,'supprimer',NULL,'d',0),(126,'Exporter les societes','societe',1,'export',NULL,'r',0),(141,'Lire tous les projets et taches (y compris prives qui ne me sont pas affectes)','projet',1,'all','lire','r',0),(142,'Creer/modifier tous les projets et taches (y compris prives qui ne me sont pas affectes)','projet',1,'all','creer','w',0),(144,'Supprimer tous les projets et taches (y compris prives qui ne me sont pas affectes)','projet',1,'all','supprimer','d',0),(151,'Read withdrawals','prelevement',1,'bons','lire','r',1),(152,'Create/modify a withdrawals','prelevement',1,'bons','creer','w',0),(153,'Send withdrawals to bank','prelevement',1,'bons','send','a',0),(154,'credit/refuse withdrawals','prelevement',1,'bons','credit','a',0),(161,'Lire les contrats','contrat',1,'lire',NULL,'r',1),(162,'Creer / modifier les contrats','contrat',1,'creer',NULL,'w',0),(163,'Activer un service d\'un contrat','contrat',1,'activer',NULL,'w',0),(164,'Desactiver un service d\'un contrat','contrat',1,'desactiver',NULL,'w',0),(165,'Supprimer un contrat','contrat',1,'supprimer',NULL,'d',0),(171,'Lire les deplacements','deplacement',1,'lire',NULL,'r',1),(172,'Creer/modifier les deplacements','deplacement',1,'creer',NULL,'w',0),(173,'Supprimer les deplacements','deplacement',1,'supprimer',NULL,'d',0),(178,'Exporter les deplacements','deplacement',1,'export',NULL,'d',0),(221,'Consulter les mailings','mailing',1,'lire',NULL,'r',1),(222,'Creer/modifier les mailings (sujet, destinataires...)','mailing',1,'creer',NULL,'w',0),(223,'Valider les mailings (permet leur envoi)','mailing',1,'valider',NULL,'w',0),(229,'Supprimer les mailings)','mailing',1,'supprimer',NULL,'d',0),(251,'Consulter les autres utilisateurs','user',1,'user','lire','r',0),(252,'Consulter les permissions des autres utilisateurs','user',1,'user_advance','readperms','r',0),(253,'Creer/modifier utilisateurs internes et externes','user',1,'user','creer','w',0),(254,'Creer/modifier utilisateurs externes seulement','user',1,'user_advance','write','w',0),(255,'Modifier le mot de passe des autres utilisateurs','user',1,'user','password','w',0),(256,'Supprimer ou desactiver les autres utilisateurs','user',1,'user','supprimer','d',0),(262,'Consulter tous les tiers par utilisateurs internes (sinon uniquement si contact commercial). Non effectif pour utilisateurs externes (tjs limités à eux-meme).','societe',1,'client','voir','r',1),(281,'Lire les contacts','societe',1,'contact','lire','r',1),(282,'Creer modifier les contacts','societe',1,'contact','creer','w',0),(283,'Supprimer les contacts','societe',1,'contact','supprimer','d',0),(286,'Exporter les contacts','societe',1,'contact','export','d',0),(331,'Lire les bookmarks','bookmark',1,'lire',NULL,'r',1),(332,'Creer/modifier les bookmarks','bookmark',1,'creer',NULL,'r',1),(333,'Supprimer les bookmarks','bookmark',1,'supprimer',NULL,'r',1),(341,'Consulter ses propres permissions','user',1,'self_advance','readperms','r',1),(342,'Creer/modifier ses propres infos utilisateur','user',1,'self','creer','w',1),(343,'Modifier son propre mot de passe','user',1,'self','password','w',1),(344,'Modifier ses propres permissions','user',1,'self_advance','writeperms','w',1),(351,'Consulter les groupes','user',1,'group_advance','read','r',0),(352,'Consulter les permissions des groupes','user',1,'group_advance','readperms','r',0),(353,'Creer/modifier les groupes et leurs permissions','user',1,'group_advance','write','w',0),(354,'Supprimer ou desactiver les groupes','user',1,'group_advance','delete','d',0),(358,'Exporter les utilisateurs','user',1,'user','export','r',0),(531,'Lire les services','service',1,'lire',NULL,'r',1),(532,'Creer/modifier les services','service',1,'creer',NULL,'w',0),(534,'Supprimer les services','service',1,'supprimer',NULL,'d',0),(538,'Exporter les services','service',1,'export',NULL,'r',0),(701,'Lire les dons','don',1,'lire',NULL,'r',1),(702,'Creer/modifier les dons','don',1,'creer',NULL,'w',0),(703,'Supprimer les dons','don',1,'supprimer',NULL,'d',0),(1101,'Lire les bons de livraison','expedition',1,'livraison','lire','r',1),(1102,'Creer modifier les bons de livraison','expedition',1,'livraison','creer','w',0),(1104,'Valider les bons de livraison','expedition',1,'livraison','valider','d',0),(1109,'Supprimer les bons de livraison','expedition',1,'livraison','supprimer','d',0),(1181,'Consulter les fournisseurs','fournisseur',1,'lire',NULL,'r',1),(1182,'Consulter les commandes fournisseur','fournisseur',1,'commande','lire','r',1),(1183,'Creer une commande fournisseur','fournisseur',1,'commande','creer','w',0),(1184,'Valider une commande fournisseur','fournisseur',1,'commande','valider','w',0),(1185,'Approuver une commande fournisseur','fournisseur',1,'commande','approuver','w',0),(1186,'Commander une commande fournisseur','fournisseur',1,'commande','commander','w',0),(1187,'Receptionner une commande fournisseur','fournisseur',1,'commande','receptionner','d',0),(1188,'Supprimer une commande fournisseur','fournisseur',1,'commande','supprimer','d',0),(1201,'Lire les exports','export',1,'lire',NULL,'r',1),(1202,'Creer/modifier un export','export',1,'creer',NULL,'w',0),(1231,'Consulter les factures fournisseur','fournisseur',1,'facture','lire','r',1),(1232,'Creer une facture fournisseur','fournisseur',1,'facture','creer','w',0),(1233,'Valider une facture fournisseur','fournisseur',1,'facture','valider','w',0),(1234,'Supprimer une facture fournisseur','fournisseur',1,'facture','supprimer','d',0),(1235,'Envoyer les factures par mail','fournisseur',1,'supplier_invoice_advance','send','a',0),(1236,'Exporter les factures fournisseurs, attributs et reglements','fournisseur',1,'facture','export','r',0),(1251,'Run mass imports of external data (data load)','import',1,'run',NULL,'r',0),(1321,'Exporter les factures clients, attributs et reglements','facture',1,'facture','export','r',0),(1421,'Exporter les commandes clients et attributs','commande',1,'commande','export','r',0),(2401,'Read actions/tasks linked to his account','agenda',1,'myactions','read','r',1),(2402,'Create/modify actions/tasks linked to his account','agenda',1,'myactions','create','w',0),(2403,'Delete actions/tasks linked to his account','agenda',1,'myactions','delete','w',0),(2411,'Read actions/tasks of others','agenda',1,'allactions','read','r',0),(2412,'Create/modify actions/tasks of others','agenda',1,'allactions','create','w',0),(2413,'Delete actions/tasks of others','agenda',1,'allactions','delete','w',0),(2501,'Consulter/Télécharger les documents','ecm',1,'read',NULL,'r',1),(2503,'Soumettre ou supprimer des documents','ecm',1,'upload',NULL,'w',1),(2515,'Administrer les rubriques de documents','ecm',1,'setup',NULL,'w',1),(2801,'Use FTP client in read mode (browse and download only)','ftp',1,'read',NULL,'r',1),(2802,'Use FTP client in write mode (delete or upload files)','ftp',1,'write',NULL,'w',0);
/*!40000 ALTER TABLE `llx_rights_def` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_societe`
--

DROP TABLE IF EXISTS `llx_societe`;
CREATE TABLE `llx_societe` (
  `rowid` int(11) NOT NULL auto_increment,
  `nom` varchar(60) default NULL,
  `entity` int(11) NOT NULL default '1',
  `ref_ext` varchar(60) default NULL,
  `ref_int` varchar(60) default NULL,
  `statut` tinyint(4) default '0',
  `parent` int(11) default NULL,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `datec` datetime default NULL,
  `datea` datetime default NULL,
  `status` tinyint(4) default '1',
  `code_client` varchar(15) default NULL,
  `code_fournisseur` varchar(15) default NULL,
  `code_compta` varchar(15) default NULL,
  `code_compta_fournisseur` varchar(15) default NULL,
  `address` varchar(255) default NULL,
  `cp` varchar(10) default NULL,
  `ville` varchar(50) default NULL,
  `fk_departement` int(11) default '0',
  `fk_pays` int(11) default '0',
  `tel` varchar(20) default NULL,
  `fax` varchar(20) default NULL,
  `url` varchar(255) default NULL,
  `email` varchar(128) default NULL,
  `fk_secteur` int(11) default '0',
  `fk_effectif` int(11) default '0',
  `fk_typent` int(11) default '0',
  `fk_forme_juridique` int(11) default '0',
  `fk_currency` int(11) default '0',
  `siren` varchar(32) default NULL,
  `siret` varchar(32) default NULL,
  `ape` varchar(32) default NULL,
  `idprof4` varchar(32) default NULL,
  `tva_intra` varchar(20) default NULL,
  `capital` double default NULL,
  `description` text,
  `fk_stcomm` smallint(6) default '0',
  `note` text,
  `services` tinyint(4) default '0',
  `prefix_comm` varchar(5) default NULL,
  `client` tinyint(4) default '0',
  `fournisseur` tinyint(4) default '0',
  `supplier_account` varchar(32) default NULL,
  `fk_prospectlevel` varchar(12) default NULL,
  `customer_bad` tinyint(4) default '0',
  `customer_rate` double default '0',
  `supplier_rate` double default '0',
  `fk_user_creat` int(11) default NULL,
  `fk_user_modif` int(11) default NULL,
  `remise_client` double default '0',
  `mode_reglement` tinyint(4) default NULL,
  `cond_reglement` tinyint(4) default NULL,
  `tva_assuj` tinyint(4) default '1',
  `localtax1_assuj` tinyint(4) default '0',
  `localtax2_assuj` tinyint(4) default '0',
  `gencod` varchar(255) default NULL,
  `price_level` int(11) default NULL,
  `default_lang` varchar(6) default NULL,
  `logo` varchar(255) default NULL,
  `canvas` varchar(32) default NULL,
  `import_key` varchar(14) default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_societe_prefix_comm` (`prefix_comm`,`entity`),
  UNIQUE KEY `uk_societe_code_client` (`code_client`,`entity`),
  KEY `idx_societe_user_creat` (`fk_user_creat`),
  KEY `idx_societe_user_modif` (`fk_user_modif`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_societe`
--

LOCK TABLES `llx_societe` WRITE;
/*!40000 ALTER TABLE `llx_societe` DISABLE KEYS */;
INSERT INTO `llx_societe` VALUES (1,'PLASTIGRAY',1,NULL,NULL,0,NULL,'2013-08-31 19:04:51','2013-08-31 20:58:25','2013-08-31 21:04:51',1,'0001',NULL,'706000',NULL,'ZAC SUD\r\nRue PICARD','70104','GRAY',72,1,'0384647700','0384655109','www.plastigray.com','commercial@plastigray.com',0,5,3,57,0,'377846381','37784638100020','2229A','GRAY-VESOUL','FR 65377846381',2102400,NULL,0,NULL,0,NULL,1,0,NULL,NULL,0,0,0,1,1,0,NULL,1,1,NULL,NULL,NULL,NULL,'fr_FR',NULL,NULL,NULL),(2,'AFNOR CERTIFICATION',1,NULL,NULL,0,NULL,'2013-08-31 20:30:07','2013-08-31 22:18:05','2013-08-31 22:30:07',1,'0002','0006',NULL,NULL,'11 rue Francis de Pressensé','93571','La Plaine Saint Denis',95,1,'0141628000','0149179000','www.afnor.org/',NULL,0,5,2,57,0,'479076002','47907600200020','7120B','Bobigny B 479 076 002','FR67479076002',18187000,NULL,0,NULL,0,NULL,1,1,NULL,NULL,0,0,0,1,1,0,NULL,NULL,1,NULL,NULL,NULL,NULL,'fr_FR',NULL,NULL,NULL),(3,'SIMU',1,NULL,NULL,0,NULL,'2013-09-19 19:19:46','2013-09-19 21:19:46','2013-09-19 21:19:46',1,'003',NULL,NULL,NULL,'BP 71','70103','GRAY',72,1,'0384647500','0384647599','www.simu.com','sophie.sedan@simu.com',0,5,3,57,0,'425650090','42565009000011','2711Z','Gray-Vesoul B 425 650 090','FR87425650090',5000000,NULL,0,NULL,0,NULL,3,0,NULL,NULL,0,0,0,1,1,0,NULL,NULL,1,NULL,NULL,NULL,NULL,'fr_FR',NULL,NULL,NULL);
/*!40000 ALTER TABLE `llx_societe` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_societe_address`
--

DROP TABLE IF EXISTS `llx_societe_address`;
CREATE TABLE `llx_societe_address` (
  `rowid` int(11) NOT NULL auto_increment,
  `datec` datetime default NULL,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `label` varchar(30) default NULL,
  `fk_soc` int(11) default '0',
  `name` varchar(60) default NULL,
  `address` varchar(255) default NULL,
  `cp` varchar(10) default NULL,
  `ville` varchar(50) default NULL,
  `fk_pays` int(11) default '0',
  `tel` varchar(20) default NULL,
  `fax` varchar(20) default NULL,
  `note` text,
  `fk_user_creat` int(11) default NULL,
  `fk_user_modif` int(11) default NULL,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_societe_address`
--

LOCK TABLES `llx_societe_address` WRITE;
/*!40000 ALTER TABLE `llx_societe_address` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_societe_address` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_societe_commerciaux`
--

DROP TABLE IF EXISTS `llx_societe_commerciaux`;
CREATE TABLE `llx_societe_commerciaux` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_soc` int(11) default NULL,
  `fk_user` int(11) default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_societe_commerciaux` (`fk_soc`,`fk_user`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_societe_commerciaux`
--

LOCK TABLES `llx_societe_commerciaux` WRITE;
/*!40000 ALTER TABLE `llx_societe_commerciaux` DISABLE KEYS */;
INSERT INTO `llx_societe_commerciaux` VALUES (1,1,1),(2,2,1),(3,3,1);
/*!40000 ALTER TABLE `llx_societe_commerciaux` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_societe_extrafields`
--

DROP TABLE IF EXISTS `llx_societe_extrafields`;
CREATE TABLE `llx_societe_extrafields` (
  `rowid` int(11) NOT NULL auto_increment,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  PRIMARY KEY  (`rowid`),
  KEY `idx_societe_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_societe_extrafields`
--

LOCK TABLES `llx_societe_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_societe_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_societe_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_societe_log`
--

DROP TABLE IF EXISTS `llx_societe_log`;
CREATE TABLE `llx_societe_log` (
  `id` int(11) NOT NULL auto_increment,
  `datel` datetime default NULL,
  `fk_soc` int(11) default NULL,
  `fk_statut` int(11) default NULL,
  `fk_user` int(11) default NULL,
  `author` varchar(30) default NULL,
  `label` varchar(128) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_societe_log`
--

LOCK TABLES `llx_societe_log` WRITE;
/*!40000 ALTER TABLE `llx_societe_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_societe_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_societe_prices`
--

DROP TABLE IF EXISTS `llx_societe_prices`;
CREATE TABLE `llx_societe_prices` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_soc` int(11) default '0',
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `datec` datetime default NULL,
  `fk_user_author` int(11) default NULL,
  `price_level` tinyint(4) default '1',
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_societe_prices`
--

LOCK TABLES `llx_societe_prices` WRITE;
/*!40000 ALTER TABLE `llx_societe_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_societe_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_societe_remise`
--

DROP TABLE IF EXISTS `llx_societe_remise`;
CREATE TABLE `llx_societe_remise` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_soc` int(11) NOT NULL,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `datec` datetime default NULL,
  `fk_user_author` int(11) default NULL,
  `remise_client` double(6,3) NOT NULL default '0.000',
  `note` text,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_societe_remise`
--

LOCK TABLES `llx_societe_remise` WRITE;
/*!40000 ALTER TABLE `llx_societe_remise` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_societe_remise` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_societe_remise_except`
--

DROP TABLE IF EXISTS `llx_societe_remise_except`;
CREATE TABLE `llx_societe_remise_except` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_soc` int(11) NOT NULL,
  `datec` datetime default NULL,
  `amount_ht` double(24,8) NOT NULL,
  `amount_tva` double(24,8) NOT NULL default '0.00000000',
  `amount_ttc` double(24,8) NOT NULL default '0.00000000',
  `tva_tx` double(6,3) NOT NULL default '0.000',
  `fk_user` int(11) NOT NULL,
  `fk_facture_line` int(11) default NULL,
  `fk_facture` int(11) default NULL,
  `fk_facture_source` int(11) default NULL,
  `description` varchar(255) NOT NULL,
  PRIMARY KEY  (`rowid`),
  KEY `idx_societe_remise_except_fk_user` (`fk_user`),
  KEY `idx_societe_remise_except_fk_soc` (`fk_soc`),
  KEY `idx_societe_remise_except_fk_facture_line` (`fk_facture_line`),
  KEY `idx_societe_remise_except_fk_facture` (`fk_facture`),
  KEY `idx_societe_remise_except_fk_facture_source` (`fk_facture_source`),
  CONSTRAINT `fk_societe_remise_fk_facture` FOREIGN KEY (`fk_facture`) REFERENCES `llx_facture` (`rowid`),
  CONSTRAINT `fk_societe_remise_fk_facture_line` FOREIGN KEY (`fk_facture_line`) REFERENCES `llx_facturedet` (`rowid`),
  CONSTRAINT `fk_societe_remise_fk_facture_source` FOREIGN KEY (`fk_facture_source`) REFERENCES `llx_facture` (`rowid`),
  CONSTRAINT `fk_societe_remise_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`),
  CONSTRAINT `fk_societe_remise_fk_user` FOREIGN KEY (`fk_user`) REFERENCES `llx_user` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_societe_remise_except`
--

LOCK TABLES `llx_societe_remise_except` WRITE;
/*!40000 ALTER TABLE `llx_societe_remise_except` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_societe_remise_except` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_societe_rib`
--

DROP TABLE IF EXISTS `llx_societe_rib`;
CREATE TABLE `llx_societe_rib` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_soc` int(11) NOT NULL,
  `datec` datetime default NULL,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `label` varchar(30) default NULL,
  `bank` varchar(255) default NULL,
  `code_banque` varchar(7) default NULL,
  `code_guichet` varchar(6) default NULL,
  `number` varchar(255) default NULL,
  `cle_rib` varchar(5) default NULL,
  `bic` varchar(10) default NULL,
  `iban_prefix` varchar(34) default NULL,
  `domiciliation` varchar(255) default NULL,
  `proprio` varchar(60) default NULL,
  `adresse_proprio` varchar(255) default NULL,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_societe_rib`
--

LOCK TABLES `llx_societe_rib` WRITE;
/*!40000 ALTER TABLE `llx_societe_rib` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_societe_rib` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_socpeople`
--

DROP TABLE IF EXISTS `llx_socpeople`;
CREATE TABLE `llx_socpeople` (
  `rowid` int(11) NOT NULL auto_increment,
  `datec` datetime default NULL,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `fk_soc` int(11) default NULL,
  `entity` int(11) NOT NULL default '1',
  `civilite` varchar(6) default NULL,
  `name` varchar(50) default NULL,
  `firstname` varchar(50) default NULL,
  `address` varchar(255) default NULL,
  `cp` varchar(25) default NULL,
  `ville` varchar(255) default NULL,
  `fk_departement` int(11) default NULL,
  `fk_pays` int(11) default '0',
  `birthday` date default NULL,
  `poste` varchar(80) default NULL,
  `phone` varchar(30) default NULL,
  `phone_perso` varchar(30) default NULL,
  `phone_mobile` varchar(30) default NULL,
  `fax` varchar(30) default NULL,
  `email` varchar(255) default NULL,
  `jabberid` varchar(255) default NULL,
  `priv` smallint(6) NOT NULL default '0',
  `fk_user_creat` int(11) default '0',
  `fk_user_modif` int(11) default NULL,
  `note` text,
  `default_lang` varchar(6) default NULL,
  `canvas` varchar(32) default NULL,
  `import_key` varchar(14) default NULL,
  PRIMARY KEY  (`rowid`),
  KEY `idx_socpeople_fk_soc` (`fk_soc`),
  KEY `idx_socpeople_fk_user_creat` (`fk_user_creat`),
  CONSTRAINT `fk_socpeople_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`),
  CONSTRAINT `fk_socpeople_user_creat_user_rowid` FOREIGN KEY (`fk_user_creat`) REFERENCES `llx_user` (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_socpeople`
--

LOCK TABLES `llx_socpeople` WRITE;
/*!40000 ALTER TABLE `llx_socpeople` DISABLE KEYS */;
INSERT INTO `llx_socpeople` VALUES (1,'2013-08-31 21:07:53','2013-08-31 19:07:53',1,1,'MR','GAUSS','Emmanuel','ZAC SUD\r\nRue PICARD\r\n','70104','GRAY',72,1,NULL,'DG','0384647725','','0686167627','0384655109','emmanuel.gauss@plastigray.com','',0,1,1,'',NULL,NULL,NULL),(2,'2013-08-31 22:42:36','2013-08-31 20:42:36',2,1,'MR','GUEUGNOT','GILLES',' 11 rue Francis de Pressensé','93571',' La Plaine Saint Denis ',95,1,NULL,'Responsable DGECE','0141626121','','','','gilles.gueugnot@afnor.org','',0,1,1,'',NULL,NULL,NULL),(3,'2013-10-19 17:19:34','2013-10-19 15:19:34',2,1,'MR','CAPLAIN','Frédéric','11 rue Francis de Pressensé',' 93571','La Plaine Saint-Denis',95,1,NULL,'chargé d\'affaires PTPE3','+33 1 41 62 60 46','','','','frederic.caplain@afnor.org','',0,1,1,'',NULL,NULL,NULL),(4,'2013-10-19 17:24:51','2013-10-19 15:24:51',2,1,'MME','GIRARD','Valérie','11 rue Francis de Pressensé ',' 93571','La Plaine Saint-Denis ',94,1,NULL,'chargé d\'affaires PTPE3','01 41 62 61 22','','','','valerie.girard@afnor.org','',0,1,1,'',NULL,NULL,NULL),(5,'2013-10-20 16:38:55','2013-10-20 14:38:55',2,1,'MME','VIOLEAU','Emeline','11 rue Francis de Pressensé','93571','La Plaine Saint Denis',95,1,NULL,'chargé d\'affaire PPME2','01 41 62 62 60','','','','emeline.violeau@afnor.org','',0,1,1,'',NULL,NULL,NULL),(6,'2013-10-20 16:52:33','2013-10-20 14:52:33',2,1,'MME','FERAL','Véronique','11 rue Francis de Pressensé','93571','La Plaine Saint Denis',95,1,NULL,'chargé d\'affaire PPME2','0141626101','','','','veronique.feral@afnor.org','',0,1,1,'',NULL,NULL,NULL),(7,'2013-10-20 17:04:27','2013-10-20 15:04:27',2,1,'MME','NEVOSO','Tiphaine','11 rue Francis de Pressensé','93571','La Plaine Saint Denis',95,1,NULL,'chargé d\'affaire PPME3','0141626096','','','','tiphaine.nevoso@afnor.org','',0,1,1,'',NULL,NULL,NULL);
/*!40000 ALTER TABLE `llx_socpeople` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_stock_mouvement`
--

DROP TABLE IF EXISTS `llx_stock_mouvement`;
CREATE TABLE `llx_stock_mouvement` (
  `rowid` int(11) NOT NULL auto_increment,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `datem` datetime default NULL,
  `fk_product` int(11) NOT NULL,
  `fk_entrepot` int(11) NOT NULL,
  `value` int(11) default NULL,
  `price` float(13,4) default '0.0000',
  `type_mouvement` smallint(6) default NULL,
  `fk_user_author` int(11) default NULL,
  `label` varchar(128) default NULL,
  PRIMARY KEY  (`rowid`),
  KEY `idx_stock_mouvement_fk_product` (`fk_product`),
  KEY `idx_stock_mouvement_fk_entrepot` (`fk_entrepot`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_stock_mouvement`
--

LOCK TABLES `llx_stock_mouvement` WRITE;
/*!40000 ALTER TABLE `llx_stock_mouvement` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_stock_mouvement` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_texts`
--

DROP TABLE IF EXISTS `llx_texts`;
CREATE TABLE `llx_texts` (
  `rowid` int(11) NOT NULL auto_increment,
  `module` varchar(32) default NULL,
  `typemodele` varchar(32) default NULL,
  `sortorder` smallint(6) default NULL,
  `private` smallint(6) NOT NULL default '0',
  `fk_user` int(11) default NULL,
  `title` varchar(128) default NULL,
  `filename` varchar(128) default NULL,
  `content` text,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_texts`
--

LOCK TABLES `llx_texts` WRITE;
/*!40000 ALTER TABLE `llx_texts` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_texts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_tva`
--

DROP TABLE IF EXISTS `llx_tva`;
CREATE TABLE `llx_tva` (
  `rowid` int(11) NOT NULL auto_increment,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `datep` date default NULL,
  `datev` date default NULL,
  `amount` double NOT NULL default '0',
  `label` varchar(255) default NULL,
  `entity` int(11) NOT NULL default '1',
  `note` text,
  `fk_bank` int(11) default NULL,
  `fk_user_creat` int(11) default NULL,
  `fk_user_modif` int(11) default NULL,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_tva`
--

LOCK TABLES `llx_tva` WRITE;
/*!40000 ALTER TABLE `llx_tva` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_tva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_user`
--

DROP TABLE IF EXISTS `llx_user`;
CREATE TABLE `llx_user` (
  `rowid` int(11) NOT NULL auto_increment,
  `entity` int(11) NOT NULL default '1',
  `ref_ext` varchar(30) default NULL,
  `datec` datetime default NULL,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `login` varchar(24) NOT NULL,
  `pass` varchar(32) default NULL,
  `pass_crypted` varchar(128) default NULL,
  `pass_temp` varchar(32) default NULL,
  `civilite` varchar(6) default NULL,
  `name` varchar(50) default NULL,
  `firstname` varchar(50) default NULL,
  `office_phone` varchar(20) default NULL,
  `office_fax` varchar(20) default NULL,
  `user_mobile` varchar(20) default NULL,
  `email` varchar(255) default NULL,
  `signature` text,
  `admin` smallint(6) default '0',
  `webcal_login` varchar(25) default NULL,
  `phenix_login` varchar(25) default NULL,
  `phenix_pass` varchar(128) default NULL,
  `module_comm` smallint(6) default '1',
  `module_compta` smallint(6) default '1',
  `fk_societe` int(11) default NULL,
  `fk_socpeople` int(11) default NULL,
  `fk_member` int(11) default NULL,
  `note` text,
  `datelastlogin` datetime default NULL,
  `datepreviouslogin` datetime default NULL,
  `egroupware_id` int(11) default NULL,
  `ldap_sid` varchar(255) default NULL,
  `openid` varchar(255) default NULL,
  `statut` tinyint(4) default '1',
  `photo` varchar(255) default NULL,
  `lang` varchar(6) default NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_user_login` (`login`,`entity`),
  UNIQUE KEY `uk_user_fk_socpeople` (`fk_socpeople`),
  UNIQUE KEY `uk_user_fk_member` (`fk_member`),
  KEY `uk_user_fk_societe` (`fk_societe`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_user`
--

LOCK TABLES `llx_user` WRITE;
/*!40000 ALTER TABLE `llx_user` DISABLE KEYS */;
INSERT INTO `llx_user` VALUES (1,0,NULL,'2013-08-28 19:09:37','2013-08-28 17:09:37','admin','CX6gr70100G','84783f3d9a92f0038c2ab5315432ffe3',NULL,NULL,'SuperAdmin','','','','','','',1,'','','',1,1,NULL,NULL,NULL,'','2013-10-21 07:56:23','2013-10-20 16:18:21',NULL,'',NULL,1,NULL,NULL);
/*!40000 ALTER TABLE `llx_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_user_alert`
--

DROP TABLE IF EXISTS `llx_user_alert`;
CREATE TABLE `llx_user_alert` (
  `rowid` int(11) NOT NULL auto_increment,
  `type` int(11) default NULL,
  `fk_contact` int(11) default NULL,
  `fk_user` int(11) default NULL,
  PRIMARY KEY  (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_user_alert`
--

LOCK TABLES `llx_user_alert` WRITE;
/*!40000 ALTER TABLE `llx_user_alert` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_user_alert` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_user_clicktodial`
--

DROP TABLE IF EXISTS `llx_user_clicktodial`;
CREATE TABLE `llx_user_clicktodial` (
  `fk_user` int(11) NOT NULL,
  `login` varchar(32) default NULL,
  `pass` varchar(64) default NULL,
  `poste` varchar(20) default NULL,
  PRIMARY KEY  (`fk_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_user_clicktodial`
--

LOCK TABLES `llx_user_clicktodial` WRITE;
/*!40000 ALTER TABLE `llx_user_clicktodial` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_user_clicktodial` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_user_param`
--

DROP TABLE IF EXISTS `llx_user_param`;
CREATE TABLE `llx_user_param` (
  `fk_user` int(11) NOT NULL,
  `entity` int(11) NOT NULL default '1',
  `param` varchar(64) NOT NULL,
  `value` varchar(255) NOT NULL,
  UNIQUE KEY `uk_user_param` (`fk_user`,`param`,`entity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_user_param`
--

LOCK TABLES `llx_user_param` WRITE;
/*!40000 ALTER TABLE `llx_user_param` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_user_param` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_user_rights`
--

DROP TABLE IF EXISTS `llx_user_rights`;
CREATE TABLE `llx_user_rights` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_user` int(11) NOT NULL,
  `fk_id` int(11) NOT NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_user_rights` (`fk_user`,`fk_id`),
  CONSTRAINT `fk_user_rights_fk_user_user` FOREIGN KEY (`fk_user`) REFERENCES `llx_user` (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=411 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_user_rights`
--

LOCK TABLES `llx_user_rights` WRITE;
/*!40000 ALTER TABLE `llx_user_rights` DISABLE KEYS */;
INSERT INTO `llx_user_rights` VALUES (257,1,11),(250,1,12),(251,1,13),(253,1,14),(254,1,15),(256,1,16),(258,1,19),(30,1,21),(22,1,22),(24,1,24),(25,1,25),(27,1,26),(29,1,27),(31,1,28),(365,1,41),(364,1,42),(366,1,44),(96,1,61),(93,1,62),(95,1,64),(97,1,67),(98,1,68),(139,1,81),(131,1,82),(133,1,84),(134,1,86),(136,1,87),(138,1,88),(140,1,89),(239,1,91),(236,1,92),(238,1,93),(240,1,94),(162,1,95),(163,1,96),(165,1,97),(166,1,98),(120,1,101),(116,1,102),(118,1,104),(119,1,105),(121,1,109),(311,1,111),(302,1,112),(304,1,113),(306,1,114),(308,1,115),(310,1,116),(312,1,117),(342,1,121),(339,1,122),(341,1,125),(343,1,126),(370,1,141),(369,1,142),(371,1,144),(246,1,151),(243,1,152),(245,1,153),(247,1,154),(82,1,161),(77,1,162),(79,1,163),(81,1,164),(83,1,165),(298,1,171),(295,1,172),(297,1,173),(299,1,178),(377,1,221),(374,1,222),(376,1,223),(378,1,229),(344,1,262),(350,1,281),(347,1,282),(349,1,283),(351,1,286),(386,1,331),(385,1,332),(387,1,333),(1,1,341),(2,1,342),(3,1,343),(4,1,344),(89,1,531),(86,1,532),(88,1,534),(90,1,538),(291,1,701),(290,1,702),(292,1,703),(127,1,1101),(124,1,1102),(126,1,1104),(128,1,1109),(313,1,1181),(325,1,1182),(316,1,1183),(318,1,1184),(320,1,1185),(322,1,1186),(324,1,1187),(326,1,1188),(380,1,1201),(381,1,1202),(335,1,1231),(329,1,1232),(331,1,1233),(333,1,1234),(334,1,1235),(336,1,1236),(382,1,1251),(259,1,1321),(141,1,1421),(394,1,2401),(393,1,2402),(395,1,2403),(399,1,2411),(398,1,2412),(400,1,2413),(160,1,2501),(159,1,2503),(161,1,2515),(389,1,2801),(390,1,2802);
/*!40000 ALTER TABLE `llx_user_rights` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_usergroup`
--

DROP TABLE IF EXISTS `llx_usergroup`;
CREATE TABLE `llx_usergroup` (
  `rowid` int(11) NOT NULL auto_increment,
  `nom` varchar(255) NOT NULL,
  `entity` int(11) NOT NULL default '1',
  `datec` datetime default NULL,
  `tms` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `note` text,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_usergroup_name` (`nom`,`entity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_usergroup`
--

LOCK TABLES `llx_usergroup` WRITE;
/*!40000 ALTER TABLE `llx_usergroup` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_usergroup` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_usergroup_rights`
--

DROP TABLE IF EXISTS `llx_usergroup_rights`;
CREATE TABLE `llx_usergroup_rights` (
  `rowid` int(11) NOT NULL auto_increment,
  `fk_usergroup` int(11) NOT NULL,
  `fk_id` int(11) NOT NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `fk_usergroup` (`fk_usergroup`,`fk_id`),
  CONSTRAINT `fk_usergroup_rights_fk_usergroup` FOREIGN KEY (`fk_usergroup`) REFERENCES `llx_usergroup` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_usergroup_rights`
--

LOCK TABLES `llx_usergroup_rights` WRITE;
/*!40000 ALTER TABLE `llx_usergroup_rights` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_usergroup_rights` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_usergroup_user`
--

DROP TABLE IF EXISTS `llx_usergroup_user`;
CREATE TABLE `llx_usergroup_user` (
  `rowid` int(11) NOT NULL auto_increment,
  `entity` int(11) NOT NULL default '1',
  `fk_user` int(11) NOT NULL,
  `fk_usergroup` int(11) NOT NULL,
  PRIMARY KEY  (`rowid`),
  UNIQUE KEY `uk_usergroup_user` (`entity`,`fk_user`,`fk_usergroup`),
  KEY `fk_usergroup_user_fk_user` (`fk_user`),
  KEY `fk_usergroup_user_fk_usergroup` (`fk_usergroup`),
  CONSTRAINT `fk_usergroup_user_fk_user` FOREIGN KEY (`fk_user`) REFERENCES `llx_user` (`rowid`),
  CONSTRAINT `fk_usergroup_user_fk_usergroup` FOREIGN KEY (`fk_usergroup`) REFERENCES `llx_usergroup` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `llx_usergroup_user`
--

LOCK TABLES `llx_usergroup_user` WRITE;
/*!40000 ALTER TABLE `llx_usergroup_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_usergroup_user` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2013-10-21  5:59:48
